/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsServerPing;
import com.mojang.realmsclient.dto.RealmsServerPlayerList;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.realms.Realms;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsServer
extends cza {
    private static final Logger LOGGER = LogManager.getLogger();
    public long id;
    public String remoteSubscriptionId;
    public String name;
    public String motd;
    public b state;
    public String owner;
    public String ownerUUID;
    public List<PlayerInfo> players;
    public Map<Integer, RealmsWorldOptions> slots;
    public boolean expired;
    public boolean expiredTrial;
    public int daysLeft;
    public c worldType;
    public int activeSlot;
    public String minigameName;
    public int minigameId;
    public String minigameImage;
    public RealmsServerPing serverPing = new RealmsServerPing();

    public String getDescription() {
        return this.motd;
    }

    public String getName() {
        return this.name;
    }

    public String getMinigameName() {
        return this.minigameName;
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.motd = string;
    }

    public void updateServerPing(RealmsServerPlayerList realmsServerPlayerList) {
        StringBuilder stringBuilder = new StringBuilder();
        int \u26032 = 0;
        for (String string : realmsServerPlayerList.players) {
            if (string.equals(Realms.getUUID())) continue;
            \u2603 = "";
            try {
                \u2603 = das.a(string);
            }
            catch (Exception exception) {
                LOGGER.error("Could not get name for " + string, (Throwable)exception);
                continue;
            }
            if (stringBuilder.length() > 0) {
                stringBuilder.append("\n");
            }
            stringBuilder.append(\u2603);
            ++\u26032;
        }
        this.serverPing.nrOfPlayers = String.valueOf(\u26032);
        this.serverPing.playerList = stringBuilder.toString();
    }

    public static RealmsServer parse(JsonObject jsonObject) {
        RealmsServer realmsServer = new RealmsServer();
        try {
            realmsServer.id = dao.a("id", jsonObject, -1L);
            realmsServer.remoteSubscriptionId = dao.a("remoteSubscriptionId", jsonObject, null);
            realmsServer.name = dao.a("name", jsonObject, null);
            realmsServer.motd = dao.a("motd", jsonObject, null);
            realmsServer.state = RealmsServer.getState(dao.a("state", jsonObject, b.a.name()));
            realmsServer.owner = dao.a("owner", jsonObject, null);
            if (jsonObject.get("players") != null && jsonObject.get("players").isJsonArray()) {
                realmsServer.players = RealmsServer.parseInvited(jsonObject.get("players").getAsJsonArray());
                RealmsServer.sortInvited(realmsServer);
            } else {
                realmsServer.players = Lists.newArrayList();
            }
            realmsServer.daysLeft = dao.a("daysLeft", jsonObject, 0);
            realmsServer.expired = dao.a("expired", jsonObject, false);
            realmsServer.expiredTrial = dao.a("expiredTrial", jsonObject, false);
            realmsServer.worldType = RealmsServer.getWorldType(dao.a("worldType", jsonObject, c.a.name()));
            realmsServer.ownerUUID = dao.a("ownerUUID", jsonObject, "");
            realmsServer.slots = jsonObject.get("slots") != null && jsonObject.get("slots").isJsonArray() ? RealmsServer.parseSlots(jsonObject.get("slots").getAsJsonArray()) : RealmsServer.getEmptySlots();
            realmsServer.minigameName = dao.a("minigameName", jsonObject, null);
            realmsServer.activeSlot = dao.a("activeSlot", jsonObject, -1);
            realmsServer.minigameId = dao.a("minigameId", jsonObject, -1);
            realmsServer.minigameImage = dao.a("minigameImage", jsonObject, null);
        }
        catch (Exception \u26032) {
            LOGGER.error("Could not parse McoServer: " + \u26032.getMessage());
        }
        return realmsServer;
    }

    private static void sortInvited(RealmsServer realmsServer) {
        realmsServer.players.sort((playerInfo, playerInfo2) -> ComparisonChain.start().compareFalseFirst(playerInfo2.getAccepted(), playerInfo.getAccepted()).compare((Comparable)((Object)playerInfo.getName().toLowerCase(Locale.ROOT)), (Comparable)((Object)playerInfo2.getName().toLowerCase(Locale.ROOT))).result());
    }

    private static List<PlayerInfo> parseInvited(JsonArray jsonArray) {
        ArrayList arrayList = Lists.newArrayList();
        for (JsonElement jsonElement : jsonArray) {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                PlayerInfo \u26032 = new PlayerInfo();
                \u26032.setName(dao.a("name", jsonObject, null));
                \u26032.setUuid(dao.a("uuid", jsonObject, null));
                \u26032.setOperator(dao.a("operator", jsonObject, false));
                \u26032.setAccepted(dao.a("accepted", jsonObject, false));
                \u26032.setOnline(dao.a("online", jsonObject, false));
                arrayList.add(\u26032);
            }
            catch (Exception exception) {}
        }
        return arrayList;
    }

    private static Map<Integer, RealmsWorldOptions> parseSlots(JsonArray jsonArray) {
        HashMap hashMap = Maps.newHashMap();
        for (JsonElement jsonElement : jsonArray) {
            try {
                JsonObject jsonObject = jsonElement.getAsJsonObject();
                JsonParser \u26032 = new JsonParser();
                JsonElement \u26033 = \u26032.parse(jsonObject.get("options").getAsString());
                RealmsWorldOptions \u26034 = \u26033 == null ? RealmsWorldOptions.getDefaults() : RealmsWorldOptions.parse(\u26033.getAsJsonObject());
                int \u26035 = dao.a("slotId", jsonObject, -1);
                hashMap.put(\u26035, \u26034);
            }
            catch (Exception exception) {}
        }
        for (int i2 = 1; i2 <= 3; ++i2) {
            if (hashMap.containsKey(i2)) continue;
            hashMap.put(i2, RealmsWorldOptions.getEmptyDefaults());
        }
        return hashMap;
    }

    private static Map<Integer, RealmsWorldOptions> getEmptySlots() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put(1, RealmsWorldOptions.getEmptyDefaults());
        hashMap.put(2, RealmsWorldOptions.getEmptyDefaults());
        hashMap.put(3, RealmsWorldOptions.getEmptyDefaults());
        return hashMap;
    }

    public static RealmsServer parse(String string) {
        RealmsServer \u26033 = new RealmsServer();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonObject \u26032 = jsonParser.parse(string).getAsJsonObject();
            \u26033 = RealmsServer.parse(\u26032);
        }
        catch (Exception exception) {
            LOGGER.error("Could not parse McoServer: " + exception.getMessage());
        }
        return \u26033;
    }

    private static b getState(String string) {
        try {
            return b.valueOf(string);
        }
        catch (Exception exception) {
            return b.a;
        }
    }

    private static c getWorldType(String string) {
        try {
            return c.valueOf(string);
        }
        catch (Exception exception) {
            return c.a;
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append((Object)this.name).append((Object)this.motd).append((Object)this.state).append((Object)this.owner).append(this.expired).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        RealmsServer realmsServer = (RealmsServer)object;
        return new EqualsBuilder().append(this.id, realmsServer.id).append((Object)this.name, (Object)realmsServer.name).append((Object)this.motd, (Object)realmsServer.motd).append((Object)this.state, (Object)realmsServer.state).append((Object)this.owner, (Object)realmsServer.owner).append(this.expired, realmsServer.expired).append((Object)this.worldType, (Object)this.worldType).isEquals();
    }

    public RealmsServer clone() {
        RealmsServer realmsServer = new RealmsServer();
        realmsServer.id = this.id;
        realmsServer.remoteSubscriptionId = this.remoteSubscriptionId;
        realmsServer.name = this.name;
        realmsServer.motd = this.motd;
        realmsServer.state = this.state;
        realmsServer.owner = this.owner;
        realmsServer.players = this.players;
        realmsServer.slots = this.cloneSlots(this.slots);
        realmsServer.expired = this.expired;
        realmsServer.expiredTrial = this.expiredTrial;
        realmsServer.daysLeft = this.daysLeft;
        realmsServer.serverPing = new RealmsServerPing();
        realmsServer.serverPing.nrOfPlayers = this.serverPing.nrOfPlayers;
        realmsServer.serverPing.playerList = this.serverPing.playerList;
        realmsServer.worldType = this.worldType;
        realmsServer.ownerUUID = this.ownerUUID;
        realmsServer.minigameName = this.minigameName;
        realmsServer.activeSlot = this.activeSlot;
        realmsServer.minigameId = this.minigameId;
        realmsServer.minigameImage = this.minigameImage;
        return realmsServer;
    }

    public Map<Integer, RealmsWorldOptions> cloneSlots(Map<Integer, RealmsWorldOptions> map) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry<Integer, RealmsWorldOptions> entry : map.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue().clone());
        }
        return hashMap;
    }

    public static enum c {
        a,
        b,
        c,
        d,
        e;

    }

    public static enum b {
        a,
        b,
        c;

    }

    public static class a
    implements Comparator<RealmsServer> {
        private final String a;

        public a(String string) {
            this.a = string;
        }

        public int a(RealmsServer realmsServer, RealmsServer realmsServer2) {
            return ComparisonChain.start().compareTrueFirst(realmsServer.state.equals((Object)b.c), realmsServer2.state.equals((Object)b.c)).compareTrueFirst(realmsServer.expiredTrial, realmsServer2.expiredTrial).compareTrueFirst(realmsServer.owner.equals(this.a), realmsServer2.owner.equals(this.a)).compareFalseFirst(realmsServer.expired, realmsServer2.expired).compareTrueFirst(realmsServer.state.equals((Object)b.b), realmsServer2.state.equals((Object)b.b)).compare(realmsServer.id, realmsServer2.id).result();
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((RealmsServer)object, (RealmsServer)object2);
        }
    }
}

