/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.types;

import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

public final class Func<A, B>
extends Type<Function<A, B>> {
    protected final Type<A> first;
    protected final Type<B> second;

    public Func(Type<A> first, Type<B> second) {
        this.first = first;
        this.second = second;
    }

    @Override
    public TypeTemplate buildTemplate() {
        throw new UnsupportedOperationException("No template for function types.");
    }

    @Override
    public <T> Pair<T, Optional<Function<A, B>>> read(DynamicOps<T> ops, T input) {
        return Pair.of(input, Optional.empty());
    }

    @Override
    public <T> T write(DynamicOps<T> ops, T rest, Function<A, B> value) {
        return rest;
    }

    public String toString() {
        return "(" + this.first + " -> " + this.second + ")";
    }

    @Override
    public boolean equals(Object obj, boolean ignoreRecursionPoints, boolean checkIndex) {
        if (!(obj instanceof Func)) {
            return false;
        }
        Func that = (Func)obj;
        return this.first.equals(that.first, ignoreRecursionPoints, checkIndex) && this.second.equals(that.second, ignoreRecursionPoints, checkIndex);
    }

    public int hashCode() {
        return Objects.hash(this.first, this.second);
    }

    public Type<A> first() {
        return this.first;
    }

    public Type<B> second() {
        return this.second;
    }
}

