/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.DynamicLike;
import com.mojang.datafixers.OptionalDynamic;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Pair;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class Dynamic<T>
extends DynamicLike<T> {
    private final T value;

    public Dynamic(DynamicOps<T> ops) {
        this(ops, ops.empty());
    }

    public Dynamic(DynamicOps<T> ops, @Nullable T value) {
        super(ops);
        this.value = value == null ? ops.empty() : value;
    }

    public T getValue() {
        return this.value;
    }

    public Dynamic<T> map(Function<? super T, ? extends T> function) {
        return new Dynamic<T>(this.ops, function.apply(this.value));
    }

    public <U> Dynamic<U> castTyped(DynamicOps<U> ops) {
        if (!Objects.equals(this.ops, ops)) {
            throw new IllegalStateException("Dynamic type doesn't match");
        }
        return this;
    }

    public <U> U cast(DynamicOps<U> ops) {
        return this.castTyped(ops).getValue();
    }

    public Dynamic<T> merge(Dynamic<?> value) {
        return this.map(v -> this.ops.mergeInto(v, value.cast(this.ops)));
    }

    public Dynamic<T> merge(Dynamic<?> key, Dynamic<?> value) {
        return this.map(v -> this.ops.mergeInto(v, key.cast(this.ops), value.cast(this.ops)));
    }

    public Optional<Map<Dynamic<T>, Dynamic<T>>> getMapValues() {
        return this.ops.getMapValues(this.value).map((? super T map) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : map.entrySet()) {
                builder.put(new Dynamic(this.ops, entry.getKey()), new Dynamic(this.ops, entry.getValue()));
            }
            return builder.build();
        });
    }

    public Dynamic<T> updateMapValues(Function<Pair<Dynamic<?>, Dynamic<?>>, Pair<Dynamic<?>, Dynamic<?>>> updater) {
        return DataFixUtils.orElse(this.getMapValues().map((? super T map) -> map.entrySet().stream().map((? super T e) -> {
            Pair pair = (Pair)updater.apply(Pair.of(e.getKey(), e.getValue()));
            return Pair.of(((Dynamic)pair.getFirst()).castTyped(this.ops), ((Dynamic)pair.getSecond()).castTyped(this.ops));
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond))).map(this::createMap), this);
    }

    @Override
    public Optional<Number> asNumber() {
        return this.ops.getNumberValue(this.value);
    }

    @Override
    public Optional<String> asString() {
        return this.ops.getStringValue(this.value);
    }

    @Override
    public Optional<Stream<Dynamic<T>>> asStreamOpt() {
        return this.ops.getStream(this.value).map((? super T s) -> s.map((? super T e) -> new Dynamic<Object>(this.ops, e)));
    }

    @Override
    public Optional<ByteBuffer> asByteBufferOpt() {
        return this.ops.getByteBuffer(this.value);
    }

    @Override
    public Optional<IntStream> asIntStreamOpt() {
        return this.ops.getIntStream(this.value);
    }

    @Override
    public Optional<LongStream> asLongStreamOpt() {
        return this.ops.getLongStream(this.value);
    }

    @Override
    public OptionalDynamic<T> get(String key) {
        return new OptionalDynamic(this.ops, this.ops.get(this.value, key).map((? super T v) -> new Dynamic<Object>(this.ops, v)));
    }

    @Override
    public Optional<T> getGeneric(T key) {
        return this.ops.getGeneric(this.value, key);
    }

    public Dynamic<T> remove(String key) {
        return this.map(v -> this.ops.remove(v, key));
    }

    public Dynamic<T> set(String key, Dynamic<?> value) {
        return this.map(v -> this.ops.set(v, key, value.cast(this.ops)));
    }

    public Dynamic<T> update(String key, Function<Dynamic<?>, Dynamic<?>> function) {
        return this.map(v -> this.ops.update(v, key, value -> ((Dynamic)function.apply(new Dynamic<Object>(this.ops, value))).cast(this.ops)));
    }

    public Dynamic<T> updateGeneric(T key, Function<T, T> function) {
        return this.map(v -> this.ops.updateGeneric(v, key, function));
    }

    @Override
    public Optional<T> getElement(String key) {
        return this.getElementGeneric(this.ops.createString(key));
    }

    @Override
    public Optional<T> getElementGeneric(T key) {
        return this.ops.getMapValues(this.value).flatMap(m -> Optional.ofNullable(m.get(key)));
    }

    @Override
    public <U> Optional<List<U>> asListOpt(Function<Dynamic<T>, U> deserializer) {
        return this.asStreamOpt().map((? super T stream) -> stream.map(deserializer).collect(Collectors.toList()));
    }

    @Override
    public <K, V> Optional<Map<K, V>> asMapOpt(Function<Dynamic<T>, K> keyDeserializer, Function<Dynamic<T>, V> valueDeserializer) {
        return this.ops.getMapValues(this.value).map((? super T map) -> {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (Map.Entry entry : map.entrySet()) {
                builder.put(keyDeserializer.apply(new Dynamic(this.ops, entry.getKey())), valueDeserializer.apply(new Dynamic(this.ops, entry.getValue())));
            }
            return builder.build();
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Dynamic dynamic = (Dynamic)o;
        return Objects.equals(this.ops, dynamic.ops) && Objects.equals(this.value, dynamic.value);
    }

    public int hashCode() {
        return Objects.hash(this.ops, this.value);
    }

    public String toString() {
        return String.format("%s[%s]", this.ops, this.value);
    }

    public <R> Dynamic<R> convert(DynamicOps<R> outOps) {
        return new Dynamic<R>(outOps, Dynamic.convert(this.ops, outOps, this.value));
    }

    public static <S, T> T convert(DynamicOps<S> inOps, DynamicOps<T> outOps, S input) {
        if (Objects.equals(inOps, outOps)) {
            return (T)input;
        }
        Type<?> type = inOps.getType(input);
        if (Objects.equals(type, DSL.nilType())) {
            return outOps.empty();
        }
        if (Objects.equals(type, DSL.byteType())) {
            return outOps.createByte(inOps.getNumberValue(input, 0).byteValue());
        }
        if (Objects.equals(type, DSL.shortType())) {
            return outOps.createShort(inOps.getNumberValue(input, 0).shortValue());
        }
        if (Objects.equals(type, DSL.intType())) {
            return outOps.createInt(inOps.getNumberValue(input, 0).intValue());
        }
        if (Objects.equals(type, DSL.longType())) {
            return outOps.createLong(inOps.getNumberValue(input, 0).longValue());
        }
        if (Objects.equals(type, DSL.floatType())) {
            return outOps.createFloat(inOps.getNumberValue(input, 0).floatValue());
        }
        if (Objects.equals(type, DSL.doubleType())) {
            return outOps.createDouble(inOps.getNumberValue(input, 0).doubleValue());
        }
        if (Objects.equals(type, DSL.bool())) {
            return outOps.createBoolean(inOps.getNumberValue(input, 0).byteValue() != 0);
        }
        if (Objects.equals(type, DSL.string())) {
            return outOps.createString(inOps.getStringValue(input).orElse(""));
        }
        if (Objects.equals(type, DSL.list(DSL.byteType()))) {
            return outOps.createByteList(inOps.getByteBuffer(input).orElse(ByteBuffer.wrap(new byte[0])));
        }
        if (Objects.equals(type, DSL.list(DSL.intType()))) {
            return outOps.createIntList(inOps.getIntStream(input).orElse(IntStream.empty()));
        }
        if (Objects.equals(type, DSL.list(DSL.longType()))) {
            return outOps.createLongList(inOps.getLongStream(input).orElse(LongStream.empty()));
        }
        if (Objects.equals(type, DSL.list(DSL.remainderType()))) {
            return (T)outOps.createList(inOps.getStream(input).orElse(Stream.empty()).map((? super T e) -> Dynamic.convert(inOps, outOps, e)));
        }
        if (Objects.equals(type, DSL.compoundList(DSL.remainderType(), DSL.remainderType()))) {
            return (T)outOps.createMap(((Map)inOps.getMapValues(input).orElse((Map<S, S>)ImmutableMap.of())).entrySet().stream().map((? super T e) -> Pair.of(Dynamic.convert(inOps, outOps, e.getKey()), Dynamic.convert(inOps, outOps, e.getValue()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }
        throw new IllegalStateException("Could not convert value of type " + type);
    }
}

