/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.opengl;

import java.nio.ByteBuffer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;
import org.lwjgl.system.windows.RECT;

public class GPU_DEVICE
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int CB;
    public static final int DEVICENAME;
    public static final int DEVICESTRING;
    public static final int FLAGS;
    public static final int RCVIRTUALSCREEN;

    public GPU_DEVICE(ByteBuffer container) {
        super(MemoryUtil.memAddress((ByteBuffer)container), GPU_DEVICE.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="DWORD")
    public int cb() {
        return GPU_DEVICE.ncb(this.address());
    }

    @NativeType(value="CHAR[32]")
    public ByteBuffer DeviceName() {
        return GPU_DEVICE.nDeviceName(this.address());
    }

    @NativeType(value="CHAR[32]")
    public String DeviceNameString() {
        return GPU_DEVICE.nDeviceNameString(this.address());
    }

    @NativeType(value="CHAR[128]")
    public ByteBuffer DeviceString() {
        return GPU_DEVICE.nDeviceString(this.address());
    }

    @NativeType(value="CHAR[128]")
    public String DeviceStringString() {
        return GPU_DEVICE.nDeviceStringString(this.address());
    }

    @NativeType(value="DWORD")
    public int Flags() {
        return GPU_DEVICE.nFlags(this.address());
    }

    public RECT rcVirtualScreen() {
        return GPU_DEVICE.nrcVirtualScreen(this.address());
    }

    public GPU_DEVICE rcVirtualScreen(Consumer<RECT> consumer) {
        consumer.accept(this.rcVirtualScreen());
        return this;
    }

    public static GPU_DEVICE malloc() {
        return (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static GPU_DEVICE calloc() {
        return (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static GPU_DEVICE create() {
        ByteBuffer container = BufferUtils.createByteBuffer((int)SIZEOF);
        return (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (ByteBuffer)container);
    }

    public static GPU_DEVICE create(long address) {
        return (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)address);
    }

    @Nullable
    public static GPU_DEVICE createSafe(long address) {
        return address == 0L ? null : (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)address);
    }

    public static Buffer malloc(int capacity) {
        return (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)MemoryUtil.nmemAllocChecked((long)GPU_DEVICE.__checkMalloc((int)capacity, (int)SIZEOF)), (int)capacity);
    }

    public static Buffer calloc(int capacity) {
        return (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), (int)capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = GPU_DEVICE.__create((int)capacity, (int)SIZEOF);
        return (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)MemoryUtil.memAddress((ByteBuffer)container), (int)capacity, (ByteBuffer)container);
    }

    public static Buffer create(long address, int capacity) {
        return (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)address, (int)capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)address, (int)capacity);
    }

    public static GPU_DEVICE mallocStack() {
        return GPU_DEVICE.mallocStack(MemoryStack.stackGet());
    }

    public static GPU_DEVICE callocStack() {
        return GPU_DEVICE.callocStack(MemoryStack.stackGet());
    }

    public static GPU_DEVICE mallocStack(MemoryStack stack) {
        return (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static GPU_DEVICE callocStack(MemoryStack stack) {
        return (GPU_DEVICE)GPU_DEVICE.wrap(GPU_DEVICE.class, (long)stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return GPU_DEVICE.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return GPU_DEVICE.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)stack.nmalloc(ALIGNOF, capacity * SIZEOF), (int)capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return (Buffer)GPU_DEVICE.wrap(Buffer.class, (long)stack.ncalloc(ALIGNOF, capacity, SIZEOF), (int)capacity);
    }

    public static int ncb(long struct) {
        return UNSAFE.getInt(null, struct + (long)CB);
    }

    public static ByteBuffer nDeviceName(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICENAME), (int)32);
    }

    public static String nDeviceNameString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)DEVICENAME));
    }

    public static ByteBuffer nDeviceString(long struct) {
        return MemoryUtil.memByteBuffer((long)(struct + (long)DEVICESTRING), (int)128);
    }

    public static String nDeviceStringString(long struct) {
        return MemoryUtil.memASCII((long)(struct + (long)DEVICESTRING));
    }

    public static int nFlags(long struct) {
        return UNSAFE.getInt(null, struct + (long)FLAGS);
    }

    public static RECT nrcVirtualScreen(long struct) {
        return RECT.create((long)(struct + (long)RCVIRTUALSCREEN));
    }

    static {
        Struct.Layout layout = GPU_DEVICE.__struct((Struct.Member[])new Struct.Member[]{GPU_DEVICE.__member((int)4), GPU_DEVICE.__array((int)1, (int)32), GPU_DEVICE.__array((int)1, (int)128), GPU_DEVICE.__member((int)4), GPU_DEVICE.__member((int)RECT.SIZEOF, (int)RECT.ALIGNOF)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        CB = layout.offsetof(0);
        DEVICENAME = layout.offsetof(1);
        DEVICESTRING = layout.offsetof(2);
        FLAGS = layout.offsetof(3);
        RCVIRTUALSCREEN = layout.offsetof(4);
    }

    public static class Buffer
    extends StructBuffer<GPU_DEVICE, Buffer>
    implements NativeResource {
        private static final GPU_DEVICE ELEMENT_FACTORY = GPU_DEVICE.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected GPU_DEVICE getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="DWORD")
        public int cb() {
            return GPU_DEVICE.ncb(this.address());
        }

        @NativeType(value="CHAR[32]")
        public ByteBuffer DeviceName() {
            return GPU_DEVICE.nDeviceName(this.address());
        }

        @NativeType(value="CHAR[32]")
        public String DeviceNameString() {
            return GPU_DEVICE.nDeviceNameString(this.address());
        }

        @NativeType(value="CHAR[128]")
        public ByteBuffer DeviceString() {
            return GPU_DEVICE.nDeviceString(this.address());
        }

        @NativeType(value="CHAR[128]")
        public String DeviceStringString() {
            return GPU_DEVICE.nDeviceStringString(this.address());
        }

        @NativeType(value="DWORD")
        public int Flags() {
            return GPU_DEVICE.nFlags(this.address());
        }

        public RECT rcVirtualScreen() {
            return GPU_DEVICE.nrcVirtualScreen(this.address());
        }

        public Buffer rcVirtualScreen(Consumer<RECT> consumer) {
            consumer.accept(this.rcVirtualScreen());
            return this;
        }
    }
}

