/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.Spliterator;

public class HashSet<E>
extends AbstractSet<E>
implements Set<E>,
Cloneable,
Serializable {
    static final long serialVersionUID = -5024744406713321676L;
    private transient HashMap<E, Object> map;
    private static final Object PRESENT = new Object();

    public HashSet() {
        this.map = new HashMap();
    }

    public HashSet(Collection<? extends E> collection) {
        this.map = new HashMap(Math.max((int)((float)collection.size() / 0.75f) + 1, 16));
        this.addAll(collection);
    }

    public HashSet(int n, float f) {
        this.map = new HashMap(n, f);
    }

    public HashSet(int n) {
        this.map = new HashMap(n);
    }

    HashSet(int n, float f, boolean bl) {
        this.map = new LinkedHashMap<E, Object>(n, f);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map.keySet().iterator();
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object object) {
        return this.map.containsKey(object);
    }

    @Override
    public boolean add(E e) {
        return this.map.put(e, PRESENT) == null;
    }

    @Override
    public boolean remove(Object object) {
        return this.map.remove(object) == PRESENT;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public Object clone() {
        try {
            HashSet hashSet = (HashSet)super.clone();
            hashSet.map = (HashMap)this.map.clone();
            return hashSet;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException);
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.map.capacity());
        objectOutputStream.writeFloat(this.map.loadFactor());
        objectOutputStream.writeInt(this.map.size());
        for (E e : this.map.keySet()) {
            objectOutputStream.writeObject(e);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        if (n < 0) {
            throw new InvalidObjectException("Illegal capacity: " + n);
        }
        float f = objectInputStream.readFloat();
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new InvalidObjectException("Illegal load factor: " + f);
        }
        int n2 = objectInputStream.readInt();
        if (n2 < 0) {
            throw new InvalidObjectException("Illegal size: " + n2);
        }
        n = (int)Math.min((float)n2 * Math.min(1.0f / f, 4.0f), 1.0737418E9f);
        this.map = this instanceof LinkedHashSet ? new LinkedHashMap(n, f) : new HashMap(n, f);
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            this.map.put(object, PRESENT);
        }
    }

    @Override
    public Spliterator<E> spliterator() {
        return new HashMap.KeySpliterator<E, Object>(this.map, 0, -1, 0, 0);
    }
}

