/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.system;

import org.lwjgl.system.APIUtil;
import org.lwjgl.system.MemoryUtil;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class MultiReleaseMemCopy {
    private MultiReleaseMemCopy() {
    }

    static void copy(long src, long dst, long bytes) {
        if (bytes < 64L && ((int)src & 7) == 0 && ((int)dst & 7) == 0) {
            MemoryUtil.memCopyAligned(src, dst, (int)bytes & 0xFFFFFFFF);
        } else {
            MemoryUtil.UNSAFE.copyMemory(src, dst, bytes);
        }
    }

    static {
        APIUtil.apiLog("Java 10 memcpy enabled");
    }
}

