/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.dto;

import com.google.common.collect.ComparisonChain;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.realmsclient.dto.PlayerInfo;
import com.mojang.realmsclient.dto.RealmsServerPing;
import com.mojang.realmsclient.dto.RealmsServerPlayerList;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.minecraft.obfuscate.DontObfuscateOrShrink;
import net.minecraft.realms.Realms;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import realms.be;
import realms.bk;
import realms.l;

@DontObfuscateOrShrink
public class RealmsServer
extends l {
    private static final Logger LOGGER = LogManager.getLogger();
    public long id;
    public String remoteSubscriptionId;
    public String name;
    public String motd;
    public b state;
    public String owner;
    public String ownerUUID;
    public List<PlayerInfo> players;
    public Map<Integer, RealmsWorldOptions> slots;
    public boolean expired;
    public boolean expiredTrial;
    public int daysLeft;
    public c worldType;
    public int activeSlot;
    public String minigameName;
    public int minigameId;
    public String minigameImage;
    public RealmsServerPing serverPing = new RealmsServerPing();

    public String getDescription() {
        return this.motd;
    }

    public String getName() {
        return this.name;
    }

    public String getMinigameName() {
        return this.minigameName;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setDescription(String motd) {
        this.motd = motd;
    }

    public void updateServerPing(RealmsServerPlayerList serverPlayerList) {
        StringBuilder builder = new StringBuilder();
        int players = 0;
        for (String uuid : serverPlayerList.players) {
            if (uuid.equals(Realms.getUUID())) continue;
            String name = "";
            try {
                name = bk.a(uuid);
            }
            catch (Exception exception) {
                LOGGER.error("Could not get name for " + uuid, (Throwable)exception);
                continue;
            }
            if (builder.length() > 0) {
                builder.append("\n");
            }
            builder.append(name);
            ++players;
        }
        this.serverPing.nrOfPlayers = String.valueOf(players);
        this.serverPing.playerList = builder.toString();
    }

    public static RealmsServer parse(JsonObject node) {
        RealmsServer server = new RealmsServer();
        try {
            server.id = be.a("id", node, -1L);
            server.remoteSubscriptionId = be.a("remoteSubscriptionId", node, null);
            server.name = be.a("name", node, null);
            server.motd = be.a("motd", node, null);
            server.state = RealmsServer.getState(be.a("state", node, b.a.name()));
            server.owner = be.a("owner", node, null);
            if (node.get("players") != null && node.get("players").isJsonArray()) {
                server.players = RealmsServer.parseInvited(node.get("players").getAsJsonArray());
                RealmsServer.sortInvited(server);
            } else {
                server.players = new ArrayList<PlayerInfo>();
            }
            server.daysLeft = be.a("daysLeft", node, 0);
            server.expired = be.a("expired", node, false);
            server.expiredTrial = be.a("expiredTrial", node, false);
            server.worldType = RealmsServer.getWorldType(be.a("worldType", node, c.a.name()));
            server.ownerUUID = be.a("ownerUUID", node, "");
            server.slots = node.get("slots") != null && node.get("slots").isJsonArray() ? RealmsServer.parseSlots(node.get("slots").getAsJsonArray()) : RealmsServer.getEmptySlots();
            server.minigameName = be.a("minigameName", node, null);
            server.activeSlot = be.a("activeSlot", node, -1);
            server.minigameId = be.a("minigameId", node, -1);
            server.minigameImage = be.a("minigameImage", node, null);
        }
        catch (Exception e2) {
            LOGGER.error("Could not parse McoServer: " + e2.getMessage());
        }
        return server;
    }

    private static void sortInvited(RealmsServer server) {
        Collections.sort(server.players, new Comparator<PlayerInfo>(){

            public int a(PlayerInfo o1, PlayerInfo o2) {
                return ComparisonChain.start().compare(Boolean.valueOf(o2.getAccepted()), Boolean.valueOf(o1.getAccepted())).compare((Comparable)((Object)o1.getName().toLowerCase(Locale.ROOT)), (Comparable)((Object)o2.getName().toLowerCase(Locale.ROOT))).result();
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((PlayerInfo)object, (PlayerInfo)object2);
            }
        });
    }

    private static List<PlayerInfo> parseInvited(JsonArray jsonArray) {
        ArrayList<PlayerInfo> invited = new ArrayList<PlayerInfo>();
        for (JsonElement aJsonArray : jsonArray) {
            try {
                JsonObject node = aJsonArray.getAsJsonObject();
                PlayerInfo playerInfo = new PlayerInfo();
                playerInfo.setName(be.a("name", node, null));
                playerInfo.setUuid(be.a("uuid", node, null));
                playerInfo.setOperator(be.a("operator", node, false));
                playerInfo.setAccepted(be.a("accepted", node, false));
                playerInfo.setOnline(be.a("online", node, false));
                invited.add(playerInfo);
            }
            catch (Exception exception) {}
        }
        return invited;
    }

    private static Map<Integer, RealmsWorldOptions> parseSlots(JsonArray jsonArray) {
        HashMap<Integer, RealmsWorldOptions> slots = new HashMap<Integer, RealmsWorldOptions>();
        for (JsonElement aJsonArray : jsonArray) {
            try {
                JsonObject node = aJsonArray.getAsJsonObject();
                JsonParser parser = new JsonParser();
                JsonElement element = parser.parse(node.get("options").getAsString());
                RealmsWorldOptions options = element == null ? RealmsWorldOptions.getDefaults() : RealmsWorldOptions.parse(element.getAsJsonObject());
                int slot = be.a("slotId", node, -1);
                slots.put(slot, options);
            }
            catch (Exception exception) {}
        }
        for (int i2 = 1; i2 <= 3; ++i2) {
            if (slots.containsKey(i2)) continue;
            slots.put(i2, RealmsWorldOptions.getEmptyDefaults());
        }
        return slots;
    }

    private static Map<Integer, RealmsWorldOptions> getEmptySlots() {
        HashMap<Integer, RealmsWorldOptions> slots = new HashMap<Integer, RealmsWorldOptions>();
        slots.put(1, RealmsWorldOptions.getEmptyDefaults());
        slots.put(2, RealmsWorldOptions.getEmptyDefaults());
        slots.put(3, RealmsWorldOptions.getEmptyDefaults());
        return slots;
    }

    public static RealmsServer parse(String json) {
        RealmsServer server = new RealmsServer();
        try {
            JsonParser parser = new JsonParser();
            JsonObject object = parser.parse(json).getAsJsonObject();
            server = RealmsServer.parse(object);
        }
        catch (Exception e2) {
            LOGGER.error("Could not parse McoServer: " + e2.getMessage());
        }
        return server;
    }

    private static b getState(String state) {
        try {
            return b.valueOf(state);
        }
        catch (Exception ignored) {
            return b.a;
        }
    }

    private static c getWorldType(String state) {
        try {
            return c.valueOf(state);
        }
        catch (Exception ignored) {
            return c.a;
        }
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.id).append((Object)this.name).append((Object)this.motd).append((Object)this.state).append((Object)this.owner).append(this.expired).toHashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        RealmsServer rhs = (RealmsServer)obj;
        return new EqualsBuilder().append(this.id, rhs.id).append((Object)this.name, (Object)rhs.name).append((Object)this.motd, (Object)rhs.motd).append((Object)this.state, (Object)rhs.state).append((Object)this.owner, (Object)rhs.owner).append(this.expired, rhs.expired).append((Object)this.worldType, (Object)this.worldType).isEquals();
    }

    public RealmsServer clone() {
        RealmsServer server = new RealmsServer();
        server.id = this.id;
        server.remoteSubscriptionId = this.remoteSubscriptionId;
        server.name = this.name;
        server.motd = this.motd;
        server.state = this.state;
        server.owner = this.owner;
        server.players = this.players;
        server.slots = this.cloneSlots(this.slots);
        server.expired = this.expired;
        server.expiredTrial = this.expiredTrial;
        server.daysLeft = this.daysLeft;
        server.serverPing = new RealmsServerPing();
        server.serverPing.nrOfPlayers = this.serverPing.nrOfPlayers;
        server.serverPing.playerList = this.serverPing.playerList;
        server.worldType = this.worldType;
        server.ownerUUID = this.ownerUUID;
        server.minigameName = this.minigameName;
        server.activeSlot = this.activeSlot;
        server.minigameId = this.minigameId;
        server.minigameImage = this.minigameImage;
        return server;
    }

    public Map<Integer, RealmsWorldOptions> cloneSlots(Map<Integer, RealmsWorldOptions> slots) {
        HashMap<Integer, RealmsWorldOptions> newSlots = new HashMap<Integer, RealmsWorldOptions>();
        for (Map.Entry<Integer, RealmsWorldOptions> entry : slots.entrySet()) {
            newSlots.put(entry.getKey(), entry.getValue().clone());
        }
        return newSlots;
    }

    public static enum c {
        a,
        b,
        c,
        d,
        e;

    }

    public static enum b {
        a,
        b,
        c;

    }

    public static class a
    implements Comparator<RealmsServer> {
        private final String a;

        public a(String owner) {
            this.a = owner;
        }

        public int a(RealmsServer server1, RealmsServer server2) {
            return ComparisonChain.start().compareTrueFirst(server1.state.equals((Object)b.c), server2.state.equals((Object)b.c)).compareTrueFirst(server1.expiredTrial, server2.expiredTrial).compareTrueFirst(server1.owner.equals(this.a), server2.owner.equals(this.a)).compareFalseFirst(server1.expired, server2.expired).compareTrueFirst(server1.state.equals((Object)b.b), server2.state.equals((Object)b.b)).compare(server1.id, server2.id).result();
        }

        @Override
        public /* synthetic */ int compare(Object object, Object object2) {
            return this.a((RealmsServer)object, (RealmsServer)object2);
        }
    }
}

