/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.datafixers.types.templates;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.reflect.TypeToken;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFixerUpper;
import com.mojang.datafixers.FamilyOptic;
import com.mojang.datafixers.FunctionType;
import com.mojang.datafixers.RewriteResult;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.TypedOptic;
import com.mojang.datafixers.View;
import com.mojang.datafixers.functions.Functions;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.K1;
import com.mojang.datafixers.optics.Affine;
import com.mojang.datafixers.optics.Lens;
import com.mojang.datafixers.optics.Optic;
import com.mojang.datafixers.optics.Optics;
import com.mojang.datafixers.optics.Traversal;
import com.mojang.datafixers.optics.profunctors.AffineP;
import com.mojang.datafixers.optics.profunctors.Cartesian;
import com.mojang.datafixers.optics.profunctors.TraversalP;
import com.mojang.datafixers.types.DynamicOps;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.families.RecursiveTypeFamily;
import com.mojang.datafixers.types.families.TypeFamily;
import com.mojang.datafixers.types.templates.TypeTemplate;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TaggedChoice<K>
implements TypeTemplate {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private final Type<K> keyType;
    private final Map<K, TypeTemplate> templates;
    private final Map<Pair<TypeFamily, Integer>, Type<?>> types = Maps.newConcurrentMap();
    private final int size;

    public TaggedChoice(String name, Type<K> keyType, Map<K, TypeTemplate> templates) {
        this.name = name;
        this.keyType = keyType;
        this.templates = templates;
        this.size = templates.values().stream().mapToInt(TypeTemplate::size).max().orElse(0);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public TypeFamily apply(TypeFamily family) {
        return index -> this.types.computeIfAbsent(Pair.of(family, index), key -> DSL.taggedChoiceType(this.name, this.keyType, this.templates.entrySet().stream().map(e -> Pair.of(e.getKey(), ((TypeTemplate)e.getValue()).apply((TypeFamily)key.getFirst()).apply((Integer)key.getSecond()))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond))));
    }

    @Override
    public <A, B> FamilyOptic<A, B> applyO(FamilyOptic<A, B> input, Type<A> aType, Type<B> bType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public <A, B> Either<TypeTemplate, Type.FieldNotFoundException> findFieldOrType(int index, @Nullable String name, Type<A> type, Type<B> resultType) {
        return Either.right(new Type.FieldNotFoundException("Not implemented"));
    }

    @Override
    public IntFunction<RewriteResult<?, ?>> hmap(TypeFamily family, IntFunction<RewriteResult<?, ?>> function) {
        return index -> {
            RewriteResult result = RewriteResult.nop((TaggedChoiceType)this.apply(family).apply(index));
            for (Map.Entry<K, TypeTemplate> entry : this.templates.entrySet()) {
                RewriteResult<?, ?> elementResult = entry.getValue().hmap(family, function).apply(index);
                result = TaggedChoiceType.elementResult(entry.getKey(), (TaggedChoiceType)result.view().newType(), elementResult).compose(result);
            }
            return result;
        };
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TaggedChoice)) {
            return false;
        }
        TaggedChoice other = (TaggedChoice)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.keyType, other.keyType) && Objects.equals(this.templates, other.templates);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.keyType, this.templates);
    }

    public String toString() {
        return "TaggedChoice[" + this.name + ", " + Joiner.on((String)", ").withKeyValueSeparator(" -> ").join(this.templates) + "]";
    }

    public static final class TaggedChoiceType<K>
    extends Type<Pair<K, ?>> {
        private final String name;
        private final Type<K> keyType;
        protected final Map<K, Type<?>> types;
        private final int hashCode;

        public TaggedChoiceType(String name, Type<K> keyType, Map<K, Type<?>> types) {
            this.name = name;
            this.keyType = keyType;
            this.types = types;
            this.hashCode = Objects.hash(name, keyType, types);
        }

        @Override
        public RewriteResult<Pair<K, ?>, ?> all(TypeRewriteRule rule, boolean recurse, boolean checkIndex) {
            Map<Object, RewriteResult> results = this.types.entrySet().stream().map(e -> rule.rewrite((Type)e.getValue()).map(v -> Pair.of(e.getKey(), v))).filter(e -> e.isPresent() && !Objects.equals(((RewriteResult)((Pair)e.get()).getSecond()).view().function(), Functions.id())).map(Optional::get).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            if (results.isEmpty()) {
                return RewriteResult.nop(this);
            }
            if (results.size() == 1) {
                Map.Entry<Object, RewriteResult> entry = results.entrySet().iterator().next();
                return TaggedChoiceType.elementResult(entry.getKey(), this, entry.getValue());
            }
            HashMap newTypes = Maps.newHashMap(this.types);
            BitSet recData = new BitSet();
            for (Map.Entry<Object, RewriteResult> entry : results.entrySet()) {
                newTypes.put(entry.getKey(), entry.getValue().view().newType());
                recData.or(entry.getValue().recData());
            }
            return RewriteResult.create(View.create(this, DSL.taggedChoiceType(this.name, this.keyType, newTypes), Functions.fun("TaggedChoiceTypeRewriteResult " + results.size(), new RewriteFunc<Object>(results))), recData);
        }

        public static <K, FT, FR> RewriteResult<Pair<K, ?>, Pair<K, ?>> elementResult(K key, TaggedChoiceType<K> type, RewriteResult<FT, FR> result) {
            return TaggedChoiceType.opticView(type, result, TypedOptic.tagged(type, key, result.view().type(), result.view().newType()));
        }

        @Override
        public Optional<RewriteResult<Pair<K, ?>, ?>> one(TypeRewriteRule rule) {
            for (Map.Entry<K, Type<?>> entry : this.types.entrySet()) {
                Optional<RewriteResult<?, ?>> elementResult = rule.rewrite(entry.getValue());
                if (!elementResult.isPresent()) continue;
                return Optional.of(TaggedChoiceType.elementResult(entry.getKey(), this, elementResult.get()));
            }
            return Optional.empty();
        }

        @Override
        public Type<?> updateMu(RecursiveTypeFamily newFamily) {
            return DSL.taggedChoiceType(this.name, this.keyType, this.types.entrySet().stream().map(e -> Pair.of(e.getKey(), ((Type)e.getValue()).updateMu(newFamily))).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }

        @Override
        public TypeTemplate buildTemplate() {
            return DSL.taggedChoice(this.name, this.keyType, this.types.entrySet().stream().map(e -> Pair.of(e.getKey(), ((Type)e.getValue()).template())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond)));
        }

        @Override
        public <T> Pair<T, Optional<Pair<K, ?>>> read(DynamicOps<T> ops, T input) {
            T nameObject;
            Map<T, T> map;
            Optional<Map<T, T>> values = ops.getMapValues(input);
            if (values.isPresent() && (map = values.get()).containsKey(nameObject = ops.createString(this.name))) {
                Optional key = this.keyType.read(ops, map.get(nameObject)).getSecond();
                if (!key.isPresent() || !this.types.containsKey(key.get())) {
                    if (DataFixerUpper.ERRORS_ARE_FATAL) {
                        throw new IllegalArgumentException("Unsupported key: " + key.get() + " in " + this);
                    }
                    LOGGER.warn("Unsupported key: {} in {}", key.get(), (Object)this);
                    return Pair.of(input, Optional.empty());
                }
                return this.types.get(key.get()).read(ops, input).mapSecond(vo -> vo.map(v -> Pair.of(key.get(), v)));
            }
            return Pair.of(input, Optional.empty());
        }

        @Override
        public <T> T write(DynamicOps<T> ops, T rest, Pair<K, ?> value) {
            if (!this.types.containsKey(value.getFirst())) {
                throw new IllegalArgumentException("Unsupported key: " + value.getFirst() + " in " + this);
            }
            Type<?> type = this.types.get(value.getFirst());
            return this.capWrite(ops, type, value.getFirst(), value.getSecond(), rest);
        }

        private <T, A> T capWrite(DynamicOps<T> ops, Type<A> type, K key, Object value, T rest) {
            return ops.mergeInto(type.write(ops, rest, value), ops.createString(this.name), this.keyType.write(ops, ops.empty(), key));
        }

        @Override
        public Optional<Type<?>> findFieldTypeOpt(String name) {
            return this.types.values().stream().map(t -> t.findFieldTypeOpt(name)).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
        }

        @Override
        public Optional<Pair<K, ?>> point(DynamicOps<?> ops) {
            return this.types.entrySet().stream().map(e -> ((Type)e.getValue()).point(ops).map(value -> Pair.of(e.getKey(), value))).filter(Optional::isPresent).findFirst().flatMap(Function.identity()).map(p -> p);
        }

        public Optional<Typed<Pair<K, ?>>> point(DynamicOps<?> ops, K key, Object value) {
            if (!this.types.containsKey(key)) {
                return Optional.empty();
            }
            return Optional.of(new Typed<Pair<K, Object>>(this, ops, Pair.of(key, value)));
        }

        @Override
        public <FT, FR> Either<TypedOptic<Pair<K, ?>, ?, FT, FR>, Type.FieldNotFoundException> findTypeInChildren(Type<FT> type, Type<FR> resultType, Type.TypeMatcher<FT, FR> matcher, boolean recurse) {
            Optic optic;
            Object bound;
            final Map<Object, TypedOptic> optics = this.types.entrySet().stream().map(e -> Pair.of(e.getKey(), ((Type)e.getValue()).findType(type, resultType, matcher, recurse))).filter(e -> ((Either)e.getSecond()).left().isPresent()).map(e -> e.mapSecond(o -> (TypedOptic)o.left().get())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            if (optics.isEmpty()) {
                return Either.right(new Type.FieldNotFoundException("Not found in any choices"));
            }
            if (optics.size() == 1) {
                Map.Entry<Object, TypedOptic> entry = optics.entrySet().iterator().next();
                return Either.left(this.cap(this, entry.getKey(), entry.getValue()));
            }
            HashSet bounds = Sets.newHashSet();
            optics.values().forEach(o -> bounds.addAll(o.bounds()));
            if (TypedOptic.instanceOf(bounds, Cartesian.Mu.TYPE_TOKEN) && optics.size() == this.types.size()) {
                bound = Cartesian.Mu.TYPE_TOKEN;
                optic = new Lens<Pair<K, ?>, Pair<K, ?>, FT, FR>(){

                    @Override
                    public FT view(Pair<K, ?> s) {
                        TypedOptic optic = (TypedOptic)optics.get(s.getFirst());
                        return this.capView(s, optic);
                    }

                    private <S, T> FT capView(Pair<K, ?> s, TypedOptic<S, T, FT, FR> optic) {
                        return Optics.toLens(optic.upCast(Cartesian.Mu.TYPE_TOKEN).orElseThrow(IllegalArgumentException::new)).view(s.getSecond());
                    }

                    @Override
                    public Pair<K, ?> update(FR b, Pair<K, ?> s) {
                        TypedOptic optic = (TypedOptic)optics.get(s.getFirst());
                        return this.capUpdate(b, s, optic);
                    }

                    private <S, T> Pair<K, ?> capUpdate(FR b, Pair<K, ?> s, TypedOptic<S, T, FT, FR> optic) {
                        return Pair.of(s.getFirst(), Optics.toLens(optic.upCast(Cartesian.Mu.TYPE_TOKEN).orElseThrow(IllegalArgumentException::new)).update(b, s.getSecond()));
                    }
                };
            } else if (TypedOptic.instanceOf(bounds, AffineP.Mu.TYPE_TOKEN)) {
                bound = AffineP.Mu.TYPE_TOKEN;
                optic = new Affine<Pair<K, ?>, Pair<K, ?>, FT, FR>(){

                    @Override
                    public Either<Pair<K, ?>, FT> preview(Pair<K, ?> s) {
                        if (!optics.containsKey(s.getFirst())) {
                            return Either.left(s);
                        }
                        TypedOptic optic = (TypedOptic)optics.get(s.getFirst());
                        return this.capPreview(s, optic);
                    }

                    private <S, T> Either<Pair<K, ?>, FT> capPreview(Pair<K, ?> s, TypedOptic<S, T, FT, FR> optic) {
                        return Optics.toAffine(optic.upCast(AffineP.Mu.TYPE_TOKEN).orElseThrow(IllegalArgumentException::new)).preview(s.getSecond()).mapLeft(t -> Pair.of(s.getFirst(), t));
                    }

                    @Override
                    public Pair<K, ?> set(FR b, Pair<K, ?> s) {
                        if (!optics.containsKey(s.getFirst())) {
                            return s;
                        }
                        TypedOptic optic = (TypedOptic)optics.get(s.getFirst());
                        return this.capSet(b, s, optic);
                    }

                    private <S, T> Pair<K, ?> capSet(FR b, Pair<K, ?> s, TypedOptic<S, T, FT, FR> optic) {
                        return Pair.of(s.getFirst(), Optics.toAffine(optic.upCast(AffineP.Mu.TYPE_TOKEN).orElseThrow(IllegalArgumentException::new)).set(b, s.getSecond()));
                    }
                };
            } else if (TypedOptic.instanceOf(bounds, TraversalP.Mu.TYPE_TOKEN)) {
                bound = TraversalP.Mu.TYPE_TOKEN;
                optic = new Traversal<Pair<K, ?>, Pair<K, ?>, FT, FR>(){

                    @Override
                    public <F extends K1> FunctionType<Pair<K, ?>, App<F, Pair<K, ?>>> wander(Applicative<F, ?> applicative, FunctionType<FT, App<F, FR>> input) {
                        return pair -> {
                            if (!optics.containsKey(pair.getFirst())) {
                                return applicative.point(pair);
                            }
                            TypedOptic optic = (TypedOptic)optics.get(pair.getFirst());
                            return this.capTraversal(applicative, input, (Pair)pair, optic);
                        };
                    }

                    private <S, T, F extends K1> App<F, Pair<K, ?>> capTraversal(Applicative<F, ?> applicative, FunctionType<FT, App<F, FR>> input, Pair<K, ?> pair, TypedOptic<S, T, FT, FR> optic) {
                        Traversal traversal = Optics.toTraversal(optic.upCast(TraversalP.Mu.TYPE_TOKEN).orElseThrow(IllegalArgumentException::new));
                        return applicative.ap(value -> Pair.of(pair.getFirst(), value), traversal.wander(applicative, input).apply(pair.getSecond()));
                    }
                };
            } else {
                throw new IllegalStateException("Could not merge TaggedChoiceType optics, unknown bound: " + Arrays.toString(bounds.toArray()));
            }
            Map<Object, Type> newTypes = this.types.entrySet().stream().map(e -> Pair.of(e.getKey(), optics.containsKey(e.getKey()) ? ((TypedOptic)optics.get(e.getKey())).tType() : (Type)e.getValue())).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
            return Either.left(new TypedOptic((TypeToken<K1>)bound, this, DSL.taggedChoiceType(this.name, this.keyType, newTypes), type, resultType, optic));
        }

        private <S, T, FT, FR> TypedOptic<Pair<K, ?>, Pair<K, ?>, FT, FR> cap(TaggedChoiceType<K> choiceType, K key, TypedOptic<S, T, FT, FR> optic) {
            return TypedOptic.tagged(choiceType, key, optic.sType(), optic.tType()).compose(optic);
        }

        @Override
        public Optional<TaggedChoiceType<?>> findChoiceType(String name, int index) {
            if (Objects.equals(name, this.name)) {
                return Optional.of(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<Type<?>> findCheckedType(int index) {
            return this.types.values().stream().map(type -> type.findCheckedType(index)).filter(Optional::isPresent).findFirst().flatMap(Function.identity());
        }

        @Override
        public boolean equals(Object obj, boolean ignoreRecursionPoints, boolean checkIndex) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof TaggedChoiceType)) {
                return false;
            }
            TaggedChoiceType other = (TaggedChoiceType)obj;
            if (!Objects.equals(this.name, other.name)) {
                return false;
            }
            if (!this.keyType.equals(other.keyType, ignoreRecursionPoints, checkIndex)) {
                return false;
            }
            if (this.types.size() != other.types.size()) {
                return false;
            }
            for (Map.Entry<K, Type<?>> entry : this.types.entrySet()) {
                if (entry.getValue().equals(other.types.get(entry.getKey()), ignoreRecursionPoints, checkIndex)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public String toString() {
            return "TaggedChoiceType[" + this.name + ", " + Joiner.on((String)", \n").withKeyValueSeparator(" -> ").join(this.types) + "]\n";
        }

        public String getName() {
            return this.name;
        }

        public Type<K> getKeyType() {
            return this.keyType;
        }

        public boolean hasType(K key) {
            return this.types.containsKey(key);
        }

        public Map<K, Type<?>> types() {
            return this.types;
        }

        private static final class RewriteFunc<K>
        implements Function<DynamicOps<?>, Function<Pair<K, ?>, Pair<K, ?>>> {
            private final Map<K, ? extends RewriteResult<?, ?>> results;

            public RewriteFunc(Map<K, ? extends RewriteResult<?, ?>> results) {
                this.results = results;
            }

            @Override
            public FunctionType<Pair<K, ?>, Pair<K, ?>> apply(DynamicOps<?> ops) {
                return input -> {
                    RewriteResult<?, ?> result = this.results.get(input.getFirst());
                    if (result == null) {
                        return input;
                    }
                    return this.capRuleApply(ops, (Pair<K, ?>)input, result);
                };
            }

            private <A, B> Pair<K, B> capRuleApply(DynamicOps<?> ops, Pair<K, ?> input, RewriteResult<A, B> result) {
                return input.mapSecond(v -> result.view().function().evalCached().apply(ops).apply(v));
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RewriteFunc that = (RewriteFunc)o;
                return Objects.equals(this.results, that.results);
            }

            public int hashCode() {
                return Objects.hash(this.results);
            }
        }
    }
}

