/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbrp_node")
public class STBRPNode
extends Struct {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X;
    public static final int Y;
    public static final int NEXT;

    STBRPNode(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public STBRPNode(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBRPNode.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="stbrp_coord")
    public short x() {
        return STBRPNode.nx(this.address());
    }

    @NativeType(value="stbrp_coord")
    public short y() {
        return STBRPNode.ny(this.address());
    }

    @Nullable
    @NativeType(value="stbrp_node *")
    public STBRPNode next() {
        return STBRPNode.nnext(this.address());
    }

    public static STBRPNode create(long address) {
        return new STBRPNode(address, null);
    }

    @Nullable
    public static STBRPNode createSafe(long address) {
        return address == 0L ? null : STBRPNode.create(address);
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : STBRPNode.create(address, capacity);
    }

    public static short nx(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)X));
    }

    public static short ny(long struct) {
        return MemoryUtil.memGetShort((long)(struct + (long)Y));
    }

    @Nullable
    public static STBRPNode nnext(long struct) {
        return STBRPNode.createSafe(MemoryUtil.memGetAddress((long)(struct + (long)NEXT)));
    }

    static {
        Struct.Layout layout = STBRPNode.__struct((Struct.Member[])new Struct.Member[]{STBRPNode.__member((int)2), STBRPNode.__member((int)2), STBRPNode.__member((int)POINTER_SIZE)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X = layout.offsetof(0);
        Y = layout.offsetof(1);
        NEXT = layout.offsetof(2);
    }

    public static class Buffer
    extends StructBuffer<STBRPNode, Buffer> {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBRPNode newInstance(long address) {
            return new STBRPNode(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        @NativeType(value="stbrp_coord")
        public short x() {
            return STBRPNode.nx(this.address());
        }

        @NativeType(value="stbrp_coord")
        public short y() {
            return STBRPNode.ny(this.address());
        }

        @Nullable
        @NativeType(value="stbrp_node *")
        public STBRPNode next() {
            return STBRPNode.nnext(this.address());
        }
    }
}

