/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements bn,
Runnable,
tp,
uk {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private final bfe l;
    private final uj m = new uj("server", this, MinecraftServer.aw());
    private final File n;
    private final List<nv> o = Lists.newArrayList();
    public final bl b;
    public final rj c = new rj();
    private final ox p;
    private final ms q = new ms();
    private final Random r = new Random();
    private final rw s;
    private int u = -1;
    public om[] d;
    private pj v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private boolean E;
    private String F;
    private int G;
    private int H;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair I;
    private String J;
    private String K;
    private String L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private final GameProfileRepository X;
    private final pf Y;
    private long Z;
    public final Queue<FutureTask<?>> j = Queues.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.aw();
    private boolean ac;

    public MinecraftServer(File file, Proxy proxy, rw rw2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, pf pf2) {
        this.e = proxy;
        this.V = yggdrasilAuthenticationService;
        this.W = minecraftSessionService;
        this.X = gameProfileRepository;
        this.Y = pf2;
        this.n = file;
        this.p = new ox(this);
        this.b = this.i();
        this.l = new bex(file, rw2);
        this.s = rw2;
    }

    public dh i() {
        return new dh(this);
    }

    public abstract boolean j() throws IOException;

    public void a(String string) {
        if (this.W().b(string)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.W().a(string, new rk(){
                private long b = MinecraftServer.aw();

                @Override
                public void a(String string) {
                }

                @Override
                public void b(String string) {
                }

                @Override
                public void a(int n2) {
                    if (MinecraftServer.aw() - this.b >= 1000L) {
                        this.b = MinecraftServer.aw();
                        k.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(String string) {
                }
            });
        }
    }

    protected synchronized void b(String string) {
        this.S = string;
    }

    @Nullable
    public synchronized String k() {
        return this.S;
    }

    public void a(String string, String string2, long l22, amx amx2, String string3) {
        amv \u26033;
        this.a(string);
        this.b("menu.loadingLevel");
        this.d = new om[3];
        this.i = new long[this.d.length][100];
        bfc bfc2 = this.l.a(string, true);
        this.a(this.S(), bfc2);
        bfb \u26032 = bfc2.d();
        if (\u26032 == null) {
            if (this.V()) {
                \u26033 = og.a;
            } else {
                long l22;
                \u26033 = new amv(l22, this.n(), this.m(), this.p(), amx2);
                \u26033.a(string3);
                if (this.N) {
                    \u26033.a();
                }
            }
            \u26032 = new bfb(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new amv(\u26032);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            \u2603 = 0;
            if (i2 == 1) {
                \u2603 = -1;
            }
            if (i2 == 2) {
                \u2603 = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.V() ? (om)new og(this, bfc2, \u26032, \u2603, this.c).b() : (om)new om(this, bfc2, \u26032, \u2603, this.c).b();
                this.d[i2].a(\u26033);
            } else {
                this.d[i2] = (om)new oi(this, bfc2, \u2603, this.d[0], this.c).b();
            }
            this.d[i2].a(new on(this, this.d[i2]));
            if (this.R()) continue;
            this.d[i2].V().a(this.n());
        }
        this.v.a(this.d);
        this.a(this.o());
        this.l();
    }

    public void l() {
        int n2 = 16;
        \u2603 = 4;
        \u2603 = 192;
        \u2603 = 625;
        \u2603 = 0;
        this.b("menu.generatingTerrain");
        boolean \u26032 = false;
        k.info("Preparing start region for level 0");
        om \u26033 = this.d[0];
        et \u26034 = \u26033.T();
        long \u26035 = MinecraftServer.aw();
        for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
            for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
                long l2 = MinecraftServer.aw();
                if (l2 - \u26035 > 1000L) {
                    this.a_("Preparing spawn area", \u2603 * 100 / 625);
                    \u26035 = l2;
                }
                ++\u2603;
                \u26033.r().c(\u26034.p() + \u2603 >> 4, \u26034.r() + \u2603 >> 4);
            }
        }
        this.t();
    }

    public void a(String string, bfc bfc2) {
        File file = new File(bfc2.b(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a_("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                k.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean m();

    public abstract amq n();

    public abstract tx o();

    public abstract boolean p();

    public abstract int q();

    public abstract boolean r();

    public abstract boolean s();

    protected void a_(String string, int n2) {
        this.f = string;
        this.g = n2;
        k.info("{}: {}%", (Object)string, (Object)n2);
    }

    protected void t() {
        this.f = null;
        this.g = 0;
    }

    public void a(boolean bl2) {
        for (om om2 : this.d) {
            if (om2 == null) continue;
            if (!bl2) {
                k.info("Saving chunks for level '{}'/{}", (Object)om2.V().j(), (Object)om2.s.q().b());
            }
            try {
                om2.a(true, null);
            }
            catch (amt amt2) {
                k.warn(amt2.getMessage());
            }
        }
    }

    public void u() {
        k.info("Stopping server");
        if (this.an() != null) {
            this.an().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            k.info("Saving worlds");
            for (om om2 : this.d) {
                if (om2 == null) continue;
                om2.b = false;
            }
            this.a(false);
            for (om om2 : this.d) {
                if (om2 == null) continue;
                om2.s();
            }
        }
        if (this.m.d()) {
            this.m.e();
        }
    }

    public boolean w() {
        return this.w;
    }

    public void x() {
        this.w = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.j()) {
                this.ab = MinecraftServer.aw();
                long l2 = 0L;
                this.q.a(new ho(this.F));
                this.q.a(new ms.c("1.12", 335));
                this.a(this.q);
                while (this.w) {
                    \u2603 = MinecraftServer.aw();
                    \u2603 = \u2603 - this.ab;
                    if (\u2603 > 2000L && this.ab - this.R >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", (Object)\u2603, (Object)(\u2603 / 50L));
                        \u2603 = 2000L;
                        this.R = this.ab;
                    }
                    if (\u2603 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        \u2603 = 0L;
                    }
                    l2 += \u2603;
                    this.ab = \u2603;
                    if (this.d[0].g()) {
                        this.C();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.C();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.Q = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            k.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof f ? this.b(((f)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.A(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(\u26032)) {
                k.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.x = true;
                this.u();
            }
            catch (Throwable \u26033) {
                k.error("Exception stopping the server", \u26033);
            }
            finally {
                this.B();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(ms ms2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.W().b(this.S(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf \u26032 = Base64.encode((ByteBuf)byteBuf);
                ms2.a("data:image/png;base64," + \u26032.toString(StandardCharsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean y() {
        this.ac = this.ac || this.z().isFile();
        return this.ac;
    }

    public File z() {
        return this.W().b(this.S(), "icon.png");
    }

    public File A() {
        return new File(".");
    }

    public void a(b b2) {
    }

    public void B() {
    }

    public void C() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.D();
        if (l2 - this.Z >= 5000000000L) {
            this.Z = l2;
            this.q.a(new ms.a(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int \u26032 = ri.a(this.r, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.v().get(\u26032 + i2).da();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - l2;
        this.c.b();
        this.c.a("snooper");
        if (!this.m.d() && this.y > 100) {
            this.m.a();
        }
        if (this.y % 6000 == 0) {
            this.m.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void D() {
        int n2;
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                h.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        for (n2 = 0; n2 < this.d.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.E()) {
                om om2 = this.d[n2];
                this.c.a(om2.V().j());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new kn(om2.R(), om2.S(), om2.W().b("doDaylightCycle")), om2.s.q().a());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    om2.d();
                }
                catch (Throwable \u26032) {
                    b b2 = b.a(\u26032, "Exception ticking world");
                    om2.a(b2);
                    throw new f(b2);
                }
                try {
                    om2.k();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    om2.a(b3);
                    throw new f(b3);
                }
                this.c.b();
                this.c.a("tracker");
                om2.v().a();
                this.c.b();
                this.c.b();
            }
            this.i[n2][this.y % 100] = System.nanoTime() - l2;
        }
        this.c.c("connection");
        this.an().c();
        this.c.c("players");
        this.v.e();
        this.c.c("commandFunctions");
        this.aL().e();
        this.c.c("tickables");
        for (n2 = 0; n2 < this.o.size(); ++n2) {
            this.o.get(n2).e();
        }
        this.c.b();
    }

    public boolean E() {
        return true;
    }

    public void F() {
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String string) {
        return new File(this.A(), string);
    }

    public void f(String string) {
        k.warn(string);
    }

    public om a(int n2) {
        if (n2 == -1) {
            return this.d[1];
        }
        if (n2 == 1) {
            return this.d[2];
        }
        return this.d[0];
    }

    public String G() {
        return "1.12";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new d<String>(){

            public String a() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        });
        if (this.v != null) {
            b2.g().a("Player Count", new d<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        return b2;
    }

    public List<String> a(bn bn2, String string2, @Nullable et et2, boolean bl22) {
        boolean bl22;
        String string2;
        ArrayList arrayList = Lists.newArrayList();
        boolean \u26032 = string2.startsWith("/");
        if (\u26032) {
            string2 = string2.substring(1);
        }
        if (\u26032 || bl22) {
            \u2603 = !string2.contains(" ");
            List<String> list = this.b.a(bn2, string2, et2);
            if (!list.isEmpty()) {
                for (String string3 : list) {
                    if (\u2603 && !bl22) {
                        arrayList.add("/" + string3);
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
        String[] \u26033 = string2.split(" ", -1);
        \u2603 = \u26033[\u26033.length - 1];
        for (String string4 : this.v.f()) {
            if (!bi.a(\u2603, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean M() {
        return this.n != null;
    }

    @Override
    public String h_() {
        return "Server";
    }

    @Override
    public void a(hh hh2) {
        k.info(hh2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public bl N() {
        return this.b;
    }

    public KeyPair O() {
        return this.I;
    }

    public String Q() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public boolean R() {
        return this.J != null;
    }

    public String S() {
        return this.K;
    }

    public void j(String string) {
        this.K = string;
    }

    public void k(String string) {
        this.L = string;
    }

    public String T() {
        return this.L;
    }

    public void a(KeyPair keyPair) {
        this.I = keyPair;
    }

    public void a(tx tx2) {
        for (om om2 : this.d) {
            if (om2 == null) continue;
            if (om2.V().s()) {
                om2.V().a(tx.d);
                om2.a(true, true);
                continue;
            }
            if (this.R()) {
                om2.V().a(tx2);
                om2.a(om2.ag() != tx.a, true);
                continue;
            }
            om2.V().a(tx2);
            om2.a(this.U(), this.B);
        }
    }

    public boolean U() {
        return true;
    }

    public boolean V() {
        return this.M;
    }

    public void b(boolean bl2) {
        this.M = bl2;
    }

    public void c(boolean bl2) {
        this.N = bl2;
    }

    public bfe W() {
        return this.l;
    }

    public String X() {
        return this.O;
    }

    public String Y() {
        return this.P;
    }

    public void a_(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(uj uj22) {
        uj uj22;
        uj22.a("whitelist_enabled", false);
        uj22.a("whitelist_count", 0);
        if (this.v != null) {
            uj22.a("players_current", this.H());
            uj22.a("players_max", this.I());
            uj22.a("players_seen", this.v.q().length);
        }
        uj22.a("uses_auth", this.z);
        uj22.a("gui_state", this.ap() ? "enabled" : "disabled");
        uj22.a("run_time", (MinecraftServer.aw() - uj22.g()) / 60L * 1000L);
        uj22.a("avg_tick_ms", (int)(ri.a(this.h) * 1.0E-6));
        int n2 = 0;
        if (this.d != null) {
            for (om om2 : this.d) {
                if (om2 == null) continue;
                bfb bfb2 = om2.V();
                uj22.a("world[" + n2 + "][dimension]", om2.s.q().a());
                uj22.a("world[" + n2 + "][mode]", (Object)bfb2.q());
                uj22.a("world[" + n2 + "][difficulty]", (Object)om2.ag());
                uj22.a("world[" + n2 + "][hardcore]", bfb2.s());
                uj22.a("world[" + n2 + "][generator_name]", bfb2.t().a());
                uj22.a("world[" + n2 + "][generator_version]", bfb2.t().d());
                uj22.a("world[" + n2 + "][height]", this.G);
                uj22.a("world[" + n2 + "][chunks_loaded]", om2.r().g());
                ++n2;
            }
        }
        uj22.a("worlds", n2);
    }

    @Override
    public void b(uj uj2) {
        uj2.b("singleplayer", this.R());
        uj2.b("server_brand", this.getServerModName());
        uj2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        uj2.b("dedicated", this.aa());
    }

    @Override
    public boolean Z() {
        return true;
    }

    public abstract boolean aa();

    public boolean ab() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean ac() {
        return this.A;
    }

    public boolean ad() {
        return this.B;
    }

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean ae() {
        return this.C;
    }

    public abstract boolean af();

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean ag() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public boolean ah() {
        return this.E;
    }

    public void i(boolean bl2) {
        this.E = bl2;
    }

    public abstract boolean ai();

    public String aj() {
        return this.F;
    }

    public void l(String string) {
        this.F = string;
    }

    public int ak() {
        return this.G;
    }

    public void c(int n2) {
        this.G = n2;
    }

    public boolean al() {
        return this.x;
    }

    public pj am() {
        return this.v;
    }

    public void a(pj pj2) {
        this.v = pj2;
    }

    public void a(amq amq2) {
        for (om om2 : this.d) {
            om2.V().a(amq2);
        }
    }

    public ox an() {
        return this.p;
    }

    public boolean ao() {
        return this.Q;
    }

    public boolean ap() {
        return false;
    }

    public abstract String a(amq var1, boolean var2);

    public int aq() {
        return this.y;
    }

    public void ar() {
        this.T = true;
    }

    public uj as() {
        return this.m;
    }

    @Override
    public ams e() {
        return this.d[0];
    }

    public boolean a(ams ams2, et et2, aeb aeb2) {
        return false;
    }

    public boolean au() {
        return this.U;
    }

    public Proxy av() {
        return this.e;
    }

    public static long aw() {
        return System.currentTimeMillis();
    }

    public int ax() {
        return this.H;
    }

    public void d(int n2) {
        this.H = n2;
    }

    public MinecraftSessionService az() {
        return this.W;
    }

    public GameProfileRepository aA() {
        return this.X;
    }

    public pf aB() {
        return this.Y;
    }

    public ms aC() {
        return this.q;
    }

    public void aD() {
        this.Z = 0L;
    }

    @Nullable
    public ve a(UUID uUID) {
        for (om om2 : this.d) {
            if (om2 == null || (\u2603 = om2.a(uUID)) == null) continue;
            return \u2603;
        }
        return null;
    }

    @Override
    public boolean g() {
        return this.d[0].W().b("sendCommandFeedback");
    }

    @Override
    public MinecraftServer C_() {
        return this;
    }

    public int aE() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.aF() && !this.al()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aF() {
        return Thread.currentThread() == this.aa;
    }

    public int aG() {
        return 256;
    }

    public int a(@Nullable om om2) {
        if (om2 != null) {
            return om2.W().c("spawnRadius");
        }
        return 10;
    }

    public nq aK() {
        return this.d[0].z();
    }

    public nr aL() {
        return this.d[0].A();
    }

    public void aM() {
        if (this.aF()) {
            this.am().j();
            this.d[0].am().a();
            this.aK().a();
            this.aL().f();
            this.am().w();
        } else {
            this.a(this::aM);
        }
    }
}

