/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.ch;

import java.nio.channels.AsynchronousCloseException;
import java.util.HashMap;
import java.util.Map;
import sun.misc.Unsafe;
import sun.nio.ch.Groupable;
import sun.nio.ch.Iocp;
import sun.nio.ch.PendingFuture;

class PendingIoCache {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final int addressSize = unsafe.addressSize();
    private static final int SIZEOF_OVERLAPPED = PendingIoCache.dependsArch(20, 32);
    private boolean closed;
    private boolean closePending;
    private final Map<Long, PendingFuture> pendingIoMap = new HashMap<Long, PendingFuture>();
    private long[] overlappedCache = new long[4];
    private int overlappedCacheCount = 0;

    private static int dependsArch(int n, int n2) {
        return addressSize == 4 ? n : n2;
    }

    PendingIoCache() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long add(PendingFuture<?, ?> pendingFuture) {
        PendingIoCache pendingIoCache = this;
        synchronized (pendingIoCache) {
            if (this.closed) {
                throw new AssertionError((Object)"Should not get here");
            }
            long l = this.overlappedCacheCount > 0 ? this.overlappedCache[--this.overlappedCacheCount] : unsafe.allocateMemory(SIZEOF_OVERLAPPED);
            this.pendingIoMap.put(l, pendingFuture);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <V, A> PendingFuture<V, A> remove(long l) {
        PendingIoCache pendingIoCache = this;
        synchronized (pendingIoCache) {
            PendingFuture pendingFuture = this.pendingIoMap.remove(l);
            if (pendingFuture != null) {
                if (this.overlappedCacheCount < this.overlappedCache.length) {
                    this.overlappedCache[this.overlappedCacheCount++] = l;
                } else {
                    unsafe.freeMemory(l);
                }
                if (this.closePending) {
                    this.notifyAll();
                }
            }
            return pendingFuture;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void close() {
        PendingIoCache pendingIoCache = this;
        synchronized (pendingIoCache) {
            if (this.closed) {
                return;
            }
            if (!this.pendingIoMap.isEmpty()) {
                this.clearPendingIoMap();
            }
            while (this.overlappedCacheCount > 0) {
                unsafe.freeMemory(this.overlappedCache[--this.overlappedCacheCount]);
            }
            this.closed = true;
        }
    }

    private void clearPendingIoMap() {
        assert (Thread.holdsLock(this));
        this.closePending = true;
        try {
            this.wait(50L);
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        this.closePending = false;
        if (this.pendingIoMap.isEmpty()) {
            return;
        }
        for (Long l : this.pendingIoMap.keySet()) {
            PendingFuture pendingFuture = this.pendingIoMap.get(l);
            assert (!pendingFuture.isDone());
            Iocp iocp = (Iocp)((Groupable)((Object)pendingFuture.channel())).group();
            iocp.makeStale(l);
            final Iocp.ResultHandler resultHandler = (Iocp.ResultHandler)pendingFuture.getContext();
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    resultHandler.failed(-1, new AsynchronousCloseException());
                }
            };
            iocp.executeOnPooledThread(runnable);
        }
        this.pendingIoMap.clear();
    }
}

