/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.metal;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicScrollBarUI;
import javax.swing.plaf.metal.MetalBumps;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalScrollButton;
import javax.swing.plaf.metal.MetalUtils;
import sun.swing.SwingUtilities2;

public class MetalScrollBarUI
extends BasicScrollBarUI {
    private static Color shadowColor;
    private static Color highlightColor;
    private static Color darkShadowColor;
    private static Color thumbColor;
    private static Color thumbShadow;
    private static Color thumbHighlightColor;
    protected MetalBumps bumps;
    protected MetalScrollButton increaseButton;
    protected MetalScrollButton decreaseButton;
    protected int scrollBarWidth;
    public static final String FREE_STANDING_PROP = "JScrollBar.isFreeStanding";
    protected boolean isFreeStanding = true;

    public static ComponentUI createUI(JComponent jComponent) {
        return new MetalScrollBarUI();
    }

    @Override
    protected void installDefaults() {
        this.scrollBarWidth = (Integer)UIManager.get("ScrollBar.width");
        super.installDefaults();
        this.bumps = new MetalBumps(10, 10, thumbHighlightColor, thumbShadow, thumbColor);
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        ((ScrollBarListener)this.propertyChangeListener).handlePropertyChange(this.scrollbar.getClientProperty(FREE_STANDING_PROP));
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        return new ScrollBarListener();
    }

    @Override
    protected void configureScrollBarColors() {
        super.configureScrollBarColors();
        shadowColor = UIManager.getColor("ScrollBar.shadow");
        highlightColor = UIManager.getColor("ScrollBar.highlight");
        darkShadowColor = UIManager.getColor("ScrollBar.darkShadow");
        thumbColor = UIManager.getColor("ScrollBar.thumb");
        thumbShadow = UIManager.getColor("ScrollBar.thumbShadow");
        thumbHighlightColor = UIManager.getColor("ScrollBar.thumbHighlight");
    }

    @Override
    public Dimension getPreferredSize(JComponent jComponent) {
        if (this.scrollbar.getOrientation() == 1) {
            return new Dimension(this.scrollBarWidth, this.scrollBarWidth * 3 + 10);
        }
        return new Dimension(this.scrollBarWidth * 3 + 10, this.scrollBarWidth);
    }

    @Override
    protected JButton createDecreaseButton(int n) {
        this.decreaseButton = new MetalScrollButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.decreaseButton;
    }

    @Override
    protected JButton createIncreaseButton(int n) {
        this.increaseButton = new MetalScrollButton(n, this.scrollBarWidth, this.isFreeStanding);
        return this.increaseButton;
    }

    @Override
    protected void paintTrack(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        graphics.translate(rectangle.x, rectangle.y);
        boolean bl = MetalUtils.isLeftToRight(jComponent);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                rectangle.width += 2;
                if (!bl) {
                    graphics.translate(-1, 0);
                }
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                SwingUtilities2.drawVLine(graphics, 0, 0, rectangle.height - 1);
                SwingUtilities2.drawVLine(graphics, rectangle.width - 2, 0, rectangle.height - 1);
                SwingUtilities2.drawHLine(graphics, 2, rectangle.width - 1, rectangle.height - 1);
                SwingUtilities2.drawHLine(graphics, 2, rectangle.width - 2, 0);
                graphics.setColor(shadowColor);
                SwingUtilities2.drawVLine(graphics, 1, 1, rectangle.height - 2);
                SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 3, 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n = this.thumbRect.y + this.thumbRect.height - rectangle.y;
                    SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 1, n);
                }
                graphics.setColor(highlightColor);
                SwingUtilities2.drawVLine(graphics, rectangle.width - 1, 0, rectangle.height - 1);
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.width -= 2;
                if (!bl) {
                    graphics.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            if (jComponent.isEnabled()) {
                graphics.setColor(darkShadowColor);
                SwingUtilities2.drawHLine(graphics, 0, rectangle.width - 1, 0);
                SwingUtilities2.drawVLine(graphics, 0, 2, rectangle.height - 2);
                SwingUtilities2.drawHLine(graphics, 0, rectangle.width - 1, rectangle.height - 2);
                SwingUtilities2.drawVLine(graphics, rectangle.width - 1, 2, rectangle.height - 1);
                graphics.setColor(shadowColor);
                SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 2, 1);
                SwingUtilities2.drawVLine(graphics, 1, 1, rectangle.height - 3);
                SwingUtilities2.drawHLine(graphics, 0, rectangle.width - 1, rectangle.height - 1);
                if (this.scrollbar.getValue() != this.scrollbar.getMaximum()) {
                    int n = this.thumbRect.x + this.thumbRect.width - rectangle.x;
                    SwingUtilities2.drawVLine(graphics, n, 1, rectangle.height - 1);
                }
            } else {
                MetalUtils.drawDisabledBorder(graphics, 0, 0, rectangle.width, rectangle.height);
            }
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    protected void paintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        if (!jComponent.isEnabled()) {
            return;
        }
        if (MetalLookAndFeel.usingOcean()) {
            this.oceanPaintThumb(graphics, jComponent, rectangle);
            return;
        }
        boolean bl = MetalUtils.isLeftToRight(jComponent);
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                rectangle.width += 2;
                if (!bl) {
                    graphics.translate(-1, 0);
                }
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbShadow);
            SwingUtilities2.drawRect(graphics, 0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 3, 1);
            SwingUtilities2.drawVLine(graphics, 1, 1, rectangle.height - 2);
            this.bumps.setBumpArea(rectangle.width - 6, rectangle.height - 7);
            this.bumps.paintIcon(jComponent, graphics, 3, 4);
            if (!this.isFreeStanding) {
                rectangle.width -= 2;
                if (!bl) {
                    graphics.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            graphics.setColor(thumbColor);
            graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbShadow);
            SwingUtilities2.drawRect(graphics, 0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbHighlightColor);
            SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 3, 1);
            SwingUtilities2.drawVLine(graphics, 1, 1, rectangle.height - 3);
            this.bumps.setBumpArea(rectangle.width - 7, rectangle.height - 6);
            this.bumps.paintIcon(jComponent, graphics, 4, 3);
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    private void oceanPaintThumb(Graphics graphics, JComponent jComponent, Rectangle rectangle) {
        boolean bl = MetalUtils.isLeftToRight(jComponent);
        graphics.translate(rectangle.x, rectangle.y);
        if (this.scrollbar.getOrientation() == 1) {
            if (!this.isFreeStanding) {
                rectangle.width += 2;
                if (!bl) {
                    graphics.translate(-1, 0);
                }
            }
            if (thumbColor != null) {
                graphics.setColor(thumbColor);
                graphics.fillRect(0, 0, rectangle.width - 2, rectangle.height - 1);
            }
            graphics.setColor(thumbShadow);
            SwingUtilities2.drawRect(graphics, 0, 0, rectangle.width - 2, rectangle.height - 1);
            graphics.setColor(thumbHighlightColor);
            SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 3, 1);
            SwingUtilities2.drawVLine(graphics, 1, 1, rectangle.height - 2);
            MetalUtils.drawGradient(jComponent, graphics, "ScrollBar.gradient", 2, 2, rectangle.width - 4, rectangle.height - 3, false);
            int n = rectangle.width - 8;
            if (n > 2 && rectangle.height >= 10) {
                int n2;
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                int n3 = rectangle.height / 2 - 2;
                for (n2 = 0; n2 < 6; n2 += 2) {
                    graphics.fillRect(4, n2 + n3, n, 1);
                }
                graphics.setColor(MetalLookAndFeel.getWhite());
                ++n3;
                for (n2 = 0; n2 < 6; n2 += 2) {
                    graphics.fillRect(5, n2 + n3, n, 1);
                }
            }
            if (!this.isFreeStanding) {
                rectangle.width -= 2;
                if (!bl) {
                    graphics.translate(1, 0);
                }
            }
        } else {
            if (!this.isFreeStanding) {
                rectangle.height += 2;
            }
            if (thumbColor != null) {
                graphics.setColor(thumbColor);
                graphics.fillRect(0, 0, rectangle.width - 1, rectangle.height - 2);
            }
            graphics.setColor(thumbShadow);
            SwingUtilities2.drawRect(graphics, 0, 0, rectangle.width - 1, rectangle.height - 2);
            graphics.setColor(thumbHighlightColor);
            SwingUtilities2.drawHLine(graphics, 1, rectangle.width - 2, 1);
            SwingUtilities2.drawVLine(graphics, 1, 1, rectangle.height - 3);
            MetalUtils.drawGradient(jComponent, graphics, "ScrollBar.gradient", 2, 2, rectangle.width - 3, rectangle.height - 4, true);
            int n = rectangle.height - 8;
            if (n > 2 && rectangle.width >= 10) {
                int n4;
                graphics.setColor(MetalLookAndFeel.getPrimaryControlDarkShadow());
                int n5 = rectangle.width / 2 - 2;
                for (n4 = 0; n4 < 6; n4 += 2) {
                    graphics.fillRect(n5 + n4, 4, 1, n);
                }
                graphics.setColor(MetalLookAndFeel.getWhite());
                ++n5;
                for (n4 = 0; n4 < 6; n4 += 2) {
                    graphics.fillRect(n5 + n4, 5, 1, n);
                }
            }
            if (!this.isFreeStanding) {
                rectangle.height -= 2;
            }
        }
        graphics.translate(-rectangle.x, -rectangle.y);
    }

    @Override
    protected Dimension getMinimumThumbSize() {
        return new Dimension(this.scrollBarWidth, this.scrollBarWidth);
    }

    @Override
    protected void setThumbBounds(int n, int n2, int n3, int n4) {
        if (this.thumbRect.x == n && this.thumbRect.y == n2 && this.thumbRect.width == n3 && this.thumbRect.height == n4) {
            return;
        }
        int n5 = Math.min(n, this.thumbRect.x);
        int n6 = Math.min(n2, this.thumbRect.y);
        int n7 = Math.max(n + n3, this.thumbRect.x + this.thumbRect.width);
        int n8 = Math.max(n2 + n4, this.thumbRect.y + this.thumbRect.height);
        this.thumbRect.setBounds(n, n2, n3, n4);
        this.scrollbar.repaint(n5, n6, n7 - n5 + 1, n8 - n6 + 1);
    }

    class ScrollBarListener
    extends BasicScrollBarUI.PropertyChangeHandler {
        ScrollBarListener() {
            super(MetalScrollBarUI.this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals(MetalScrollBarUI.FREE_STANDING_PROP)) {
                this.handlePropertyChange(propertyChangeEvent.getNewValue());
            } else {
                super.propertyChange(propertyChangeEvent);
            }
        }

        public void handlePropertyChange(Object object) {
            if (object != null) {
                boolean bl = (Boolean)object;
                boolean bl2 = !bl && MetalScrollBarUI.this.isFreeStanding;
                boolean bl3 = bl && !MetalScrollBarUI.this.isFreeStanding;
                MetalScrollBarUI.this.isFreeStanding = bl;
                if (bl2) {
                    this.toFlush();
                } else if (bl3) {
                    this.toFreeStanding();
                }
            } else if (!MetalScrollBarUI.this.isFreeStanding) {
                MetalScrollBarUI.this.isFreeStanding = true;
                this.toFreeStanding();
            }
            if (MetalScrollBarUI.this.increaseButton != null) {
                MetalScrollBarUI.this.increaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
            }
            if (MetalScrollBarUI.this.decreaseButton != null) {
                MetalScrollBarUI.this.decreaseButton.setFreeStanding(MetalScrollBarUI.this.isFreeStanding);
            }
        }

        protected void toFlush() {
            MetalScrollBarUI.this.scrollBarWidth -= 2;
        }

        protected void toFreeStanding() {
            MetalScrollBarUI.this.scrollBarWidth += 2;
        }
    }
}

