/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements Runnable,
n,
qh,
rc {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private final bad l;
    private final rb m = new rb("server", this, MinecraftServer.av());
    private final File n;
    private final List<lb> o = Lists.newArrayList();
    public final m b;
    public final oq c = new oq();
    private final md p;
    private final kc q = new kc();
    private final Random r = new Random();
    private final pd s;
    private int u = -1;
    public ls[] d;
    private mp v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private String N = "";
    private String O = "";
    private boolean P;
    private long Q;
    private String R;
    private boolean S;
    private boolean T;
    private final YggdrasilAuthenticationService U;
    private final MinecraftSessionService V;
    private final GameProfileRepository W;
    private final ml X;
    private long Y;
    public final Queue<FutureTask<?>> j = Queues.newArrayDeque();
    private Thread Z;
    private long aa = MinecraftServer.av();
    private boolean ab;

    public MinecraftServer(File file, Proxy proxy, pd pd2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, ml ml2) {
        this.e = proxy;
        this.U = yggdrasilAuthenticationService;
        this.V = minecraftSessionService;
        this.W = gameProfileRepository;
        this.X = ml2;
        this.n = file;
        this.p = new md(this);
        this.b = this.i();
        this.l = new azw(file, pd2);
        this.s = pd2;
    }

    public bd i() {
        return new bd(this);
    }

    public abstract boolean j() throws IOException;

    public void a(String string) {
        if (this.W().b(string)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.W().a(string, new or(){
                private long b = MinecraftServer.av();

                @Override
                public void a(String string) {
                }

                @Override
                public void b(String string) {
                }

                @Override
                public void a(int n2) {
                    if (MinecraftServer.av() - this.b >= 1000L) {
                        this.b = MinecraftServer.av();
                        k.info("Converting... {}%", new Object[]{n2});
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(String string) {
                }
            });
        }
    }

    protected synchronized void b(String string) {
        this.R = string;
    }

    public synchronized String k() {
        return this.R;
    }

    public void a(String string, String string2, long l22, aii aii2, String string3) {
        aig \u26033;
        this.a(string);
        this.b("menu.loadingLevel");
        this.d = new ls[3];
        this.i = new long[this.d.length][100];
        bab bab2 = this.l.a(string, true);
        this.a(this.S(), bab2);
        baa \u26032 = bab2.d();
        if (\u26032 == null) {
            if (this.V()) {
                \u26033 = lm.a;
            } else {
                long l22;
                \u26033 = new aig(l22, this.n(), this.m(), this.p(), aii2);
                \u26033.a(string3);
                if (this.M) {
                    \u26033.a();
                }
            }
            \u26032 = new baa(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new aig(\u26032);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            \u2603 = 0;
            if (i2 == 1) {
                \u2603 = -1;
            }
            if (i2 == 2) {
                \u2603 = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.V() ? (ls)new lm(this, bab2, \u26032, \u2603, this.c).b() : (ls)new ls(this, bab2, \u26032, \u2603, this.c).b();
                this.d[i2].a(\u26033);
            } else {
                this.d[i2] = (ls)new lo(this, bab2, \u2603, this.d[0], this.c).b();
            }
            this.d[i2].a(new lt(this, this.d[i2]));
            if (this.R()) continue;
            this.d[i2].T().a(this.n());
        }
        this.v.a(this.d);
        this.a(this.o());
        this.l();
    }

    public void l() {
        int n2 = 16;
        \u2603 = 4;
        \u2603 = 192;
        \u2603 = 625;
        \u2603 = 0;
        this.b("menu.generatingTerrain");
        boolean \u26032 = false;
        k.info("Preparing start region for level 0");
        ls \u26033 = this.d[0];
        cm \u26034 = \u26033.R();
        long \u26035 = MinecraftServer.av();
        for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
            for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
                long l2 = MinecraftServer.av();
                if (l2 - \u26035 > 1000L) {
                    this.a_("Preparing spawn area", \u2603 * 100 / 625);
                    \u26035 = l2;
                }
                ++\u2603;
                \u26033.r().c(\u26034.p() + \u2603 >> 4, \u26034.r() + \u2603 >> 4);
            }
        }
        this.t();
    }

    public void a(String string, bab bab2) {
        File file = new File(bab2.b(), "resources.zip");
        if (file.isFile()) {
            this.a_("level://" + string + "/" + "resources.zip", "");
        }
    }

    public abstract boolean m();

    public abstract aib n();

    public abstract qp o();

    public abstract boolean p();

    public abstract int q();

    public abstract boolean r();

    public abstract boolean s();

    protected void a_(String string, int n2) {
        this.f = string;
        this.g = n2;
        k.info("{}: {}%", new Object[]{string, n2});
    }

    protected void t() {
        this.f = null;
        this.g = 0;
    }

    public void a(boolean bl2) {
        for (ls ls2 : this.d) {
            if (ls2 == null) continue;
            if (!bl2) {
                k.info("Saving chunks for level '{}'/{}", new Object[]{ls2.T().j(), ls2.s.p().b()});
            }
            try {
                ls2.a(true, null);
            }
            catch (aie aie2) {
                k.warn(aie2.getMessage());
            }
        }
    }

    public void u() {
        k.info("Stopping server");
        if (this.am() != null) {
            this.am().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            k.info("Saving worlds");
            for (ls ls2 : this.d) {
                if (ls2 == null) continue;
                ls2.b = false;
            }
            this.a(false);
            for (ls ls2 : this.d) {
                if (ls2 == null) continue;
                ls2.s();
            }
        }
        if (this.m.d()) {
            this.m.e();
        }
    }

    public boolean w() {
        return this.w;
    }

    public void x() {
        this.w = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.j()) {
                this.aa = MinecraftServer.av();
                long l2 = 0L;
                this.q.a(new fe(this.E));
                this.q.a(new kc.c("1.10.1", 210));
                this.a(this.q);
                while (this.w) {
                    \u2603 = MinecraftServer.av();
                    \u2603 = \u2603 - this.aa;
                    if (\u2603 > 2000L && this.aa - this.Q >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{\u2603, \u2603 / 50L});
                        \u2603 = 2000L;
                        this.Q = this.aa;
                    }
                    if (\u2603 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        \u2603 = 0L;
                    }
                    l2 += \u2603;
                    this.aa = \u2603;
                    if (this.d[0].g()) {
                        this.C();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.C();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.P = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            k.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof f ? this.b(((f)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.A(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(\u26032)) {
                k.error("This crash report has been saved to: {}", new Object[]{\u26032.getAbsolutePath()});
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.x = true;
                this.u();
            }
            catch (Throwable \u26033) {
                k.error("Exception stopping the server", \u26033);
            }
            finally {
                this.B();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(kc kc2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.W().b(this.S(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf \u26032 = Base64.encode((ByteBuf)byteBuf);
                kc2.a("data:image/png;base64," + \u26032.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean y() {
        this.ab = this.ab || this.z().isFile();
        return this.ab;
    }

    public File z() {
        return this.W().b(this.S(), "icon.png");
    }

    public File A() {
        return new File(".");
    }

    public void a(b b2) {
    }

    public void B() {
    }

    public void C() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.S) {
            this.S = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.D();
        if (l2 - this.Y >= 5000000000L) {
            this.Y = l2;
            this.q.a(new kc.a(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int \u26032 = op.a(this.r, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.v().get(\u26032 + i2).cP();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - l2;
        this.c.b();
        this.c.a("snooper");
        if (!this.m.d() && this.y > 100) {
            this.m.a();
        }
        if (this.y % 6000 == 0) {
            this.m.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void D() {
        int n2;
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                h.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        for (n2 = 0; n2 < this.d.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.E()) {
                ls ls2 = this.d[n2];
                this.c.a(ls2.T().j());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new ia(ls2.P(), ls2.Q(), ls2.U().b("doDaylightCycle")), ls2.s.p().a());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    ls2.d();
                }
                catch (Throwable \u26032) {
                    b b2 = b.a(\u26032, "Exception ticking world");
                    ls2.a(b2);
                    throw new f(b2);
                }
                try {
                    ls2.k();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    ls2.a(b3);
                    throw new f(b3);
                }
                this.c.b();
                this.c.a("tracker");
                ls2.v().a();
                this.c.b();
                this.c.b();
            }
            this.i[n2][this.y % 100] = System.nanoTime() - l2;
        }
        this.c.c("connection");
        this.am().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (n2 = 0; n2 < this.o.size(); ++n2) {
            this.o.get(n2).E_();
        }
        this.c.b();
    }

    public boolean E() {
        return true;
    }

    public void F() {
        this.Z = new Thread((Runnable)this, "Server thread");
        this.Z.start();
    }

    public File d(String string) {
        return new File(this.A(), string);
    }

    public void f(String string) {
        k.warn(string);
    }

    public ls a(int n2) {
        if (n2 == -1) {
            return this.d[1];
        }
        if (n2 == 1) {
            return this.d[2];
        }
        return this.d[0];
    }

    public String G() {
        return "1.10.1";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new d<String>(){

            public String a() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        });
        if (this.v != null) {
            b2.g().a("Player Count", new d<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        return b2;
    }

    public List<String> a(n n2, String string2, @Nullable cm cm2, boolean bl22) {
        boolean bl22;
        String string2;
        ArrayList arrayList = Lists.newArrayList();
        boolean \u26032 = string2.startsWith("/");
        if (\u26032) {
            string2 = string2.substring(1);
        }
        if (\u26032 || bl22) {
            \u2603 = !string2.contains(" ");
            List<String> list = this.b.a(n2, string2, cm2);
            if (!list.isEmpty()) {
                for (String string3 : list) {
                    if (\u2603) {
                        arrayList.add("/" + string3);
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
        String[] \u26033 = string2.split(" ", -1);
        \u2603 = \u26033[\u26033.length - 1];
        for (String string4 : this.v.f()) {
            if (!j.a(\u2603, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean M() {
        return this.n != null;
    }

    @Override
    public String h_() {
        return "Server";
    }

    @Override
    public void a(ey ey2) {
        k.info(ey2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public m N() {
        return this.b;
    }

    public KeyPair O() {
        return this.H;
    }

    public String Q() {
        return this.I;
    }

    public void i(String string) {
        this.I = string;
    }

    public boolean R() {
        return this.I != null;
    }

    public String S() {
        return this.J;
    }

    public void j(String string) {
        this.J = string;
    }

    public void k(String string) {
        this.K = string;
    }

    public String T() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(qp qp2) {
        for (ls ls2 : this.d) {
            if (ls2 == null) continue;
            if (ls2.T().s()) {
                ls2.T().a(qp.d);
                ls2.a(true, true);
                continue;
            }
            if (this.R()) {
                ls2.T().a(qp2);
                ls2.a(ls2.ae() != qp.a, true);
                continue;
            }
            ls2.T().a(qp2);
            ls2.a(this.U(), this.A);
        }
    }

    public boolean U() {
        return true;
    }

    public boolean V() {
        return this.L;
    }

    public void b(boolean bl2) {
        this.L = bl2;
    }

    public void c(boolean bl2) {
        this.M = bl2;
    }

    public bad W() {
        return this.l;
    }

    public String X() {
        return this.N;
    }

    public String Y() {
        return this.O;
    }

    public void a_(String string, String string2) {
        this.N = string;
        this.O = string2;
    }

    @Override
    public void a(rb rb22) {
        rb rb22;
        rb22.a("whitelist_enabled", false);
        rb22.a("whitelist_count", 0);
        if (this.v != null) {
            rb22.a("players_current", this.H());
            rb22.a("players_max", this.I());
            rb22.a("players_seen", this.v.q().length);
        }
        rb22.a("uses_auth", this.z);
        rb22.a("gui_state", this.ao() ? "enabled" : "disabled");
        rb22.a("run_time", (MinecraftServer.av() - rb22.g()) / 60L * 1000L);
        rb22.a("avg_tick_ms", (int)(op.a(this.h) * 1.0E-6));
        int n2 = 0;
        if (this.d != null) {
            for (ls ls2 : this.d) {
                if (ls2 == null) continue;
                baa baa2 = ls2.T();
                rb22.a("world[" + n2 + "][dimension]", ls2.s.p().a());
                rb22.a("world[" + n2 + "][mode]", (Object)baa2.q());
                rb22.a("world[" + n2 + "][difficulty]", (Object)ls2.ae());
                rb22.a("world[" + n2 + "][hardcore]", baa2.s());
                rb22.a("world[" + n2 + "][generator_name]", baa2.t().a());
                rb22.a("world[" + n2 + "][generator_version]", baa2.t().d());
                rb22.a("world[" + n2 + "][height]", this.F);
                rb22.a("world[" + n2 + "][chunks_loaded]", ls2.r().g());
                ++n2;
            }
        }
        rb22.a("worlds", n2);
    }

    @Override
    public void b(rb rb2) {
        rb2.b("singleplayer", this.R());
        rb2.b("server_brand", this.getServerModName());
        rb2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        rb2.b("dedicated", this.aa());
    }

    @Override
    public boolean Z() {
        return true;
    }

    public abstract boolean aa();

    public boolean ab() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean ac() {
        return this.A;
    }

    public void e(boolean bl2) {
        this.A = bl2;
    }

    public boolean ad() {
        return this.B;
    }

    public abstract boolean ae();

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean af() {
        return this.C;
    }

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean ag() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean ah();

    public String ai() {
        return this.E;
    }

    public void l(String string) {
        this.E = string;
    }

    public int aj() {
        return this.F;
    }

    public void c(int n2) {
        this.F = n2;
    }

    public boolean ak() {
        return this.x;
    }

    public mp al() {
        return this.v;
    }

    public void a(mp mp2) {
        this.v = mp2;
    }

    public void a(aib aib2) {
        for (ls ls2 : this.d) {
            ls2.T().a(aib2);
        }
    }

    public md am() {
        return this.p;
    }

    public boolean an() {
        return this.P;
    }

    public boolean ao() {
        return false;
    }

    public abstract String a(aib var1, boolean var2);

    public int ap() {
        return this.y;
    }

    public void aq() {
        this.S = true;
    }

    public rb ar() {
        return this.m;
    }

    @Override
    public cm c() {
        return cm.a;
    }

    @Override
    public bcb d() {
        return bcb.a;
    }

    @Override
    public aid e() {
        return this.d[0];
    }

    @Override
    public rw f() {
        return null;
    }

    public boolean a(aid aid2, cm cm2, zs zs2) {
        return false;
    }

    public boolean at() {
        return this.T;
    }

    public Proxy au() {
        return this.e;
    }

    public static long av() {
        return System.currentTimeMillis();
    }

    public int aw() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    @Override
    public ey i_() {
        return new fe(this.h_());
    }

    public boolean ax() {
        return true;
    }

    public MinecraftSessionService ay() {
        return this.V;
    }

    public GameProfileRepository az() {
        return this.W;
    }

    public ml aA() {
        return this.X;
    }

    public kc aB() {
        return this.q;
    }

    public void aC() {
        this.Y = 0L;
    }

    @Nullable
    public rw a(UUID uUID) {
        for (ls ls2 : this.d) {
            if (ls2 == null || (\u2603 = ls2.a(uUID)) == null) continue;
            return \u2603;
        }
        return null;
    }

    @Override
    public boolean z_() {
        return this.d[0].U().b("sendCommandFeedback");
    }

    @Override
    public void a(o.a a2, int n2) {
    }

    @Override
    public MinecraftServer h() {
        return this;
    }

    public int aD() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.aE() && !this.ak()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aE() {
        return Thread.currentThread() == this.Z;
    }

    public int aF() {
        return 256;
    }

    public pd aI() {
        return this.s;
    }

    public int a(@Nullable ls ls2) {
        if (ls2 != null) {
            return ls2.U().c("spawnRadius");
        }
        return 10;
    }
}

