/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements Runnable,
m,
qc,
qx {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private final azk l;
    private final qw m = new qw("server", this, MinecraftServer.av());
    private final File n;
    private final List<ky> o = Lists.newArrayList();
    protected final l b;
    public final oo c = new oo();
    private final ma p;
    private final jz q = new jz();
    private final Random r = new Random();
    private final pb s;
    private int u = -1;
    public lp[] d;
    private mm v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G = 0;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private String N = "";
    private String O = "";
    private boolean P;
    private long Q;
    private String R;
    private boolean S;
    private boolean T;
    private final YggdrasilAuthenticationService U;
    private final MinecraftSessionService V;
    private final GameProfileRepository W;
    private final mi X;
    private long Y = 0L;
    protected final Queue<FutureTask<?>> j = Queues.newArrayDeque();
    private Thread Z;
    private long aa = MinecraftServer.av();
    private boolean ab;

    public MinecraftServer(File file, Proxy proxy, pb pb2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, mi mi2) {
        this.e = proxy;
        this.U = yggdrasilAuthenticationService;
        this.V = minecraftSessionService;
        this.W = gameProfileRepository;
        this.X = mi2;
        this.n = file;
        this.p = new ma(this);
        this.b = this.i();
        this.l = new azd(file, pb2);
        this.s = pb2;
    }

    protected bc i() {
        return new bc(this);
    }

    protected abstract boolean j() throws IOException;

    protected void a(String string) {
        if (this.W().b(string)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.W().a(string, new op(){
                private long b = MinecraftServer.av();

                @Override
                public void a(String string) {
                }

                @Override
                public void b(String string) {
                }

                @Override
                public void a(int n2) {
                    if (MinecraftServer.av() - this.b >= 1000L) {
                        this.b = MinecraftServer.av();
                        k.info("Converting... " + n2 + "%");
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(String string) {
                }
            });
        }
    }

    protected synchronized void b(String string) {
        this.R = string;
    }

    public synchronized String k() {
        return this.R;
    }

    protected void a(String string, String string2, long l22, ahy ahy2, String string3) {
        ahw \u26033;
        this.a(string);
        this.b("menu.loadingLevel");
        this.d = new lp[3];
        this.i = new long[this.d.length][100];
        azi azi2 = this.l.a(string, true);
        this.a(this.S(), azi2);
        azh \u26032 = azi2.d();
        if (\u26032 == null) {
            if (this.V()) {
                \u26033 = lj.a;
            } else {
                long l22;
                \u26033 = new ahw(l22, this.n(), this.m(), this.p(), ahy2);
                \u26033.a(string3);
                if (this.M) {
                    \u26033.a();
                }
            }
            \u26032 = new azh(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new ahw(\u26032);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            \u2603 = 0;
            if (i2 == 1) {
                \u2603 = -1;
            }
            if (i2 == 2) {
                \u2603 = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.V() ? (lp)new lj(this, azi2, \u26032, \u2603, this.c).b() : (lp)new lp(this, azi2, \u26032, \u2603, this.c).b();
                this.d[i2].a(\u26033);
            } else {
                this.d[i2] = (lp)new ll(this, azi2, \u2603, this.d[0], this.c).b();
            }
            this.d[i2].a(new lq(this, this.d[i2]));
            if (this.R()) continue;
            this.d[i2].T().a(this.n());
        }
        this.v.a(this.d);
        this.a(this.o());
        this.l();
    }

    protected void l() {
        int n2 = 16;
        \u2603 = 4;
        \u2603 = 192;
        \u2603 = 625;
        \u2603 = 0;
        this.b("menu.generatingTerrain");
        \u2603 = 0;
        k.info("Preparing start region for level " + \u2603);
        lp \u26032 = this.d[\u2603];
        cj \u26033 = \u26032.R();
        long \u26034 = MinecraftServer.av();
        for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
            for (\u2603 = -192; \u2603 <= 192 && this.w(); \u2603 += 16) {
                long l2 = MinecraftServer.av();
                if (l2 - \u26034 > 1000L) {
                    this.a_("Preparing spawn area", \u2603 * 100 / 625);
                    \u26034 = l2;
                }
                ++\u2603;
                \u26032.r().d(\u26033.p() + \u2603 >> 4, \u26033.r() + \u2603 >> 4);
            }
        }
        this.t();
    }

    protected void a(String string, azi azi2) {
        File file = new File(azi2.b(), "resources.zip");
        if (file.isFile()) {
            this.a_("level://" + string + "/" + "resources.zip", "");
        }
    }

    public abstract boolean m();

    public abstract ahw.a n();

    public abstract qk o();

    public abstract boolean p();

    public abstract int q();

    public abstract boolean r();

    public abstract boolean s();

    protected void a_(String string, int n2) {
        this.f = string;
        this.g = n2;
        k.info(string + ": " + n2 + "%");
    }

    protected void t() {
        this.f = null;
        this.g = 0;
    }

    public void a(boolean bl2) {
        for (lp lp2 : this.d) {
            if (lp2 == null) continue;
            if (!bl2) {
                k.info("Saving chunks for level '" + lp2.T().j() + "'/" + lp2.s.p().b());
            }
            try {
                lp2.a(true, null);
            }
            catch (ahu ahu2) {
                k.warn(ahu2.getMessage());
            }
        }
    }

    public void u() {
        k.info("Stopping server");
        if (this.am() != null) {
            this.am().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            int n2;
            k.info("Saving worlds");
            for (n2 = 0; n2 < this.d.length; ++n2) {
                if (this.d[n2] == null) continue;
                this.d[n2].b = false;
            }
            this.a(false);
            for (n2 = 0; n2 < this.d.length; ++n2) {
                if (this.d[n2] == null) continue;
                this.d[n2].s();
            }
        }
        if (this.m.d()) {
            this.m.e();
        }
    }

    public boolean w() {
        return this.w;
    }

    public void x() {
        this.w = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.j()) {
                this.aa = MinecraftServer.av();
                long l2 = 0L;
                this.q.a(new fa(this.E));
                this.q.a(new jz.c("1.9", 107));
                this.a(this.q);
                while (this.w) {
                    \u2603 = MinecraftServer.av();
                    \u2603 = \u2603 - this.aa;
                    if (\u2603 > 2000L && this.aa - this.Q >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{\u2603, \u2603 / 50L});
                        \u2603 = 2000L;
                        this.Q = this.aa;
                    }
                    if (\u2603 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        \u2603 = 0L;
                    }
                    l2 += \u2603;
                    this.aa = \u2603;
                    if (this.d[0].g()) {
                        this.C();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.C();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.P = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            k.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof e ? this.b(((e)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.A(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(\u26032)) {
                k.error("This crash report has been saved to: " + \u26032.getAbsolutePath());
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.x = true;
                this.u();
            }
            catch (Throwable \u26033) {
                k.error("Exception stopping the server", \u26033);
            }
            finally {
                this.B();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(jz jz2) {
        File file = this.d("server-icon.png");
        if (!file.exists()) {
            file = this.W().b(this.S(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf \u26032 = Base64.encode((ByteBuf)byteBuf);
                jz2.a("data:image/png;base64," + \u26032.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean y() {
        this.ab = this.ab || this.z().isFile();
        return this.ab;
    }

    public File z() {
        return this.W().b(this.S(), "icon.png");
    }

    public File A() {
        return new File(".");
    }

    protected void a(b b2) {
    }

    protected void B() {
    }

    public void C() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.S) {
            this.S = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.D();
        if (l2 - this.Y >= 5000000000L) {
            this.Y = l2;
            this.q.a(new jz.a(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int \u26032 = on.a(this.r, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.v().get(\u26032 + i2).cK();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.q.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - l2;
        this.c.b();
        this.c.a("snooper");
        if (!this.m.d() && this.y > 100) {
            this.m.a();
        }
        if (this.y % 6000 == 0) {
            this.m.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void D() {
        int n2;
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                g.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        for (n2 = 0; n2 < this.d.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.E()) {
                lp lp2 = this.d[n2];
                this.c.a(lp2.T().j());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new hw(lp2.P(), lp2.Q(), lp2.U().b("doDaylightCycle")), lp2.s.p().a());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    lp2.d();
                }
                catch (Throwable \u26032) {
                    b b2 = b.a(\u26032, "Exception ticking world");
                    lp2.a(b2);
                    throw new e(b2);
                }
                try {
                    lp2.k();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    lp2.a(b3);
                    throw new e(b3);
                }
                this.c.b();
                this.c.a("tracker");
                lp2.v().a();
                this.c.b();
                this.c.b();
            }
            this.i[n2][this.y % 100] = System.nanoTime() - l2;
        }
        this.c.c("connection");
        this.am().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (n2 = 0; n2 < this.o.size(); ++n2) {
            this.o.get(n2).c();
        }
        this.c.b();
    }

    public boolean E() {
        return true;
    }

    public void F() {
        this.Z = new Thread((Runnable)this, "Server thread");
        this.Z.start();
    }

    public File d(String string) {
        return new File(this.A(), string);
    }

    public void f(String string) {
        k.warn(string);
    }

    public lp a(int n2) {
        if (n2 == -1) {
            return this.d[1];
        }
        if (n2 == 1) {
            return this.d[2];
        }
        return this.d[0];
    }

    public String G() {
        return "1.9";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new Callable<String>(){

            public String a() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        });
        if (this.v != null) {
            b2.g().a("Player Count", new Callable<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        return b2;
    }

    public List<String> a(m m2, String string2, cj cj2, boolean bl22) {
        boolean bl22;
        String string2;
        ArrayList arrayList = Lists.newArrayList();
        boolean \u26032 = string2.startsWith("/");
        if (\u26032) {
            string2 = string2.substring(1);
        }
        if (\u26032 || bl22) {
            \u2603 = !string2.contains(" ");
            List<String> list = this.b.a(m2, string2, cj2);
            if (!list.isEmpty()) {
                for (String string3 : list) {
                    if (\u2603) {
                        arrayList.add("/" + string3);
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
        String[] \u26033 = string2.split(" ", -1);
        \u2603 = \u26033[\u26033.length - 1];
        for (String string4 : this.v.f()) {
            if (!i.a(\u2603, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public boolean M() {
        return this.n != null;
    }

    @Override
    public String h_() {
        return "Server";
    }

    @Override
    public void a(eu eu2) {
        k.info(eu2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public l N() {
        return this.b;
    }

    public KeyPair O() {
        return this.H;
    }

    public String Q() {
        return this.I;
    }

    public void i(String string) {
        this.I = string;
    }

    public boolean R() {
        return this.I != null;
    }

    public String S() {
        return this.J;
    }

    public void j(String string) {
        this.J = string;
    }

    public void k(String string) {
        this.K = string;
    }

    public String T() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(qk qk2) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            lp lp2 = this.d[i2];
            if (lp2 == null) continue;
            if (lp2.T().s()) {
                lp2.T().a(qk.d);
                lp2.a(true, true);
                continue;
            }
            if (this.R()) {
                lp2.T().a(qk2);
                lp2.a(lp2.ae() != qk.a, true);
                continue;
            }
            lp2.T().a(qk2);
            lp2.a(this.U(), this.A);
        }
    }

    protected boolean U() {
        return true;
    }

    public boolean V() {
        return this.L;
    }

    public void b(boolean bl2) {
        this.L = bl2;
    }

    public void c(boolean bl2) {
        this.M = bl2;
    }

    public azk W() {
        return this.l;
    }

    public String X() {
        return this.N;
    }

    public String Y() {
        return this.O;
    }

    public void a_(String string, String string2) {
        this.N = string;
        this.O = string2;
    }

    @Override
    public void a(qw qw2) {
        qw2.a("whitelist_enabled", false);
        qw2.a("whitelist_count", 0);
        if (this.v != null) {
            qw2.a("players_current", this.H());
            qw2.a("players_max", this.I());
            qw2.a("players_seen", this.v.q().length);
        }
        qw2.a("uses_auth", this.z);
        qw2.a("gui_state", this.ao() ? "enabled" : "disabled");
        qw2.a("run_time", (MinecraftServer.av() - qw2.g()) / 60L * 1000L);
        qw2.a("avg_tick_ms", (int)(on.a(this.h) * 1.0E-6));
        int n2 = 0;
        if (this.d != null) {
            for (\u2603 = 0; \u2603 < this.d.length; ++\u2603) {
                if (this.d[\u2603] == null) continue;
                lp lp2 = this.d[\u2603];
                azh \u26032 = lp2.T();
                qw2.a("world[" + n2 + "][dimension]", lp2.s.p().a());
                qw2.a("world[" + n2 + "][mode]", (Object)\u26032.q());
                qw2.a("world[" + n2 + "][difficulty]", (Object)lp2.ae());
                qw2.a("world[" + n2 + "][hardcore]", \u26032.s());
                qw2.a("world[" + n2 + "][generator_name]", \u26032.t().a());
                qw2.a("world[" + n2 + "][generator_version]", \u26032.t().d());
                qw2.a("world[" + n2 + "][height]", this.F);
                qw2.a("world[" + n2 + "][chunks_loaded]", lp2.r().g());
                ++n2;
            }
        }
        qw2.a("worlds", n2);
    }

    @Override
    public void b(qw qw2) {
        qw2.b("singleplayer", this.R());
        qw2.b("server_brand", this.getServerModName());
        qw2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        qw2.b("dedicated", this.aa());
    }

    @Override
    public boolean Z() {
        return true;
    }

    public abstract boolean aa();

    public boolean ab() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean ac() {
        return this.A;
    }

    public void e(boolean bl2) {
        this.A = bl2;
    }

    public boolean ad() {
        return this.B;
    }

    public abstract boolean ae();

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean af() {
        return this.C;
    }

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean ag() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean ah();

    public String ai() {
        return this.E;
    }

    public void l(String string) {
        this.E = string;
    }

    public int aj() {
        return this.F;
    }

    public void c(int n2) {
        this.F = n2;
    }

    public boolean ak() {
        return this.x;
    }

    public mm al() {
        return this.v;
    }

    public void a(mm mm2) {
        this.v = mm2;
    }

    public void a(ahw.a a2) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            this.d[i2].T().a(a2);
        }
    }

    public ma am() {
        return this.p;
    }

    public boolean an() {
        return this.P;
    }

    public boolean ao() {
        return false;
    }

    public abstract String a(ahw.a var1, boolean var2);

    public int ap() {
        return this.y;
    }

    public void aq() {
        this.S = true;
    }

    public qw ar() {
        return this.m;
    }

    @Override
    public cj c() {
        return cj.a;
    }

    @Override
    public bbj d() {
        return bbj.a;
    }

    @Override
    public aht e() {
        return this.d[0];
    }

    @Override
    public rr f() {
        return null;
    }

    public boolean a(aht aht2, cj cj2, zj zj2) {
        return false;
    }

    public boolean at() {
        return this.T;
    }

    public Proxy au() {
        return this.e;
    }

    public static long av() {
        return System.currentTimeMillis();
    }

    public int aw() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    @Override
    public eu i_() {
        return new fa(this.h_());
    }

    public boolean ax() {
        return true;
    }

    public MinecraftSessionService ay() {
        return this.V;
    }

    public GameProfileRepository az() {
        return this.W;
    }

    public mi aA() {
        return this.X;
    }

    public jz aB() {
        return this.q;
    }

    public void aC() {
        this.Y = 0L;
    }

    public rr a(UUID uUID) {
        for (lp lp2 : this.d) {
            if (lp2 == null || (\u2603 = lp2.a(uUID)) == null) continue;
            return \u2603;
        }
        return null;
    }

    @Override
    public boolean z_() {
        return this.d[0].U().b("sendCommandFeedback");
    }

    @Override
    public void a(n.a a2, int n2) {
    }

    @Override
    public MinecraftServer h() {
        return this;
    }

    public int aD() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.aE() && !this.ak()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aE() {
        return Thread.currentThread() == this.Z;
    }

    public int aF() {
        return 256;
    }

    public pb aI() {
        return this.s;
    }

    public int a(lp lp2) {
        if (lp2 != null) {
            return lp2.U().c("spawnRadius");
        }
        return 10;
    }
}

