/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.gui.screens.ScreenWithCallback;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsClickableScrolledSelectionList;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.Tezzelator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class RealmsWorldTemplateScreen
extends RealmsScreen {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String PLUS_ICON_LOCATION = "realms:textures/gui/realms/plus_icon.png";
    private final ScreenWithCallback<WorldTemplate> lastScreen;
    private WorldTemplate selectedWorldTemplate;
    private List<WorldTemplate> templates = Collections.emptyList();
    private WorldTemplateSelectionList worldTemplateSelectionList;
    private int selectedTemplate = -1;
    private static final int BACK_BUTTON_ID = 0;
    private static final int SELECT_BUTTON_ID = 1;
    private RealmsButton selectButton;
    private String toolTip = null;
    private boolean isMiniGame;

    public RealmsWorldTemplateScreen(ScreenWithCallback<WorldTemplate> configureWorldScreen, WorldTemplate selectedWorldTemplate, boolean isMiniGame) {
        this.lastScreen = configureWorldScreen;
        this.selectedWorldTemplate = selectedWorldTemplate;
        this.isMiniGame = isMiniGame;
    }

    public void mouseEvent() {
        super.mouseEvent();
        this.worldTemplateSelectionList.mouseEvent();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.worldTemplateSelectionList = new WorldTemplateSelectionList();
        final boolean isMiniGame = this.isMiniGame;
        new Thread("Realms-minigame-fetcher"){

            @Override
            public void run() {
                RealmsClient client = RealmsClient.createRealmsClient();
                try {
                    if (isMiniGame) {
                        RealmsWorldTemplateScreen.this.templates = client.fetchMinigames().templates;
                    } else {
                        RealmsWorldTemplateScreen.this.templates = client.fetchWorldTemplates().templates;
                    }
                }
                catch (RealmsServiceException e) {
                    LOGGER.error("Couldn't fetch templates");
                }
            }
        }.start();
        this.postInit();
    }

    private void postInit() {
        this.buttonsAdd(RealmsWorldTemplateScreen.newButton((int)0, (int)(this.width() / 2 + 6), (int)(this.height() - 52), (int)153, (int)20, (String)RealmsWorldTemplateScreen.getLocalizedString((String)"gui.cancel")));
        this.selectButton = RealmsWorldTemplateScreen.newButton((int)1, (int)(this.width() / 2 - 154), (int)(this.height() - 52), (int)153, (int)20, (String)RealmsWorldTemplateScreen.getLocalizedString((String)"mco.template.button.select"));
        this.buttonsAdd(this.selectButton);
    }

    public void tick() {
        super.tick();
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 1) {
            this.selectTemplate();
        } else if (button.id() == 0) {
            this.backButtonClicked();
        }
    }

    public void keyPressed(char eventCharacter, int eventKey) {
        if (eventKey == 1) {
            this.backButtonClicked();
        }
    }

    private void backButtonClicked() {
        this.lastScreen.callback(null);
        Realms.setScreen(this.lastScreen);
    }

    private void selectTemplate() {
        if (this.selectedTemplate >= 0 && this.selectedTemplate < this.templates.size()) {
            this.lastScreen.callback(this.templates.get(this.selectedTemplate));
            Realms.setScreen(this.lastScreen);
        }
    }

    public void render(int xm, int ym, float a) {
        this.toolTip = null;
        this.renderBackground();
        this.worldTemplateSelectionList.render(xm, ym, a);
        String title = "";
        title = this.isMiniGame ? RealmsWorldTemplateScreen.getLocalizedString((String)"mco.template.title.minigame") : RealmsWorldTemplateScreen.getLocalizedString((String)"mco.template.title");
        this.drawCenteredString(title, this.width() / 2, 20, 0xFFFFFF);
        super.render(xm, ym, a);
        if (this.toolTip != null) {
            this.renderMousehoverTooltip(this.toolTip, xm, ym);
        }
    }

    private void browseTo(String uri) {
        try {
            URI link = new URI(uri);
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object o = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(o, link);
        }
        catch (Throwable e) {
            LOGGER.error("Couldn't open link");
        }
    }

    protected void renderMousehoverTooltip(String msg, int x, int y) {
        if (msg == null) {
            return;
        }
        int rx = x + 12;
        int ry = y - 12;
        int width = this.fontWidth(msg);
        this.fillGradient(rx - 3, ry - 3, rx + width + 3, ry + 8 + 3, -1073741824, -1073741824);
        this.fontDrawShadow(msg, rx, ry, -1);
    }

    private class WorldTemplateSelectionList
    extends RealmsClickableScrolledSelectionList {
        public WorldTemplateSelectionList() {
            super(RealmsWorldTemplateScreen.this.width(), RealmsWorldTemplateScreen.this.height(), 32, RealmsWorldTemplateScreen.this.height() - 64, 36);
        }

        public int getItemCount() {
            return RealmsWorldTemplateScreen.this.templates.size() + 1;
        }

        public void selectItem(int item, boolean doubleClick, int xMouse, int yMouse) {
            if (item >= RealmsWorldTemplateScreen.this.templates.size()) {
                return;
            }
            RealmsWorldTemplateScreen.this.selectedTemplate = item;
            RealmsWorldTemplateScreen.this.selectedWorldTemplate = null;
        }

        public void customMouseEvent(int y0, int y1, int headerHeight, float yo, int itemHeight) {
            if (Mouse.isButtonDown((int)0) && this.ym() >= y0 && this.ym() <= y1) {
                int x0 = this.width() / 2 - 92;
                int x1 = this.width();
                int clickSlotPos = this.ym() - y0 - headerHeight + (int)yo - 4;
                int slot = clickSlotPos / itemHeight;
                if (this.xm() >= x0 && this.xm() <= x1 && slot >= 0 && clickSlotPos >= 0 && slot < this.getItemCount()) {
                    this.itemClicked(clickSlotPos, slot, this.xm(), this.ym(), this.width());
                }
            }
        }

        public boolean isSelectedItem(int item) {
            if (RealmsWorldTemplateScreen.this.templates.size() == 0) {
                return false;
            }
            if (item >= RealmsWorldTemplateScreen.this.templates.size()) {
                return false;
            }
            if (RealmsWorldTemplateScreen.this.selectedWorldTemplate != null) {
                boolean same = ((RealmsWorldTemplateScreen)RealmsWorldTemplateScreen.this).selectedWorldTemplate.name.equals(((WorldTemplate)((RealmsWorldTemplateScreen)RealmsWorldTemplateScreen.this).templates.get((int)item)).name);
                if (same) {
                    RealmsWorldTemplateScreen.this.selectedTemplate = item;
                }
                return same;
            }
            return item == RealmsWorldTemplateScreen.this.selectedTemplate;
        }

        public void itemClicked(int clickSlotPos, int slot, int xm, int ym, int width) {
            int dx = this.getScrollbarPosition() - 240 + RealmsWorldTemplateScreen.this.fontWidth(((WorldTemplate)((RealmsWorldTemplateScreen)RealmsWorldTemplateScreen.this).templates.get((int)slot)).author) + 12;
            int dy = clickSlotPos + 30 - this.getScroll();
            if (xm >= dx && xm <= dx + 9 && ym >= dy && ym <= dy + 9 && !((WorldTemplate)((RealmsWorldTemplateScreen)RealmsWorldTemplateScreen.this).templates.get((int)slot)).link.equals("")) {
                RealmsWorldTemplateScreen.this.browseTo(((WorldTemplate)((RealmsWorldTemplateScreen)RealmsWorldTemplateScreen.this).templates.get((int)slot)).link);
            }
        }

        public int getMaxPosition() {
            return this.getItemCount() * 36;
        }

        public void renderBackground() {
            RealmsWorldTemplateScreen.this.renderBackground();
        }

        public void renderItem(int i, int x, int y, int h, int mouseX, int mouseY) {
            if (i < RealmsWorldTemplateScreen.this.templates.size()) {
                this.renderWorldTemplateItem(i, x, y, h);
            }
        }

        public void renderSelected(int width, int y, int h, Tezzelator t) {
            int x0 = this.getScrollbarPosition() - 240;
            int x1 = this.getScrollbarPosition() - 10;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)3553);
            t.begin();
            t.color(0x808080);
            t.vertexUV((double)x0, (double)(y + h + 2), 0.0, 0.0, 1.0);
            t.vertexUV((double)x1, (double)(y + h + 2), 0.0, 1.0, 1.0);
            t.vertexUV((double)x1, (double)(y - 2), 0.0, 1.0, 0.0);
            t.vertexUV((double)x0, (double)(y - 2), 0.0, 0.0, 0.0);
            t.color(0);
            t.vertexUV((double)(x0 + 1), (double)(y + h + 1), 0.0, 0.0, 1.0);
            t.vertexUV((double)(x1 - 1), (double)(y + h + 1), 0.0, 1.0, 1.0);
            t.vertexUV((double)(x1 - 1), (double)(y - 1), 0.0, 1.0, 0.0);
            t.vertexUV((double)(x0 + 1), (double)(y - 1), 0.0, 0.0, 0.0);
            t.end();
            GL11.glEnable((int)3553);
        }

        private void renderWorldTemplateItem(int i, int x, int y, int h) {
            WorldTemplate worldTemplate = (WorldTemplate)RealmsWorldTemplateScreen.this.templates.get(i);
            RealmsWorldTemplateScreen.this.drawString(worldTemplate.name, x + 2, y + 1, 0xFFFFFF);
            RealmsWorldTemplateScreen.this.drawString(worldTemplate.author, x + 2, y + 12, 0x6C6C6C);
            RealmsWorldTemplateScreen.this.drawString(worldTemplate.version, x + 2 + 207 - RealmsWorldTemplateScreen.this.fontWidth(worldTemplate.version), y + 1, 0x4C4C4C);
            int dx = this.getScrollbarPosition() - 240 + RealmsWorldTemplateScreen.this.fontWidth(worldTemplate.author) + 12;
            int dy = 12;
            if (!worldTemplate.link.equals("")) {
                this.drawInfo(dx, y + dy, this.xm(), this.ym());
            }
        }

        private void drawInfo(int x, int y, int xm, int ym) {
            RealmsScreen.bind((String)RealmsWorldTemplateScreen.PLUS_ICON_LOCATION);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)0.5f);
            RealmsScreen.blit((int)(x * 2), (int)(y * 2), (float)0.0f, (float)0.0f, (int)15, (int)15, (float)15.0f, (float)15.0f);
            GL11.glPopMatrix();
            if (xm >= x && xm <= x + 9 && ym >= y && ym <= y + 9 && ym < RealmsWorldTemplateScreen.this.height() - 15 && ym > 32) {
                RealmsWorldTemplateScreen.this.toolTip = RealmsScreen.getLocalizedString((String)"mco.template.info.tooltip");
            }
        }
    }
}

