/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import java.net.URI;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;

public class RealmsParentalConsentScreen
extends RealmsScreen {
    private final RealmsScreen nextScreen;
    private static final int OK_BUTTON_ID = 10;
    private static final int BACK_BUTTON_ID = 5;
    private String line1;
    private String line2;

    public RealmsParentalConsentScreen(RealmsScreen nextScreen) {
        this.nextScreen = nextScreen;
    }

    public void init() {
        this.buttonsClear();
        this.line1 = "You need parental consent to access Minecraft Realms.";
        this.line2 = "This is not currently set up on your account.";
        this.buttonsAdd(RealmsParentalConsentScreen.newButton((int)10, (int)(this.width() / 2 - 100), (int)(this.height() - 65), (int)200, (int)20, (String)"Set up parental consent"));
        this.buttonsAdd(RealmsParentalConsentScreen.newButton((int)5, (int)(this.width() / 2 - 100), (int)(this.height() - 42), (int)200, (int)20, (String)"Back"));
    }

    public void tick() {
        super.tick();
    }

    public void buttonClicked(RealmsButton button) {
        if (button.id() == 10) {
            this.browseTo("https://accounts.mojang.com/account/requestConsent/" + Realms.getSessionId().split(":", 3)[2]);
        } else if (button.id() == 5) {
            Realms.setScreen((RealmsScreen)this.nextScreen);
        }
    }

    private void browseTo(String uri) {
        try {
            URI link = new URI(uri);
            Class<?> desktopClass = Class.forName("java.awt.Desktop");
            Object o = desktopClass.getMethod("getDesktop", new Class[0]).invoke(null, new Object[0]);
            desktopClass.getMethod("browse", URI.class).invoke(o, link);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(this.line1, this.width() / 2, 80, 0xFFFFFF);
        this.drawCenteredString(this.line2, this.width() / 2, 100, 0xFFFFFF);
        super.render(xm, ym, a);
    }
}

