/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.gui.ErrorCallback;
import com.mojang.realmsclient.gui.LongRunningTask;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;

public class LongRunningMcoTaskScreen
extends RealmsScreen
implements ErrorCallback {
    private final int BUTTON_CANCEL_ID = 666;
    private final int BUTTON_BACK_ID = 667;
    private final RealmsScreen lastScreen;
    private final LongRunningTask taskThread;
    private volatile String title = "";
    private volatile boolean error;
    private volatile String errorMessage;
    private volatile boolean aborted;
    private int animTicks;
    private LongRunningTask task;
    private int buttonLength = 212;
    public static final String[] symbols = new String[]{"\u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583", "_ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584", "_ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585", "_ _ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586", "_ _ _ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587", "_ _ _ _ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588", "_ _ _ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587", "_ _ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586", "_ _ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585", "_ \u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584", "\u2583 \u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583", "\u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _", "\u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _", "\u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _ _", "\u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _ _ _", "\u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _ _ _ _", "\u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _ _ _", "\u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _ _", "\u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _ _", "\u2584 \u2585 \u2586 \u2587 \u2588 \u2587 \u2586 \u2585 \u2584 \u2583 _"};

    public LongRunningMcoTaskScreen(RealmsScreen lastScreen, LongRunningTask task) {
        this.lastScreen = lastScreen;
        this.task = task;
        task.setScreen(this);
        this.taskThread = task;
    }

    public void start() {
        new Thread((Runnable)this.taskThread, "Realms-long-running-task").start();
    }

    public void tick() {
        super.tick();
        ++this.animTicks;
        this.task.tick();
    }

    public void keyPressed(char eventCharacter, int eventKey) {
        if (eventKey == 1) {
            this.cancelOrBackButtonClicked();
        }
    }

    public void init() {
        this.task.init();
        this.buttonsAdd(LongRunningMcoTaskScreen.newButton((int)666, (int)(this.width() / 2 - this.buttonLength / 2), (int)(this.height() / 2 + 50), (int)this.buttonLength, (int)20, (String)LongRunningMcoTaskScreen.getLocalizedString((String)"gui.cancel")));
    }

    public void buttonClicked(RealmsButton button) {
        if (button.id() == 666 || button.id() == 667) {
            this.cancelOrBackButtonClicked();
        }
        this.task.buttonClicked(button);
    }

    private void cancelOrBackButtonClicked() {
        this.aborted = true;
        this.task.abortTask();
        Realms.setScreen((RealmsScreen)this.lastScreen);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(this.title, this.width() / 2, this.height() / 2 - 50, 0xFFFFFF);
        this.drawCenteredString("", this.width() / 2, this.height() / 2 - 10, 0xFFFFFF);
        if (!this.error) {
            this.drawCenteredString(symbols[this.animTicks % symbols.length], this.width() / 2, this.height() / 2 + 15, 0x808080);
        }
        if (this.error) {
            this.drawCenteredString(this.errorMessage, this.width() / 2, this.height() / 2 + 15, 0xFF0000);
        }
        super.render(xm, ym, a);
    }

    @Override
    public void error(String errorMessage) {
        this.error = true;
        this.errorMessage = errorMessage;
        this.buttonsClear();
        this.buttonsAdd(LongRunningMcoTaskScreen.newButton((int)667, (int)(this.width() / 2 - this.buttonLength / 2), (int)(this.height() / 4 + 120 + 12), (String)LongRunningMcoTaskScreen.getLocalizedString((String)"gui.back")));
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean aborted() {
        return this.aborted;
    }
}

