/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements ae,
Runnable,
vn,
wd {
    private static final Logger j = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private static MinecraftServer k;
    private final bra l;
    private final wb m = new wb("server", this, MinecraftServer.ax());
    private final File n;
    private final List o = Lists.newArrayList();
    private final ad p;
    public final uw b = new uw();
    private final rc q;
    private final np r = new np();
    private final Random s = new Random();
    private int u = -1;
    public qt[] c;
    private sn v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy d;
    public String e;
    public int f;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G = 0;
    public final long[] g = new long[100];
    public long[][] h;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private long X = 0L;
    private final GameProfileRepository Y;
    private final ry Z;
    protected final Queue i = Queues.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.ax();

    public MinecraftServer(Proxy proxy, File file) {
        this.d = proxy;
        k = this;
        this.n = null;
        this.q = null;
        this.Z = new ry(this, file);
        this.p = null;
        this.l = null;
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    public MinecraftServer(File file, Proxy proxy, File file2) {
        this.d = proxy;
        k = this;
        this.n = file;
        this.q = new rc(this);
        this.Z = new ry(this, file2);
        this.p = this.h();
        this.l = new bqj(file);
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    protected cl h() {
        return new cl();
    }

    protected abstract boolean i();

    protected void a(String string) {
        if (this.X().b(string)) {
            j.info("Converting map!");
            this.b("menu.convertingLevel");
            this.X().a(string, new pd(this));
        }
    }

    protected synchronized void b(String string) {
        this.S = string;
    }

    public synchronized String j() {
        return this.S;
    }

    protected void a(String string, String string2, long l2, are are2, String string3) {
        arb arb2;
        this.a(string);
        this.b("menu.loadingLevel");
        this.c = new qt[3];
        this.h = new long[this.c.length][100];
        bqy bqy2 = this.l.a(string, true);
        this.a(this.T(), bqy2);
        bqo bqo2 = bqy2.d();
        if (bqo2 == null) {
            if (this.W()) {
                arb2 = qj.a;
            } else {
                arb2 = new arb(l2, this.m(), this.l(), this.o(), are2);
                arb2.a(string3);
                if (this.M) {
                    arb2.a();
                }
            }
            bqo2 = new bqo(arb2, string2);
        } else {
            bqo2.a(string2);
            arb2 = new arb(bqo2);
        }
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            int n = 0;
            if (i2 == 1) {
                n = -1;
            }
            if (i2 == 2) {
                n = 1;
            }
            if (i2 == 0) {
                this.c[i2] = this.W() ? (qt)new qj(this, bqy2, bqo2, n, this.b).b() : (qt)new qt(this, bqy2, bqo2, n, this.b).b();
                this.c[i2].a(arb2);
            } else {
                this.c[i2] = (qt)new ql(this, bqy2, n, this.c[0], this.b).b();
            }
            this.c[i2].a(new qp(this, this.c[i2]));
            if (this.S()) continue;
            this.c[i2].P().a(this.m());
        }
        this.v.a(this.c);
        this.a(this.n());
        this.k();
    }

    protected void k() {
        int n = 16;
        int n2 = 4;
        int n3 = 192;
        int n4 = 625;
        int n5 = 0;
        this.b("menu.generatingTerrain");
        int n6 = 0;
        j.info("Preparing start region for level " + n6);
        qt qt2 = this.c[n6];
        dt dt2 = qt2.M();
        long l2 = MinecraftServer.ax();
        for (int i2 = -192; i2 <= 192 && this.t(); i2 += 16) {
            for (int i3 = -192; i3 <= 192 && this.t(); i3 += 16) {
                long l3 = MinecraftServer.ax();
                if (l3 - l2 > 1000L) {
                    this.a_("Preparing spawn area", n5 * 100 / 625);
                    l2 = l3;
                }
                ++n5;
                qt2.b.c(dt2.n() + i2 >> 4, dt2.p() + i3 >> 4);
            }
        }
        this.q();
    }

    protected void a(String string, bqy bqy2) {
        File file = new File(bqy2.b(), "resources.zip");
        if (file.isFile()) {
            this.a_("level://" + string + "/" + file.getName(), "");
        }
    }

    public abstract boolean l();

    public abstract arc m();

    public abstract vt n();

    public abstract boolean o();

    public abstract int p();

    protected void a_(String string, int n) {
        this.e = string;
        this.f = n;
        j.info(string + ": " + n + "%");
    }

    protected void q() {
        this.e = null;
        this.f = 0;
    }

    protected void a(boolean bl2) {
        if (this.N) {
            return;
        }
        for (qt qt2 : this.c) {
            if (qt2 == null) continue;
            if (!bl2) {
                j.info("Saving chunks for level '" + qt2.P().k() + "'/" + qt2.t.k());
            }
            try {
                qt2.a(true, null);
            }
            catch (aqz aqz2) {
                j.warn(aqz2.getMessage());
            }
        }
    }

    public void r() {
        if (this.N) {
            return;
        }
        j.info("Stopping server");
        if (this.ao() != null) {
            this.ao().b();
        }
        if (this.v != null) {
            j.info("Saving players");
            this.v.k();
            this.v.v();
        }
        if (this.c != null) {
            j.info("Saving worlds");
            this.a(false);
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                qt qt2 = this.c[i2];
                qt2.o();
            }
        }
        if (this.m.d()) {
            this.m.e();
        }
    }

    public boolean t() {
        return this.w;
    }

    public void u() {
        this.w = false;
    }

    protected void v() {
        k = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.i()) {
                this.ab = MinecraftServer.ax();
                long l2 = 0L;
                this.r.a(new hy(this.E));
                this.r.a(new nt("1.8", 47));
                this.a(this.r);
                while (this.w) {
                    long l3 = MinecraftServer.ax();
                    long l4 = l3 - this.ab;
                    if (l4 > 2000L && this.ab - this.R >= 15000L) {
                        j.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{l4, l4 / 50L});
                        l4 = 2000L;
                        this.R = this.ab;
                    }
                    if (l4 < 0L) {
                        j.warn("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    this.ab = l3;
                    if (this.c[0].f()) {
                        this.y();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.y();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.Q = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            j.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof u ? this.b(((u)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File file = new File(new File(this.w(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(file)) {
                j.error("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                j.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.r();
                this.x = true;
            }
            catch (Throwable throwable) {
                j.error("Exception stopping the server", throwable);
            }
            finally {
                this.x();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(np np2) {
        File file = this.d("server-icon.png");
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf byteBuf2 = Base64.encode((ByteBuf)byteBuf);
                np2.a("data:image/png;base64," + byteBuf2.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                j.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File w() {
        return new File(".");
    }

    protected void a(b b2) {
    }

    protected void x() {
    }

    public void y() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.b.a = true;
            this.b.a();
        }
        this.b.a("root");
        this.z();
        if (l2 - this.X >= 5000000000L) {
            this.X = l2;
            this.r.a(new nq(this.H(), this.G()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.G(), 12)];
            int n = uv.a(this.s, 0, this.G() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = ((qw)this.v.e.get(n + i2)).cc();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.r.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.b.a("save");
            this.v.k();
            this.a(true);
            this.b.b();
        }
        this.b.a("tallying");
        this.g[this.y % 100] = System.nanoTime() - l2;
        this.b.b();
        this.b.a("snooper");
        if (!this.m.d() && this.y > 100) {
            this.m.a();
        }
        if (this.y % 6000 == 0) {
            this.m.b();
        }
        this.b.b();
        this.b.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void z() {
        int n;
        this.b.a("jobs");
        Queue queue = this.i;
        synchronized (queue) {
            while (!this.i.isEmpty()) {
                try {
                    ((FutureTask)this.i.poll()).run();
                }
                catch (Throwable throwable) {
                    j.fatal((Object)throwable);
                }
            }
        }
        this.b.c("levels");
        for (n = 0; n < this.c.length; ++n) {
            long l2 = System.nanoTime();
            if (n == 0 || this.A()) {
                qt qt2 = this.c[n];
                this.b.a(qt2.P().k());
                if (this.y % 20 == 0) {
                    this.b.a("timeSync");
                    this.v.a(new li(qt2.K(), qt2.L(), qt2.Q().b("doDaylightCycle")), qt2.t.q());
                    this.b.b();
                }
                this.b.a("tick");
                try {
                    qt2.c();
                }
                catch (Throwable throwable) {
                    b b2 = b.a(throwable, "Exception ticking world");
                    qt2.a(b2);
                    throw new u(b2);
                }
                try {
                    qt2.i();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    qt2.a(b3);
                    throw new u(b3);
                }
                this.b.b();
                this.b.a("tracker");
                qt2.s().a();
                this.b.b();
                this.b.b();
            }
            this.h[n][this.y % 100] = System.nanoTime() - l2;
        }
        this.b.c("connection");
        this.ao().c();
        this.b.c("players");
        this.v.e();
        this.b.c("tickables");
        for (n = 0; n < this.o.size(); ++n) {
            ((pm)this.o.get(n)).c();
        }
        this.b.b();
    }

    public boolean A() {
        return true;
    }

    public void B() {
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String string) {
        return new File(this.w(), string);
    }

    public void f(String string) {
        j.warn(string);
    }

    public qt a(int n) {
        if (n == -1) {
            return this.c[1];
        }
        if (n == 1) {
            return this.c[2];
        }
        return this.c[0];
    }

    public String F() {
        return "1.8";
    }

    public int G() {
        return this.v.p();
    }

    public int H() {
        return this.v.q();
    }

    public String[] I() {
        return this.v.g();
    }

    public GameProfile[] J() {
        return this.v.h();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new pf(this));
        if (this.v != null) {
            b2.g().a("Player Count", new pg(this));
        }
        return b2;
    }

    public List a(ae ae2, String string, dt dt2) {
        ArrayList arrayList = Lists.newArrayList();
        if (string.startsWith("/")) {
            boolean bl2 = !(string = string.substring(1)).contains(" ");
            List list = this.p.a(ae2, string, dt2);
            if (list != null) {
                for (String string2 : list) {
                    if (bl2) {
                        arrayList.add("/" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        String[] stringArray = string.split(" ", -1);
        String string3 = stringArray[stringArray.length - 1];
        for (String string4 : this.v.g()) {
            if (!z.a(string3, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer M() {
        return k;
    }

    public boolean N() {
        return this.n != null;
    }

    @Override
    public String d_() {
        return "Server";
    }

    @Override
    public void a(ho ho2) {
        j.info(ho2.c());
    }

    @Override
    public boolean a(int n, String string) {
        return true;
    }

    public ad O() {
        return this.p;
    }

    public KeyPair P() {
        return this.H;
    }

    public String R() {
        return this.I;
    }

    public void j(String string) {
        this.I = string;
    }

    public boolean S() {
        return this.I != null;
    }

    public String T() {
        return this.J;
    }

    public void k(String string) {
        this.J = string;
    }

    public void l(String string) {
        this.K = string;
    }

    public String U() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(vt vt2) {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            qt qt2 = this.c[i2];
            if (qt2 == null) continue;
            if (qt2.P().t()) {
                qt2.P().a(vt.d);
                qt2.a(true, true);
                continue;
            }
            if (this.S()) {
                qt2.P().a(vt2);
                qt2.a(qt2.aa() != vt.a, true);
                continue;
            }
            qt2.P().a(vt2);
            qt2.a(this.V(), this.A);
        }
    }

    protected boolean V() {
        return true;
    }

    public boolean W() {
        return this.L;
    }

    public void b(boolean bl2) {
        this.L = bl2;
    }

    public void c(boolean bl2) {
        this.M = bl2;
    }

    public bra X() {
        return this.l;
    }

    public void Z() {
        this.N = true;
        this.X().d();
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            qt qt2 = this.c[i2];
            if (qt2 == null) continue;
            qt2.o();
        }
        this.X().e(this.c[0].O().g());
        this.u();
    }

    public String aa() {
        return this.O;
    }

    public String ab() {
        return this.P;
    }

    public void a_(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(wb wb2) {
        wb2.a("whitelist_enabled", false);
        wb2.a("whitelist_count", 0);
        if (this.v != null) {
            wb2.a("players_current", this.G());
            wb2.a("players_max", this.H());
            wb2.a("players_seen", this.v.r().length);
        }
        wb2.a("uses_auth", this.z);
        wb2.a("gui_state", this.aq() ? "enabled" : "disabled");
        wb2.a("run_time", (MinecraftServer.ax() - wb2.g()) / 60L * 1000L);
        wb2.a("avg_tick_ms", (int)(uv.a(this.g) * 1.0E-6));
        int n = 0;
        if (this.c != null) {
            for (int i2 = 0; i2 < this.c.length; ++i2) {
                if (this.c[i2] == null) continue;
                qt qt2 = this.c[i2];
                bqo bqo2 = qt2.P();
                wb2.a("world[" + n + "][dimension]", qt2.t.q());
                wb2.a("world[" + n + "][mode]", (Object)bqo2.r());
                wb2.a("world[" + n + "][difficulty]", (Object)qt2.aa());
                wb2.a("world[" + n + "][hardcore]", bqo2.t());
                wb2.a("world[" + n + "][generator_name]", bqo2.u().a());
                wb2.a("world[" + n + "][generator_version]", bqo2.u().d());
                wb2.a("world[" + n + "][height]", this.F);
                wb2.a("world[" + n + "][chunks_loaded]", qt2.N().g());
                ++n;
            }
        }
        wb2.a("worlds", n);
    }

    @Override
    public void b(wb wb2) {
        wb2.b("singleplayer", this.S());
        wb2.b("server_brand", this.getServerModName());
        wb2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        wb2.b("dedicated", this.ad());
    }

    @Override
    public boolean ac() {
        return true;
    }

    public abstract boolean ad();

    public boolean ae() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean af() {
        return this.A;
    }

    public void e(boolean bl2) {
        this.A = bl2;
    }

    public boolean ag() {
        return this.B;
    }

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean ah() {
        return this.C;
    }

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean ai() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean aj();

    public String ak() {
        return this.E;
    }

    public void m(String string) {
        this.E = string;
    }

    public int al() {
        return this.F;
    }

    public void c(int n) {
        this.F = n;
    }

    public sn an() {
        return this.v;
    }

    public void a(sn sn2) {
        this.v = sn2;
    }

    public void a(arc arc2) {
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            MinecraftServer.M().c[i2].P().a(arc2);
        }
    }

    public rc ao() {
        return this.q;
    }

    public boolean ap() {
        return this.Q;
    }

    public boolean aq() {
        return false;
    }

    public abstract String a(arc var1, boolean var2);

    public int ar() {
        return this.y;
    }

    public void as() {
        this.T = true;
    }

    public wb at() {
        return this.m;
    }

    @Override
    public dt c() {
        return dt.a;
    }

    @Override
    public brw d() {
        return new brw(0.0, 0.0, 0.0);
    }

    @Override
    public aqu e() {
        return this.c[0];
    }

    @Override
    public wv f() {
        return null;
    }

    public int au() {
        return 16;
    }

    public boolean a(aqu aqu2, dt dt2, ahd ahd2) {
        return false;
    }

    public boolean av() {
        return this.U;
    }

    public Proxy aw() {
        return this.d;
    }

    public static long ax() {
        return System.currentTimeMillis();
    }

    public int ay() {
        return this.G;
    }

    public void d(int n) {
        this.G = n;
    }

    @Override
    public ho e_() {
        return new hy(this.d_());
    }

    public boolean az() {
        return true;
    }

    public MinecraftSessionService aB() {
        return this.W;
    }

    public GameProfileRepository aC() {
        return this.Y;
    }

    public ry aD() {
        return this.Z;
    }

    public np aE() {
        return this.r;
    }

    public void aF() {
        this.X = 0L;
    }

    public wv a(UUID uUID) {
        for (qt qt2 : this.c) {
            wv wv2;
            if (qt2 == null || (wv2 = qt2.a(uUID)) == null) continue;
            return wv2;
        }
        return null;
    }

    @Override
    public boolean t_() {
        return MinecraftServer.M().c[0].Q().b("sendCommandFeedback");
    }

    @Override
    public void a(ag ag2, int n) {
    }

    public int aG() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture a(Callable callable) {
        Validate.notNull((Object)callable);
        if (!this.aH()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create((Callable)callable);
            Queue queue = this.i;
            synchronized (queue) {
                this.i.add(listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aH() {
        return Thread.currentThread() == this.aa;
    }

    public int aI() {
        return 256;
    }

    public static /* synthetic */ Logger aL() {
        return j;
    }

    public static /* synthetic */ sn a(MinecraftServer minecraftServer) {
        return minecraftServer.v;
    }
}

