/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsScreenWithCallback;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.lwjgl.input.Keyboard;

public class RealmsStartMinigameWorldScreen
extends RealmsScreenWithCallback<WorldTemplate> {
    private static final Logger LOGGER = LogManager.getLogger();
    private RealmsConfigureWorldScreen lastScreen;
    private RealmsServer serverData;
    private final int START_BUTTON_ID = 1;
    private final int CANCEL_BUTTON = 2;
    private static int WORLD_TEMPLATE_BUTTON = 3;
    private WorldTemplate selectedWorldTemplate;
    private RealmsButton startButton;

    public RealmsStartMinigameWorldScreen(RealmsConfigureWorldScreen lastScreen, RealmsServer serverData) {
        this.lastScreen = lastScreen;
        this.serverData = serverData;
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.startButton = RealmsStartMinigameWorldScreen.newButton((int)1, (int)(this.width() / 2 - 100), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)RealmsStartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.startButton"));
        this.buttonsAdd(this.startButton);
        this.buttonsAdd(RealmsStartMinigameWorldScreen.newButton((int)2, (int)(this.width() / 2 + 5), (int)(this.height() / 4 + 120 + 12), (int)97, (int)20, (String)RealmsStartMinigameWorldScreen.getLocalizedString((String)"gui.cancel")));
        this.startButton.active(this.selectedWorldTemplate != null);
        if (this.selectedWorldTemplate == null) {
            this.buttonsAdd(RealmsStartMinigameWorldScreen.newButton((int)WORLD_TEMPLATE_BUTTON, (int)(this.width() / 2 - 100), (int)102, (int)200, (int)20, (String)RealmsStartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.noSelection")));
        } else {
            this.buttonsAdd(RealmsStartMinigameWorldScreen.newButton((int)WORLD_TEMPLATE_BUTTON, (int)(this.width() / 2 - 100), (int)102, (int)200, (int)20, (String)this.selectedWorldTemplate.name));
        }
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 28 || eventKey == 156) {
            this.buttonClicked(this.startButton);
        }
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        if (button.id() == 2) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        } else if (button.id() == 1) {
            this.lastScreen.switchMinigame(this.selectedWorldTemplate);
        } else if (button.id() == WORLD_TEMPLATE_BUTTON) {
            Realms.setScreen((RealmsScreen)new RealmsSelectWorldTemplateScreen(this, this.selectedWorldTemplate, true));
        }
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(RealmsStartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.title"), this.width() / 2, 17, 0xFFFFFF);
        this.drawCenteredString(RealmsStartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.info1"), this.width() / 2, 56, 0xFFFFFF);
        this.drawCenteredString(RealmsStartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.info2"), this.width() / 2, 68, 0xFFFFFF);
        this.drawString(RealmsStartMinigameWorldScreen.getLocalizedString((String)"mco.minigame.world.selected"), this.width() / 2 - 100, 90, 0xA0A0A0);
        super.render(xm, ym, a);
    }

    @Override
    void callback(WorldTemplate worldTemplate) {
        this.selectedWorldTemplate = worldTemplate;
        Realms.setScreen((RealmsScreen)this);
    }
}

