/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsResetNormalWorldScreen;
import com.mojang.realmsclient.gui.screens.RealmsScreenWithCallback;
import com.mojang.realmsclient.gui.screens.RealmsSelectFileToUploadScreen;
import com.mojang.realmsclient.gui.screens.RealmsSelectWorldTemplateScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsScreen;
import org.lwjgl.input.Keyboard;

public class RealmsResetWorldScreen
extends RealmsScreenWithCallback<WorldTemplate> {
    private RealmsConfigureWorldScreen lastScreen;
    private RealmsServer serverData;
    private final int BUTTON_CANCEL_ID = 0;
    private static final int BUTTON_WORLD_TEMPLATE_ID = 1;
    private static final int BUTTON_UPLOAD_ID = 2;
    private static final int BUTTON_GENERATE_WORLD_ID = 3;

    public RealmsResetWorldScreen(RealmsConfigureWorldScreen lastScreen, RealmsServer serverData) {
        this.lastScreen = lastScreen;
        this.serverData = serverData;
    }

    public void tick() {
        super.tick();
    }

    public void init() {
        Keyboard.enableRepeatEvents((boolean)true);
        this.buttonsClear();
        this.buttonsAdd(RealmsResetWorldScreen.newButton((int)0, (int)(this.width() / 2 - 50), (int)RealmsConstants.row(12), (int)100, (int)20, (String)RealmsResetWorldScreen.getLocalizedString((String)"gui.cancel")));
        this.buttonsAdd(RealmsResetWorldScreen.newButton((int)3, (int)(this.width() / 2 - 160), (int)RealmsConstants.row(5), (int)100, (int)20, (String)RealmsResetWorldScreen.getLocalizedString((String)"mco.backup.generate.world")));
        this.buttonsAdd(RealmsResetWorldScreen.newButton((int)1, (int)(this.width() / 2 - 50), (int)RealmsConstants.row(5), (int)100, (int)20, (String)RealmsResetWorldScreen.getLocalizedString((String)"mco.template.default.name")));
        this.buttonsAdd(RealmsResetWorldScreen.newButton((int)2, (int)(this.width() / 2 + 60), (int)RealmsConstants.row(5), (int)100, (int)20, (String)RealmsResetWorldScreen.getLocalizedString((String)"mco.backup.button.upload")));
    }

    public void removed() {
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public void keyPressed(char ch, int eventKey) {
        if (eventKey == 1) {
            Realms.setScreen((RealmsScreen)this.lastScreen);
        }
    }

    public void buttonClicked(RealmsButton button) {
        if (!button.active()) {
            return;
        }
        switch (button.id()) {
            case 0: {
                Realms.setScreen((RealmsScreen)this.lastScreen);
                break;
            }
            case 2: {
                Realms.setScreen((RealmsScreen)new RealmsSelectFileToUploadScreen(this.serverData.id, this.serverData.activeSlot, this.lastScreen, this));
                break;
            }
            case 1: {
                Realms.setScreen((RealmsScreen)new RealmsSelectWorldTemplateScreen(this, null, false));
                break;
            }
            case 3: {
                Realms.setScreen((RealmsScreen)new RealmsResetNormalWorldScreen(this));
                break;
            }
            default: {
                return;
            }
        }
    }

    public void mouseClicked(int x, int y, int buttonNum) {
        super.mouseClicked(x, y, buttonNum);
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        this.drawCenteredString(RealmsResetWorldScreen.getLocalizedString((String)"mco.reset.world.title"), this.width() / 2, 17, 0xFFFFFF);
        this.drawCenteredString(RealmsResetWorldScreen.getLocalizedString((String)"mco.reset.world.warning"), this.width() / 2, RealmsConstants.row(1), 0xFF0000);
        super.render(xm, ym, a);
    }

    @Override
    void callback(WorldTemplate worldTemplate) {
        if (worldTemplate != null) {
            this.lastScreen.resetWorldWithTemplate(worldTemplate);
        }
    }

    public void resetWorld(String seed, int levelType, boolean generateStructures) {
        this.lastScreen.resetWorld(seed, levelType, generateStructures);
    }
}

