/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsServerAddress;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.screens.RealmsTermsScreen;
import java.io.IOException;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsConnect;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsConnectTask
extends LongRunningTask {
    private static final Logger LOGGER = LogManager.getLogger();
    private final RealmsConnect realmsConnect;
    private final RealmsServer data;
    private final RealmsScreen onlineScreen;

    public RealmsConnectTask(RealmsScreen onlineScreen, RealmsServer server) {
        this.onlineScreen = onlineScreen;
        this.realmsConnect = new RealmsConnect(onlineScreen);
        this.data = server;
    }

    @Override
    public void run() {
        this.setTitle(RealmsScreen.getLocalizedString((String)"mco.connect.connecting"));
        RealmsClient client = RealmsClient.createRealmsClient();
        boolean addressRetrieved = false;
        boolean hasError = false;
        int sleepTime = 5;
        RealmsServerAddress a = null;
        boolean tosNotAccepted = false;
        for (int i = 0; i < 20 && !this.aborted(); ++i) {
            try {
                a = client.join(this.data.id);
                addressRetrieved = true;
            }
            catch (RetryCallException e) {
                sleepTime = e.delaySeconds;
            }
            catch (RealmsServiceException e) {
                if (e.errorCode == 6002) {
                    tosNotAccepted = true;
                    break;
                }
                hasError = true;
                this.error(e.toString());
                LOGGER.error("Couldn't connect to world", (Throwable)e);
                break;
            }
            catch (IOException e) {
                LOGGER.error("Couldn't parse response connecting to world", (Throwable)e);
            }
            catch (Exception e) {
                hasError = true;
                LOGGER.error("Couldn't connect to world", (Throwable)e);
                this.error(e.getLocalizedMessage());
            }
            if (addressRetrieved) break;
            this.sleep(sleepTime);
        }
        if (tosNotAccepted) {
            Realms.setScreen((RealmsScreen)new RealmsTermsScreen(this.onlineScreen, this.data));
        } else if (!this.aborted() && !hasError) {
            if (addressRetrieved) {
                net.minecraft.realms.RealmsServerAddress address = net.minecraft.realms.RealmsServerAddress.parseString((String)a.address);
                this.realmsConnect.connect(address.getHost(), address.getPort());
            } else {
                this.error(RealmsScreen.getLocalizedString((String)"mco.errorMessage.connectionFailure"));
            }
        }
    }

    private void sleep(int sleepTimeSeconds) {
        try {
            Thread.sleep(sleepTimeSeconds * 1000);
        }
        catch (InterruptedException e1) {
            LOGGER.warn(e1.getLocalizedMessage());
        }
    }

    @Override
    public void abortTask() {
        this.realmsConnect.abort();
    }

    @Override
    public void tick() {
        this.realmsConnect.tick();
    }
}

