/*
 * Decompiled with CFR 0.152.
 */
package jdk.management.resource.internal;

import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import jdk.management.resource.ResourceContext;
import jdk.management.resource.ResourceMeter;
import jdk.management.resource.ResourceRequest;
import jdk.management.resource.ResourceType;
import jdk.management.resource.internal.SimpleResourceContext;

public class TotalResourceContext
implements ResourceContext {
    private static final TotalResourceContext totalContext = new TotalResourceContext("Total");
    final ConcurrentHashMap<ResourceType, TotalMeter> totalMeters = new ConcurrentHashMap();
    private final String name;

    private TotalResourceContext(String string) {
        this.name = string;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static TotalResourceContext getTotalContext() {
        return totalContext;
    }

    @Override
    public void close() {
    }

    @Override
    public ResourceRequest getResourceRequest(ResourceType resourceType) {
        return null;
    }

    @Override
    public TotalMeter getMeter(ResourceType resourceType) {
        return this.totalMeters.get(resourceType);
    }

    static void validateMeter(ResourceType resourceType2) {
        TotalResourceContext.totalContext.totalMeters.computeIfAbsent(resourceType2, resourceType -> new TotalMeter((ResourceType)resourceType, 0L, 0L));
    }

    @Override
    public Stream<ResourceMeter> meters() {
        return this.totalMeters.entrySet().stream().map(entry -> (TotalMeter)entry.getValue());
    }

    public String toString() {
        StringJoiner stringJoiner = new StringJoiner("; ", this.name + "[", "]");
        this.meters().forEach(resourceMeter -> stringJoiner.add(resourceMeter.toString()));
        return stringJoiner.toString();
    }

    static class TotalMeter
    implements ResourceMeter {
        private final ResourceType type;
        private long value;
        private long allocated;

        TotalMeter(ResourceType resourceType, long l, long l2) {
            this.type = resourceType;
            this.value = l;
            this.allocated = l2;
        }

        synchronized void addValue(long l) {
            this.value += l;
        }

        synchronized void addAllocated(long l) {
            this.allocated += l;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getValue() {
            long l3 = 0L;
            TotalMeter totalMeter = this;
            synchronized (totalMeter) {
                l3 += this.value;
            }
            return l3 += SimpleResourceContext.getContexts().reduceValuesToLong(1000L, simpleResourceContext -> {
                ResourceMeter resourceMeter = simpleResourceContext.getMeter(this.type);
                long l = resourceMeter == null ? 0L : resourceMeter.getValue();
                return l;
            }, 0L, (l, l2) -> l + l2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public long getAllocated() {
            long l3 = 0L;
            TotalMeter totalMeter = this;
            synchronized (totalMeter) {
                l3 += this.allocated;
            }
            return l3 += SimpleResourceContext.getContexts().reduceValuesToLong(1000L, simpleResourceContext -> {
                ResourceMeter resourceMeter = simpleResourceContext.getMeter(this.type);
                return resourceMeter == null ? 0L : resourceMeter.getAllocated();
            }, 0L, (l, l2) -> l + l2);
        }

        @Override
        public ResourceType getType() {
            return this.type;
        }

        public String toString() {
            return this.type.toString() + ": " + Long.toString(this.getValue()) + "/" + Long.toString(this.getAllocated());
        }
    }
}

