/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.ldap;

import com.sun.jndi.ldap.EventQueue;
import com.sun.jndi.ldap.LdapCtx;
import com.sun.jndi.ldap.NamingEventNotifier;
import com.sun.jndi.ldap.NotifierArgs;
import java.util.EventObject;
import java.util.Hashtable;
import java.util.Vector;
import javax.naming.NamingException;
import javax.naming.directory.SearchControls;
import javax.naming.event.NamespaceChangeListener;
import javax.naming.event.NamingExceptionEvent;
import javax.naming.event.NamingListener;
import javax.naming.event.ObjectChangeListener;
import javax.naming.ldap.UnsolicitedNotification;
import javax.naming.ldap.UnsolicitedNotificationEvent;
import javax.naming.ldap.UnsolicitedNotificationListener;

final class EventSupport {
    private static final boolean debug = false;
    private LdapCtx ctx;
    private Hashtable<NotifierArgs, NamingEventNotifier> notifiers = new Hashtable(11);
    private Vector<UnsolicitedNotificationListener> unsolicited = null;
    private EventQueue eventQueue;

    EventSupport(LdapCtx ldapCtx) {
        this.ctx = ldapCtx;
    }

    synchronized void addNamingListener(String string, int n, NamingListener namingListener) throws NamingException {
        if (namingListener instanceof ObjectChangeListener || namingListener instanceof NamespaceChangeListener) {
            NotifierArgs notifierArgs = new NotifierArgs(string, n, namingListener);
            NamingEventNotifier namingEventNotifier = this.notifiers.get(notifierArgs);
            if (namingEventNotifier == null) {
                namingEventNotifier = new NamingEventNotifier(this, this.ctx, notifierArgs, namingListener);
                this.notifiers.put(notifierArgs, namingEventNotifier);
            } else {
                namingEventNotifier.addNamingListener(namingListener);
            }
        }
        if (namingListener instanceof UnsolicitedNotificationListener) {
            if (this.unsolicited == null) {
                this.unsolicited = new Vector(3);
            }
            this.unsolicited.addElement((UnsolicitedNotificationListener)namingListener);
        }
    }

    synchronized void addNamingListener(String string, String string2, SearchControls searchControls, NamingListener namingListener) throws NamingException {
        if (namingListener instanceof ObjectChangeListener || namingListener instanceof NamespaceChangeListener) {
            NotifierArgs notifierArgs = new NotifierArgs(string, string2, searchControls, namingListener);
            NamingEventNotifier namingEventNotifier = this.notifiers.get(notifierArgs);
            if (namingEventNotifier == null) {
                namingEventNotifier = new NamingEventNotifier(this, this.ctx, notifierArgs, namingListener);
                this.notifiers.put(notifierArgs, namingEventNotifier);
            } else {
                namingEventNotifier.addNamingListener(namingListener);
            }
        }
        if (namingListener instanceof UnsolicitedNotificationListener) {
            if (this.unsolicited == null) {
                this.unsolicited = new Vector(3);
            }
            this.unsolicited.addElement((UnsolicitedNotificationListener)namingListener);
        }
    }

    synchronized void removeNamingListener(NamingListener namingListener) {
        for (NamingEventNotifier namingEventNotifier : this.notifiers.values()) {
            if (namingEventNotifier == null) continue;
            namingEventNotifier.removeNamingListener(namingListener);
            if (namingEventNotifier.hasNamingListeners()) continue;
            namingEventNotifier.stop();
            this.notifiers.remove(namingEventNotifier.info);
        }
        if (this.unsolicited != null) {
            this.unsolicited.removeElement(namingListener);
        }
    }

    synchronized boolean hasUnsolicited() {
        return this.unsolicited != null && this.unsolicited.size() > 0;
    }

    synchronized void removeDeadNotifier(NotifierArgs notifierArgs) {
        this.notifiers.remove(notifierArgs);
    }

    synchronized void fireUnsolicited(Object object) {
        if (this.unsolicited == null || this.unsolicited.size() == 0) {
            return;
        }
        if (object instanceof UnsolicitedNotification) {
            UnsolicitedNotificationEvent unsolicitedNotificationEvent = new UnsolicitedNotificationEvent(this.ctx, (UnsolicitedNotification)object);
            this.queueEvent(unsolicitedNotificationEvent, this.unsolicited);
        } else if (object instanceof NamingException) {
            NamingExceptionEvent namingExceptionEvent = new NamingExceptionEvent(this.ctx, (NamingException)object);
            this.queueEvent(namingExceptionEvent, this.unsolicited);
            this.unsolicited = null;
        }
    }

    synchronized void cleanup() {
        if (this.notifiers != null) {
            for (NamingEventNotifier namingEventNotifier : this.notifiers.values()) {
                namingEventNotifier.stop();
            }
            this.notifiers = null;
        }
        if (this.eventQueue != null) {
            this.eventQueue.stop();
            this.eventQueue = null;
        }
    }

    synchronized void queueEvent(EventObject eventObject, Vector<? extends NamingListener> vector) {
        if (this.eventQueue == null) {
            this.eventQueue = new EventQueue();
        }
        Vector vector2 = (Vector)vector.clone();
        this.eventQueue.enqueue(eventObject, vector2);
    }
}

