/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.runtime.linker;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodType;
import java.lang.invoke.SwitchPoint;
import java.lang.invoke.TypeDescriptor;
import jdk.internal.dynalink.CallSiteDescriptor;
import jdk.internal.dynalink.linker.GuardedInvocation;
import jdk.internal.dynalink.linker.LinkRequest;
import jdk.internal.dynalink.support.Guards;
import jdk.nashorn.internal.lookup.Lookup;
import jdk.nashorn.internal.runtime.Context;
import jdk.nashorn.internal.runtime.FindProperty;
import jdk.nashorn.internal.runtime.GlobalConstants;
import jdk.nashorn.internal.runtime.ScriptObject;
import jdk.nashorn.internal.runtime.UserAccessorProperty;
import jdk.nashorn.internal.runtime.linker.NashornGuards;

public final class PrimitiveLookup {
    private PrimitiveLookup() {
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, Class<?> receiverClass, ScriptObject wrappedReceiver, MethodHandle wrapFilter, MethodHandle protoFilter) {
        return PrimitiveLookup.lookupPrimitive(request, Guards.getInstanceOfGuard(receiverClass), wrappedReceiver, wrapFilter, protoFilter);
    }

    public static GuardedInvocation lookupPrimitive(LinkRequest request, MethodHandle guard, ScriptObject wrappedReceiver, MethodHandle wrapFilter, MethodHandle protoFilter) {
        GuardedInvocation link;
        CallSiteDescriptor desc = request.getCallSiteDescriptor();
        if (desc.getNameTokenCount() > 2) {
            ScriptObject proto;
            GuardedInvocation link2;
            String name = desc.getNameToken(2);
            FindProperty find = wrappedReceiver.findProperty(name, true);
            if (find == null) {
                return null;
            }
            SwitchPoint sp = find.getProperty().getBuiltinSwitchPoint();
            if (sp instanceof Context.BuiltinSwitchPoint && !sp.hasBeenInvalidated()) {
                return new GuardedInvocation(GlobalConstants.staticConstantGetter(find.getObjectValue()), guard, sp, null);
            }
            if (find.isInherited() && !(find.getProperty() instanceof UserAccessorProperty) && (link2 = (proto = wrappedReceiver.getProto()).lookup(desc, request)) != null) {
                MethodHandle invocation = link2.getInvocation();
                MethodHandle adaptedInvocation = Lookup.MH.asType(invocation, invocation.type().changeParameterType(0, Object.class));
                MethodHandle method = Lookup.MH.filterArguments(adaptedInvocation, 0, protoFilter);
                MethodHandle protoGuard = Lookup.MH.filterArguments(link2.getGuard(), 0, protoFilter);
                return new GuardedInvocation(method, NashornGuards.combineGuards(guard, protoGuard));
            }
        }
        if ((link = wrappedReceiver.lookup(desc, request)) != null) {
            MethodHandle method = link.getInvocation();
            TypeDescriptor.OfField receiverType = method.type().parameterType(0);
            if (receiverType != Object.class) {
                MethodType wrapType = wrapFilter.type();
                assert (((Class)receiverType).isAssignableFrom((Class<?>)wrapType.returnType()));
                method = Lookup.MH.filterArguments(method, 0, Lookup.MH.asType(wrapFilter, wrapType.changeReturnType((Class<?>)receiverType)));
            }
            return new GuardedInvocation(method, guard, link.getSwitchPoints(), null);
        }
        return null;
    }
}

