/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements Runnable,
n,
oe,
ot {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private static MinecraftServer l;
    private final ats m;
    private final os n = new os("server", this, MinecraftServer.ay());
    private final File o;
    private final List<kn> p = Lists.newArrayList();
    protected final m b;
    public final nu c = new nu();
    private final lm q;
    private final jt r = new jt();
    private final Random s = new Random();
    private int u = -1;
    public lf[] d;
    private ly v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G = 0;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private long X = 0L;
    private final GameProfileRepository Y;
    private final lu Z;
    protected final Queue<FutureTask<?>> j = Queues.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.ay();

    public MinecraftServer(Proxy proxy, File file) {
        this.e = proxy;
        l = this;
        this.o = null;
        this.q = null;
        this.Z = new lu(this, file);
        this.b = null;
        this.m = null;
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    public MinecraftServer(File file, Proxy proxy, File file2) {
        this.e = proxy;
        l = this;
        this.o = file;
        this.q = new lm(this);
        this.Z = new lu(this, file2);
        this.b = this.h();
        this.m = new atl(file);
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    protected be h() {
        return new be();
    }

    protected abstract boolean i() throws IOException;

    protected void a(String string) {
        if (this.X().b(string)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.X().a(string, new nv(){
                private long b = MinecraftServer.ay();

                @Override
                public void a(String string) {
                }

                @Override
                public void b(String string) {
                }

                @Override
                public void a(int n2) {
                    if (MinecraftServer.ay() - this.b >= 1000L) {
                        this.b = MinecraftServer.ay();
                        k.info("Converting... " + n2 + "%");
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(String string) {
                }
            });
        }
    }

    protected synchronized void b(String string) {
        this.S = string;
    }

    public synchronized String j() {
        return this.S;
    }

    protected void a(String string, String string2, long l22, ads ads2, String string3) {
        adq \u26033;
        this.a(string);
        this.b("menu.loadingLevel");
        this.d = new lf[3];
        this.i = new long[this.d.length][100];
        atq atq2 = this.m.a(string, true);
        this.a(this.T(), atq2);
        atp \u26032 = atq2.d();
        if (\u26032 == null) {
            if (this.W()) {
                \u26033 = ky.a;
            } else {
                long l22;
                \u26033 = new adq(l22, this.m(), this.l(), this.o(), ads2);
                \u26033.a(string3);
                if (this.M) {
                    \u26033.a();
                }
            }
            \u26032 = new atp(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new adq(\u26032);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            \u2603 = 0;
            if (i2 == 1) {
                \u2603 = -1;
            }
            if (i2 == 2) {
                \u2603 = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.W() ? (lf)new ky(this, atq2, \u26032, \u2603, this.c).b() : (lf)new lf(this, atq2, \u26032, \u2603, this.c).b();
                this.d[i2].a(\u26033);
            } else {
                this.d[i2] = (lf)new la(this, atq2, \u2603, this.d[0], this.c).b();
            }
            this.d[i2].a(new lc(this, this.d[i2]));
            if (this.S()) continue;
            this.d[i2].P().a(this.m());
        }
        this.v.a(this.d);
        this.a(this.n());
        this.k();
    }

    protected void k() {
        int n2 = 16;
        \u2603 = 4;
        \u2603 = 192;
        \u2603 = 625;
        \u2603 = 0;
        this.b("menu.generatingTerrain");
        \u2603 = 0;
        k.info("Preparing start region for level " + \u2603);
        lf \u26032 = this.d[\u2603];
        ck \u26033 = \u26032.M();
        long \u26034 = MinecraftServer.ay();
        for (\u2603 = -192; \u2603 <= 192 && this.u(); \u2603 += 16) {
            for (\u2603 = -192; \u2603 <= 192 && this.u(); \u2603 += 16) {
                long l2 = MinecraftServer.ay();
                if (l2 - \u26034 > 1000L) {
                    this.a_("Preparing spawn area", \u2603 * 100 / 625);
                    \u26034 = l2;
                }
                ++\u2603;
                \u26032.b.c(\u26033.n() + \u2603 >> 4, \u26033.p() + \u2603 >> 4);
            }
        }
        this.r();
    }

    protected void a(String string, atq atq2) {
        File file = new File(atq2.b(), "resources.zip");
        if (file.isFile()) {
            this.a_("level://" + string + "/" + file.getName(), "");
        }
    }

    public abstract boolean l();

    public abstract adq.a m();

    public abstract ok n();

    public abstract boolean o();

    public abstract int p();

    public abstract boolean q();

    protected void a_(String string, int n2) {
        this.f = string;
        this.g = n2;
        k.info(string + ": " + n2 + "%");
    }

    protected void r() {
        this.f = null;
        this.g = 0;
    }

    protected void a(boolean bl2) {
        if (this.N) {
            return;
        }
        for (lf lf2 : this.d) {
            if (lf2 == null) continue;
            if (!bl2) {
                k.info("Saving chunks for level '" + lf2.P().k() + "'/" + lf2.t.k());
            }
            try {
                lf2.a(true, null);
            }
            catch (ado ado2) {
                k.warn(ado2.getMessage());
            }
        }
    }

    public void s() {
        if (this.N) {
            return;
        }
        k.info("Stopping server");
        if (this.ap() != null) {
            this.ap().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            k.info("Saving worlds");
            this.a(false);
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                lf lf2 = this.d[i2];
                lf2.o();
            }
        }
        if (this.n.d()) {
            this.n.e();
        }
    }

    public boolean u() {
        return this.w;
    }

    public void v() {
        this.w = false;
    }

    protected void w() {
        l = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.i()) {
                this.ab = MinecraftServer.ay();
                long l2 = 0L;
                this.r.a(new fb(this.E));
                this.r.a(new jt.c("1.8.3", 47));
                this.a(this.r);
                while (this.w) {
                    \u2603 = MinecraftServer.ay();
                    \u2603 = \u2603 - this.ab;
                    if (\u2603 > 2000L && this.ab - this.R >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{\u2603, \u2603 / 50L});
                        \u2603 = 2000L;
                        this.R = this.ab;
                    }
                    if (\u2603 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        \u2603 = 0L;
                    }
                    l2 += \u2603;
                    this.ab = \u2603;
                    if (this.d[0].f()) {
                        this.z();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.z();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.Q = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            k.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof f ? this.b(((f)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.x(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(\u26032)) {
                k.error("This crash report has been saved to: " + \u26032.getAbsolutePath());
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.x = true;
                this.s();
            }
            catch (Throwable \u26033) {
                k.error("Exception stopping the server", \u26033);
            }
            finally {
                this.y();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(jt jt2) {
        File file = this.d("server-icon.png");
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf \u26032 = Base64.encode((ByteBuf)byteBuf);
                jt2.a("data:image/png;base64," + \u26032.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File x() {
        return new File(".");
    }

    protected void a(b b2) {
    }

    protected void y() {
    }

    public void z() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.A();
        if (l2 - this.X >= 5000000000L) {
            this.X = l2;
            this.r.a(new jt.a(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int \u26032 = nt.a(this.s, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.v.v().get(\u26032 + i2).cd();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.r.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - l2;
        this.c.b();
        this.c.a("snooper");
        if (!this.n.d() && this.y > 100) {
            this.n.a();
        }
        if (this.y % 6000 == 0) {
            this.n.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void A() {
        int n2;
        this.c.a("jobs");
        Queue<FutureTask<?>> queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                h.a(this.j.poll(), k);
            }
        }
        this.c.c("levels");
        for (n2 = 0; n2 < this.d.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.B()) {
                lf lf2 = this.d[n2];
                this.c.a(lf2.P().k());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new hv(lf2.K(), lf2.L(), lf2.Q().b("doDaylightCycle")), lf2.t.q());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    lf2.c();
                }
                catch (Throwable \u26032) {
                    b b2 = b.a(\u26032, "Exception ticking world");
                    lf2.a(b2);
                    throw new f(b2);
                }
                try {
                    lf2.i();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    lf2.a(b3);
                    throw new f(b3);
                }
                this.c.b();
                this.c.a("tracker");
                lf2.s().a();
                this.c.b();
                this.c.b();
            }
            this.i[n2][this.y % 100] = System.nanoTime() - l2;
        }
        this.c.c("connection");
        this.ap().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (n2 = 0; n2 < this.p.size(); ++n2) {
            this.p.get(n2).c();
        }
        this.c.b();
    }

    public boolean B() {
        return true;
    }

    public void C() {
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String string) {
        return new File(this.x(), string);
    }

    public void f(String string) {
        k.warn(string);
    }

    public lf a(int n2) {
        if (n2 == -1) {
            return this.d[1];
        }
        if (n2 == 1) {
            return this.d[2];
        }
        return this.d[0];
    }

    public String G() {
        return "1.8.3";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new Callable<String>(){

            public String a() throws Exception {
                return MinecraftServer.this.c.a ? MinecraftServer.this.c.c() : "N/A (disabled)";
            }

            @Override
            public /* synthetic */ Object call() throws Exception {
                return this.a();
            }
        });
        if (this.v != null) {
            b2.g().a("Player Count", new Callable<String>(){

                public String a() {
                    return MinecraftServer.this.v.o() + " / " + MinecraftServer.this.v.p() + "; " + MinecraftServer.this.v.v();
                }

                @Override
                public /* synthetic */ Object call() throws Exception {
                    return this.a();
                }
            });
        }
        return b2;
    }

    public List<String> a(n n2, String string2, ck ck2) {
        String string2;
        ArrayList arrayList = Lists.newArrayList();
        if (string2.startsWith("/")) {
            boolean bl2 = !(string2 = string2.substring(1)).contains(" ");
            List<String> \u26032 = this.b.a(n2, string2, ck2);
            if (\u26032 != null) {
                for (String string3 : \u26032) {
                    if (bl2) {
                        arrayList.add("/" + string3);
                        continue;
                    }
                    arrayList.add(string3);
                }
            }
            return arrayList;
        }
        String[] \u26033 = string2.split(" ", -1);
        \u2603 = \u26033[\u26033.length - 1];
        for (String string4 : this.v.f()) {
            if (!j.a(\u2603, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer M() {
        return l;
    }

    public boolean N() {
        return this.o != null;
    }

    @Override
    public String e_() {
        return "Server";
    }

    @Override
    public void a(ev ev2) {
        k.info(ev2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public m O() {
        return this.b;
    }

    public KeyPair P() {
        return this.H;
    }

    public String R() {
        return this.I;
    }

    public void i(String string) {
        this.I = string;
    }

    public boolean S() {
        return this.I != null;
    }

    public String T() {
        return this.J;
    }

    public void j(String string) {
        this.J = string;
    }

    public void k(String string) {
        this.K = string;
    }

    public String U() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(ok ok2) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            lf lf2 = this.d[i2];
            if (lf2 == null) continue;
            if (lf2.P().t()) {
                lf2.P().a(ok.d);
                lf2.a(true, true);
                continue;
            }
            if (this.S()) {
                lf2.P().a(ok2);
                lf2.a(lf2.aa() != ok.a, true);
                continue;
            }
            lf2.P().a(ok2);
            lf2.a(this.V(), this.A);
        }
    }

    protected boolean V() {
        return true;
    }

    public boolean W() {
        return this.L;
    }

    public void b(boolean bl2) {
        this.L = bl2;
    }

    public void c(boolean bl2) {
        this.M = bl2;
    }

    public ats X() {
        return this.m;
    }

    public void Z() {
        this.N = true;
        this.X().d();
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            lf lf2 = this.d[i2];
            if (lf2 == null) continue;
            lf2.o();
        }
        this.X().e(this.d[0].O().g());
        this.v();
    }

    public String aa() {
        return this.O;
    }

    public String ab() {
        return this.P;
    }

    public void a_(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(os os2) {
        os2.a("whitelist_enabled", false);
        os2.a("whitelist_count", 0);
        if (this.v != null) {
            os2.a("players_current", this.H());
            os2.a("players_max", this.I());
            os2.a("players_seen", this.v.q().length);
        }
        os2.a("uses_auth", this.z);
        os2.a("gui_state", this.ar() ? "enabled" : "disabled");
        os2.a("run_time", (MinecraftServer.ay() - os2.g()) / 60L * 1000L);
        os2.a("avg_tick_ms", (int)(nt.a(this.h) * 1.0E-6));
        int n2 = 0;
        if (this.d != null) {
            for (\u2603 = 0; \u2603 < this.d.length; ++\u2603) {
                if (this.d[\u2603] == null) continue;
                lf lf2 = this.d[\u2603];
                atp \u26032 = lf2.P();
                os2.a("world[" + n2 + "][dimension]", lf2.t.q());
                os2.a("world[" + n2 + "][mode]", (Object)\u26032.r());
                os2.a("world[" + n2 + "][difficulty]", (Object)lf2.aa());
                os2.a("world[" + n2 + "][hardcore]", \u26032.t());
                os2.a("world[" + n2 + "][generator_name]", \u26032.u().a());
                os2.a("world[" + n2 + "][generator_version]", \u26032.u().d());
                os2.a("world[" + n2 + "][height]", this.F);
                os2.a("world[" + n2 + "][chunks_loaded]", lf2.N().g());
                ++n2;
            }
        }
        os2.a("worlds", n2);
    }

    @Override
    public void b(os os2) {
        os2.b("singleplayer", this.S());
        os2.b("server_brand", this.getServerModName());
        os2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        os2.b("dedicated", this.ad());
    }

    @Override
    public boolean ac() {
        return true;
    }

    public abstract boolean ad();

    public boolean ae() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean af() {
        return this.A;
    }

    public void e(boolean bl2) {
        this.A = bl2;
    }

    public boolean ag() {
        return this.B;
    }

    public abstract boolean ah();

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean ai() {
        return this.C;
    }

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean aj() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean ak();

    public String al() {
        return this.E;
    }

    public void l(String string) {
        this.E = string;
    }

    public int am() {
        return this.F;
    }

    public void c(int n2) {
        this.F = n2;
    }

    public boolean an() {
        return this.x;
    }

    public ly ao() {
        return this.v;
    }

    public void a(ly ly2) {
        this.v = ly2;
    }

    public void a(adq.a a2) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            MinecraftServer.M().d[i2].P().a(a2);
        }
    }

    public lm ap() {
        return this.q;
    }

    public boolean aq() {
        return this.Q;
    }

    public boolean ar() {
        return false;
    }

    public abstract String a(adq.a var1, boolean var2);

    public int as() {
        return this.y;
    }

    public void at() {
        this.T = true;
    }

    public os au() {
        return this.n;
    }

    @Override
    public ck c() {
        return ck.a;
    }

    @Override
    public auj d() {
        return new auj(0.0, 0.0, 0.0);
    }

    @Override
    public adn e() {
        return this.d[0];
    }

    @Override
    public pl f() {
        return null;
    }

    public int av() {
        return 16;
    }

    public boolean a(adn adn2, ck ck2, wo wo2) {
        return false;
    }

    public boolean aw() {
        return this.U;
    }

    public Proxy ax() {
        return this.e;
    }

    public static long ay() {
        return System.currentTimeMillis();
    }

    public int az() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    @Override
    public ev f_() {
        return new fb(this.e_());
    }

    public boolean aA() {
        return true;
    }

    public MinecraftSessionService aC() {
        return this.W;
    }

    public GameProfileRepository aD() {
        return this.Y;
    }

    public lu aE() {
        return this.Z;
    }

    public jt aF() {
        return this.r;
    }

    public void aG() {
        this.X = 0L;
    }

    public pl a(UUID uUID) {
        for (lf lf2 : this.d) {
            if (lf2 == null || (\u2603 = lf2.a(uUID)) == null) continue;
            return \u2603;
        }
        return null;
    }

    @Override
    public boolean u_() {
        return MinecraftServer.M().d[0].Q().b("sendCommandFeedback");
    }

    @Override
    public void a(o.a a2, int n2) {
    }

    public int aH() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> ListenableFuture<V> a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.aI() && !this.an()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            Queue<FutureTask<?>> queue = this.j;
            synchronized (queue) {
                this.j.add((FutureTask<?>)listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aI() {
        return Thread.currentThread() == this.aa;
    }

    public int aJ() {
        return 256;
    }
}

