/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal.rcache;

import java.util.HashMap;
import java.util.Map;
import sun.security.krb5.internal.KerberosTime;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.KrbApErrException;
import sun.security.krb5.internal.ReplayCache;
import sun.security.krb5.internal.rcache.AuthList;
import sun.security.krb5.internal.rcache.AuthTimeWithHash;

public class MemoryCache
extends ReplayCache {
    private static final int lifespan = KerberosTime.getDefaultSkew();
    private static final boolean DEBUG = Krb5.DEBUG;
    private final Map<String, AuthList> content = new HashMap<String, AuthList>();

    @Override
    public synchronized void checkAndStore(KerberosTime kerberosTime, AuthTimeWithHash authTimeWithHash) throws KrbApErrException {
        String string = authTimeWithHash.client + "|" + authTimeWithHash.server;
        AuthList authList = this.content.get(string);
        if (DEBUG) {
            System.out.println("MemoryCache: add " + authTimeWithHash + " to " + string);
        }
        if (authList == null) {
            authList = new AuthList(lifespan);
            authList.put(authTimeWithHash, kerberosTime);
            if (!authList.isEmpty()) {
                this.content.put(string, authList);
            }
        } else {
            if (DEBUG) {
                System.out.println("MemoryCache: Existing AuthList:\n" + authList);
            }
            authList.put(authTimeWithHash, kerberosTime);
            if (authList.isEmpty()) {
                this.content.remove(string);
            }
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (AuthList authList : this.content.values()) {
            stringBuilder.append(authList.toString());
        }
        return stringBuilder.toString();
    }
}

