/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.realms;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsServerAddress;
import net.minecraft.realms.RealmsServerPing;
import net.minecraft.realms.RealmsSharedConstants;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsServerStatusPinger {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<el> connections = Collections.synchronizedList(Lists.newArrayList());

    public void pingServer(final String string, final RealmsServerPing realmsServerPing) throws UnknownHostException {
        if (string == null || string.startsWith("0.0.0.0") || string.isEmpty()) {
            return;
        }
        RealmsServerAddress realmsServerAddress = RealmsServerAddress.parseString(string);
        final el \u26032 = el.a(InetAddress.getByName(realmsServerAddress.getHost()), realmsServerAddress.getPort(), false);
        this.connections.add(\u26032);
        \u26032.a(new jq(){
            private boolean e = false;

            @Override
            public void a(js js2) {
                jt jt2 = js2.a();
                if (jt2.b() != null) {
                    realmsServerPing.nrOfPlayers = String.valueOf(jt2.b().b());
                    if (ArrayUtils.isNotEmpty((Object[])jt2.b().c())) {
                        StringBuilder stringBuilder = new StringBuilder();
                        for (GameProfile gameProfile : jt2.b().c()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\n");
                            }
                            stringBuilder.append(gameProfile.getName());
                        }
                        if (jt2.b().c().length < jt2.b().b()) {
                            if (stringBuilder.length() > 0) {
                                stringBuilder.append("\n");
                            }
                            stringBuilder.append("... and ").append(jt2.b().b() - jt2.b().c().length).append(" more ...");
                        }
                        realmsServerPing.playerList = stringBuilder.toString();
                    }
                } else {
                    realmsServerPing.playerList = "";
                }
                \u26032.a(new jv(Realms.currentTimeMillis()));
                this.e = true;
            }

            @Override
            public void a(jr jr2) {
                \u26032.a(new fb("Finished"));
            }

            @Override
            public void a(ev ev2) {
                if (!this.e) {
                    LOGGER.error("Can't ping " + string + ": " + ev2.c());
                }
            }
        });
        try {
            \u26032.a(new jd(RealmsSharedConstants.NETWORK_PROTOCOL_VERSION, realmsServerAddress.getHost(), realmsServerAddress.getPort(), em.c));
            \u26032.a(new jw());
        }
        catch (Throwable \u26033) {
            LOGGER.error((Object)\u26033);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tick() {
        List<el> list = this.connections;
        synchronized (list) {
            Iterator<el> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                el el2 = iterator.next();
                if (el2.g()) {
                    el2.a();
                    continue;
                }
                iterator.remove();
                el2.l();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        List<el> list = this.connections;
        synchronized (list) {
            Iterator<el> iterator = this.connections.iterator();
            while (iterator.hasNext()) {
                el el2 = iterator.next();
                if (!el2.g()) continue;
                iterator.remove();
                el2.a(new fb("Cancelled"));
            }
        }
    }
}

