/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.spi.BreakIteratorProvider;
import java.text.spi.CollatorProvider;
import java.text.spi.DateFormatProvider;
import java.text.spi.DateFormatSymbolsProvider;
import java.text.spi.DecimalFormatSymbolsProvider;
import java.text.spi.NumberFormatProvider;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import java.util.spi.CurrencyNameProvider;
import java.util.spi.LocaleNameProvider;
import java.util.spi.LocaleServiceProvider;
import java.util.spi.TimeZoneNameProvider;
import sun.security.action.GetPropertyAction;
import sun.util.locale.provider.BreakIteratorProviderImpl;
import sun.util.locale.provider.CalendarDataProviderImpl;
import sun.util.locale.provider.CalendarNameProviderImpl;
import sun.util.locale.provider.CalendarProviderImpl;
import sun.util.locale.provider.CollatorProviderImpl;
import sun.util.locale.provider.CurrencyNameProviderImpl;
import sun.util.locale.provider.DateFormatProviderImpl;
import sun.util.locale.provider.DateFormatSymbolsProviderImpl;
import sun.util.locale.provider.DecimalFormatSymbolsProviderImpl;
import sun.util.locale.provider.JRELocaleConstants;
import sun.util.locale.provider.LocaleDataMetaInfo;
import sun.util.locale.provider.LocaleNameProviderImpl;
import sun.util.locale.provider.LocaleProviderAdapter;
import sun.util.locale.provider.LocaleResources;
import sun.util.locale.provider.NumberFormatProviderImpl;
import sun.util.locale.provider.ResourceBundleBasedAdapter;
import sun.util.locale.provider.TimeZoneNameProviderImpl;
import sun.util.resources.LocaleData;
import sun.util.spi.CalendarProvider;

public class JRELocaleProviderAdapter
extends LocaleProviderAdapter
implements ResourceBundleBasedAdapter {
    private static final String LOCALE_DATA_JAR_NAME = "localedata.jar";
    private final ConcurrentMap<String, Set<String>> langtagSets = new ConcurrentHashMap<String, Set<String>>();
    private final ConcurrentMap<Locale, LocaleResources> localeResourcesMap = new ConcurrentHashMap<Locale, LocaleResources>();
    private volatile LocaleData localeData;
    private volatile BreakIteratorProvider breakIteratorProvider = null;
    private volatile CollatorProvider collatorProvider = null;
    private volatile DateFormatProvider dateFormatProvider = null;
    private volatile DateFormatSymbolsProvider dateFormatSymbolsProvider = null;
    private volatile DecimalFormatSymbolsProvider decimalFormatSymbolsProvider = null;
    private volatile NumberFormatProvider numberFormatProvider = null;
    private volatile CurrencyNameProvider currencyNameProvider = null;
    private volatile LocaleNameProvider localeNameProvider = null;
    private volatile TimeZoneNameProvider timeZoneNameProvider = null;
    private volatile CalendarDataProvider calendarDataProvider = null;
    private volatile CalendarNameProvider calendarNameProvider = null;
    private volatile CalendarProvider calendarProvider = null;
    private static volatile Boolean isNonENSupported = null;

    @Override
    public LocaleProviderAdapter.Type getAdapterType() {
        return LocaleProviderAdapter.Type.JRE;
    }

    @Override
    public <P extends LocaleServiceProvider> P getLocaleServiceProvider(Class<P> clazz) {
        switch (clazz.getSimpleName()) {
            case "BreakIteratorProvider": {
                return (P)this.getBreakIteratorProvider();
            }
            case "CollatorProvider": {
                return (P)this.getCollatorProvider();
            }
            case "DateFormatProvider": {
                return (P)this.getDateFormatProvider();
            }
            case "DateFormatSymbolsProvider": {
                return (P)this.getDateFormatSymbolsProvider();
            }
            case "DecimalFormatSymbolsProvider": {
                return (P)this.getDecimalFormatSymbolsProvider();
            }
            case "NumberFormatProvider": {
                return (P)this.getNumberFormatProvider();
            }
            case "CurrencyNameProvider": {
                return (P)this.getCurrencyNameProvider();
            }
            case "LocaleNameProvider": {
                return (P)this.getLocaleNameProvider();
            }
            case "TimeZoneNameProvider": {
                return (P)this.getTimeZoneNameProvider();
            }
            case "CalendarDataProvider": {
                return (P)this.getCalendarDataProvider();
            }
            case "CalendarNameProvider": {
                return (P)this.getCalendarNameProvider();
            }
            case "CalendarProvider": {
                return (P)this.getCalendarProvider();
            }
        }
        throw new InternalError("should not come down here");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BreakIteratorProvider getBreakIteratorProvider() {
        if (this.breakIteratorProvider == null) {
            BreakIteratorProviderImpl breakIteratorProviderImpl = new BreakIteratorProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.breakIteratorProvider == null) {
                    this.breakIteratorProvider = breakIteratorProviderImpl;
                }
            }
        }
        return this.breakIteratorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CollatorProvider getCollatorProvider() {
        if (this.collatorProvider == null) {
            CollatorProviderImpl collatorProviderImpl = new CollatorProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CollationData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.collatorProvider == null) {
                    this.collatorProvider = collatorProviderImpl;
                }
            }
        }
        return this.collatorProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateFormatProvider getDateFormatProvider() {
        if (this.dateFormatProvider == null) {
            DateFormatProviderImpl dateFormatProviderImpl = new DateFormatProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.dateFormatProvider == null) {
                    this.dateFormatProvider = dateFormatProviderImpl;
                }
            }
        }
        return this.dateFormatProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DateFormatSymbolsProvider getDateFormatSymbolsProvider() {
        if (this.dateFormatSymbolsProvider == null) {
            DateFormatSymbolsProviderImpl dateFormatSymbolsProviderImpl = new DateFormatSymbolsProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.dateFormatSymbolsProvider == null) {
                    this.dateFormatSymbolsProvider = dateFormatSymbolsProviderImpl;
                }
            }
        }
        return this.dateFormatSymbolsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DecimalFormatSymbolsProvider getDecimalFormatSymbolsProvider() {
        if (this.decimalFormatSymbolsProvider == null) {
            DecimalFormatSymbolsProviderImpl decimalFormatSymbolsProviderImpl = new DecimalFormatSymbolsProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.decimalFormatSymbolsProvider == null) {
                    this.decimalFormatSymbolsProvider = decimalFormatSymbolsProviderImpl;
                }
            }
        }
        return this.decimalFormatSymbolsProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NumberFormatProvider getNumberFormatProvider() {
        if (this.numberFormatProvider == null) {
            NumberFormatProviderImpl numberFormatProviderImpl = new NumberFormatProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.numberFormatProvider == null) {
                    this.numberFormatProvider = numberFormatProviderImpl;
                }
            }
        }
        return this.numberFormatProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CurrencyNameProvider getCurrencyNameProvider() {
        if (this.currencyNameProvider == null) {
            CurrencyNameProviderImpl currencyNameProviderImpl = new CurrencyNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CurrencyNames"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.currencyNameProvider == null) {
                    this.currencyNameProvider = currencyNameProviderImpl;
                }
            }
        }
        return this.currencyNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocaleNameProvider getLocaleNameProvider() {
        if (this.localeNameProvider == null) {
            LocaleNameProviderImpl localeNameProviderImpl = new LocaleNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("LocaleNames"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.localeNameProvider == null) {
                    this.localeNameProvider = localeNameProviderImpl;
                }
            }
        }
        return this.localeNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TimeZoneNameProvider getTimeZoneNameProvider() {
        if (this.timeZoneNameProvider == null) {
            TimeZoneNameProviderImpl timeZoneNameProviderImpl = new TimeZoneNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("TimeZoneNames"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.timeZoneNameProvider == null) {
                    this.timeZoneNameProvider = timeZoneNameProviderImpl;
                }
            }
        }
        return this.timeZoneNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarDataProvider getCalendarDataProvider() {
        if (this.calendarDataProvider == null) {
            CalendarDataProviderImpl calendarDataProviderImpl = new CalendarDataProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CalendarData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.calendarDataProvider == null) {
                    this.calendarDataProvider = calendarDataProviderImpl;
                }
            }
        }
        return this.calendarDataProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarNameProvider getCalendarNameProvider() {
        if (this.calendarNameProvider == null) {
            CalendarNameProviderImpl calendarNameProviderImpl = new CalendarNameProviderImpl(this.getAdapterType(), this.getLanguageTagSet("FormatData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.calendarNameProvider == null) {
                    this.calendarNameProvider = calendarNameProviderImpl;
                }
            }
        }
        return this.calendarNameProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CalendarProvider getCalendarProvider() {
        if (this.calendarProvider == null) {
            CalendarProviderImpl calendarProviderImpl = new CalendarProviderImpl(this.getAdapterType(), this.getLanguageTagSet("CalendarData"));
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.calendarProvider == null) {
                    this.calendarProvider = calendarProviderImpl;
                }
            }
        }
        return this.calendarProvider;
    }

    @Override
    public LocaleResources getLocaleResources(Locale locale) {
        LocaleResources localeResources;
        LocaleResources localeResources2 = (LocaleResources)this.localeResourcesMap.get(locale);
        if (localeResources2 == null && (localeResources = this.localeResourcesMap.putIfAbsent(locale, localeResources2 = new LocaleResources(this, locale))) != null) {
            localeResources2 = localeResources;
        }
        return localeResources2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LocaleData getLocaleData() {
        if (this.localeData == null) {
            JRELocaleProviderAdapter jRELocaleProviderAdapter = this;
            synchronized (jRELocaleProviderAdapter) {
                if (this.localeData == null) {
                    this.localeData = new LocaleData(this.getAdapterType());
                }
            }
        }
        return this.localeData;
    }

    @Override
    public Locale[] getAvailableLocales() {
        return (Locale[])AvailableJRELocales.localeList.clone();
    }

    public Set<String> getLanguageTagSet(String string) {
        Set<String> set;
        Set<String> set2 = (Set<String>)this.langtagSets.get(string);
        if (set2 == null && (set = this.langtagSets.putIfAbsent(string, set2 = this.createLanguageTagSet(string))) != null) {
            set2 = set;
        }
        return set2;
    }

    protected Set<String> createLanguageTagSet(String string) {
        String string2 = LocaleDataMetaInfo.getSupportedLocaleString(string);
        HashSet<String> hashSet = new HashSet<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string2);
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken();
            if (string3.equals("|")) {
                if (!JRELocaleProviderAdapter.isNonENLangSupported()) break;
                continue;
            }
            hashSet.add(string3);
        }
        return hashSet;
    }

    private static Locale[] createAvailableLocales() {
        String string = LocaleDataMetaInfo.getSupportedLocaleString("AvailableLocales");
        if (string.length() == 0) {
            throw new InternalError("No available locales for JRE");
        }
        int n = string.indexOf(124);
        StringTokenizer stringTokenizer = JRELocaleProviderAdapter.isNonENLangSupported() ? new StringTokenizer(string.substring(0, n) + string.substring(n + 1)) : new StringTokenizer(string.substring(0, n));
        int n2 = stringTokenizer.countTokens();
        Locale[] localeArray = new Locale[n2 + 1];
        localeArray[0] = Locale.ROOT;
        block10: for (int i = 1; i <= n2; ++i) {
            String string2;
            switch (string2 = stringTokenizer.nextToken()) {
                case "ja-JP-JP": {
                    localeArray[i] = JRELocaleConstants.JA_JP_JP;
                    continue block10;
                }
                case "no-NO-NY": {
                    localeArray[i] = JRELocaleConstants.NO_NO_NY;
                    continue block10;
                }
                case "th-TH-TH": {
                    localeArray[i] = JRELocaleConstants.TH_TH_TH;
                    continue block10;
                }
                default: {
                    localeArray[i] = Locale.forLanguageTag(string2);
                }
            }
        }
        return localeArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean isNonENLangSupported() {
        if (isNonENSupported != null) return isNonENSupported;
        Class<JRELocaleProviderAdapter> clazz = JRELocaleProviderAdapter.class;
        synchronized (JRELocaleProviderAdapter.class) {
            if (isNonENSupported != null) return isNonENSupported;
            String string = File.separator;
            String string2 = AccessController.doPrivileged(new GetPropertyAction("java.home")) + string + "lib" + string + "ext" + string + LOCALE_DATA_JAR_NAME;
            final File file = new File(string2);
            isNonENSupported = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    return file.exists();
                }
            });
            // ** MonitorExit[var0] (shouldn't be in output)
            return isNonENSupported;
        }
    }

    static /* synthetic */ Locale[] access$100() {
        return JRELocaleProviderAdapter.createAvailableLocales();
    }

    private static class AvailableJRELocales {
        private static final Locale[] localeList = JRELocaleProviderAdapter.access$100();

        private AvailableJRELocales() {
        }
    }
}

