/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.util;

import com.mojang.realmsclient.client.RealmsClient;
import com.mojang.realmsclient.dto.WorldTemplate;
import com.mojang.realmsclient.exception.RealmsServiceException;
import com.mojang.realmsclient.exception.RetryCallException;
import com.mojang.realmsclient.gui.LongRunningTask;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsScreen;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RealmsTasks {
    private static final Logger LOGGER = LogManager.getLogger();

    public static class ResettingWorldTask
    extends LongRunningTask {
        private final String seed;
        private final WorldTemplate worldTemplate;
        private final int levelType;
        private final boolean generateStructures;
        private final long serverId;
        private final RealmsScreen lastScreen;

        public ResettingWorldTask(long serverId, RealmsScreen lastScreen, WorldTemplate worldTemplate) {
            this.seed = null;
            this.worldTemplate = worldTemplate;
            this.levelType = -1;
            this.generateStructures = true;
            this.serverId = serverId;
            this.lastScreen = lastScreen;
        }

        public ResettingWorldTask(long serverId, RealmsScreen lastScreen, String seed, int levelType, boolean generateStructures) {
            this.seed = seed;
            this.worldTemplate = null;
            this.levelType = levelType;
            this.generateStructures = generateStructures;
            this.serverId = serverId;
            this.lastScreen = lastScreen;
        }

        @Override
        public void run() {
            RealmsClient client = RealmsClient.createRealmsClient();
            String title = RealmsScreen.getLocalizedString((String)"mco.reset.world.resetting.screen.title");
            this.setTitle(title);
            for (int i = 0; i < 6; ++i) {
                try {
                    if (this.aborted()) {
                        return;
                    }
                    if (this.worldTemplate != null) {
                        client.resetWorldWithTemplate(this.serverId, this.worldTemplate.id);
                    } else {
                        client.resetWorldWithSeed(this.serverId, this.seed, this.levelType, this.generateStructures);
                    }
                    if (this.aborted()) {
                        return;
                    }
                    Realms.setScreen((RealmsScreen)new RealmsConfigureWorldScreen(this.lastScreen, this.serverId));
                    return;
                }
                catch (RetryCallException e) {
                    if (this.aborted()) {
                        return;
                    }
                    this.pause(e.delaySeconds);
                    continue;
                }
                catch (RealmsServiceException e) {
                    if (this.aborted()) {
                        return;
                    }
                    LOGGER.error("Couldn't reset world");
                    this.error(e.toString());
                    return;
                }
                catch (Exception e) {
                    if (this.aborted()) {
                        return;
                    }
                    LOGGER.error("Couldn't reset world");
                    this.error(e.toString());
                    return;
                }
            }
        }

        private void pause(int pauseTimeSeconds) {
            try {
                Thread.sleep(pauseTimeSeconds * 1000);
            }
            catch (InterruptedException e) {
                LOGGER.error((Object)e);
            }
        }
    }

    public static class SwitchMinigameTask
    extends LongRunningTask {
        private final long worldId;
        private final WorldTemplate worldTemplate;
        private final RealmsConfigureWorldScreen lastScreen;

        public SwitchMinigameTask(long worldId, WorldTemplate worldTemplate, RealmsConfigureWorldScreen lastScreen) {
            this.worldId = worldId;
            this.worldTemplate = worldTemplate;
            this.lastScreen = lastScreen;
        }

        @Override
        public void run() {
            RealmsClient client = RealmsClient.createRealmsClient();
            String title = RealmsScreen.getLocalizedString((String)"mco.minigame.world.starting.screen.title");
            this.setTitle(title);
            try {
                if (this.aborted()) {
                    return;
                }
                Boolean result = client.putIntoMinigameMode(this.worldId, this.worldTemplate.id);
                if (this.aborted()) {
                    return;
                }
                Realms.setScreen((RealmsScreen)this.lastScreen);
            }
            catch (RealmsServiceException e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't start mini game!");
                this.error(e.toString());
            }
            catch (Exception e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't start mini game!");
                this.error(e.toString());
            }
        }
    }

    public static class SwitchSlotTask
    extends LongRunningTask {
        private final long worldId;
        private final int slot;
        private final RealmsConfigureWorldScreen lastScreen;

        public SwitchSlotTask(long worldId, int slot, RealmsConfigureWorldScreen lastScreen) {
            this.worldId = worldId;
            this.slot = slot;
            this.lastScreen = lastScreen;
        }

        @Override
        public void run() {
            RealmsClient client = RealmsClient.createRealmsClient();
            String title = RealmsScreen.getLocalizedString((String)"mco.minigame.world.slot.screen.title");
            this.setTitle(title);
            try {
                if (this.aborted()) {
                    return;
                }
                Boolean result = client.switchSlot(this.worldId, this.slot);
                if (!result.booleanValue()) {
                    this.error("Couldn't switch slot");
                    return;
                }
                if (this.aborted()) {
                    return;
                }
                Realms.setScreen((RealmsScreen)this.lastScreen);
            }
            catch (RealmsServiceException e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't switch slot!");
                this.error(e.toString());
            }
            catch (Exception e) {
                if (this.aborted()) {
                    return;
                }
                LOGGER.error("Couldn't switch slot!");
                this.error(e.toString());
            }
        }
    }
}

