/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements ae,
Runnable,
vp,
wf {
    private static final Logger k = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private static MinecraftServer l;
    private final bqy m;
    private final wd n = new wd("server", this, MinecraftServer.ay());
    private final File o;
    private final List p = Lists.newArrayList();
    protected final ad b;
    public final uy c = new uy();
    private final rd q;
    private final nq r = new nq();
    private final Random s = new Random();
    private int u = -1;
    public qu[] d;
    private sp v;
    private boolean w = true;
    private boolean x;
    private int y;
    protected final Proxy e;
    public String f;
    public int g;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G = 0;
    public final long[] h = new long[100];
    public long[][] i;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private boolean N;
    private String O = "";
    private String P = "";
    private boolean Q;
    private long R;
    private String S;
    private boolean T;
    private boolean U;
    private final YggdrasilAuthenticationService V;
    private final MinecraftSessionService W;
    private long X = 0L;
    private final GameProfileRepository Y;
    private final sa Z;
    protected final Queue j = Queues.newArrayDeque();
    private Thread aa;
    private long ab = MinecraftServer.ay();

    public MinecraftServer(Proxy proxy, File file) {
        this.e = proxy;
        l = this;
        this.o = null;
        this.q = null;
        this.Z = new sa(this, file);
        this.b = null;
        this.m = null;
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    public MinecraftServer(File file, Proxy proxy, File file2) {
        this.e = proxy;
        l = this;
        this.o = file;
        this.q = new rd(this);
        this.Z = new sa(this, file2);
        this.b = this.h();
        this.m = new bqh(file);
        this.V = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString());
        this.W = this.V.createMinecraftSessionService();
        this.Y = this.V.createProfileRepository();
    }

    protected cl h() {
        return new cl();
    }

    protected abstract boolean i();

    protected void a(String string) {
        if (this.X().b(string)) {
            k.info("Converting map!");
            this.b("menu.convertingLevel");
            this.X().a(string, new pe(this));
        }
    }

    protected synchronized void b(String string) {
        this.S = string;
    }

    public synchronized String j() {
        return this.S;
    }

    protected void a(String string, String string2, long l2, arb arb2, String string3) {
        aqy aqy2;
        this.a(string);
        this.b("menu.loadingLevel");
        this.d = new qu[3];
        this.i = new long[this.d.length][100];
        bqw bqw2 = this.m.a(string, true);
        this.a(this.T(), bqw2);
        bqm bqm2 = bqw2.d();
        if (bqm2 == null) {
            if (this.W()) {
                aqy2 = qk.a;
            } else {
                aqy2 = new aqy(l2, this.m(), this.l(), this.o(), arb2);
                aqy2.a(string3);
                if (this.M) {
                    aqy2.a();
                }
            }
            bqm2 = new bqm(aqy2, string2);
        } else {
            bqm2.a(string2);
            aqy2 = new aqy(bqm2);
        }
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            int n = 0;
            if (i2 == 1) {
                n = -1;
            }
            if (i2 == 2) {
                n = 1;
            }
            if (i2 == 0) {
                this.d[i2] = this.W() ? (qu)new qk(this, bqw2, bqm2, n, this.c).b() : (qu)new qu(this, bqw2, bqm2, n, this.c).b();
                this.d[i2].a(aqy2);
            } else {
                this.d[i2] = (qu)new qm(this, bqw2, n, this.d[0], this.c).b();
            }
            this.d[i2].a(new qq(this, this.d[i2]));
            if (this.S()) continue;
            this.d[i2].P().a(this.m());
        }
        this.v.a(this.d);
        this.a(this.n());
        this.k();
    }

    protected void k() {
        int n = 16;
        int n2 = 4;
        int n3 = 192;
        int n4 = 625;
        int n5 = 0;
        this.b("menu.generatingTerrain");
        int n6 = 0;
        k.info("Preparing start region for level " + n6);
        qu qu2 = this.d[n6];
        dt dt2 = qu2.M();
        long l2 = MinecraftServer.ay();
        for (int i2 = -192; i2 <= 192 && this.u(); i2 += 16) {
            for (int i3 = -192; i3 <= 192 && this.u(); i3 += 16) {
                long l3 = MinecraftServer.ay();
                if (l3 - l2 > 1000L) {
                    this.a_("Preparing spawn area", n5 * 100 / 625);
                    l2 = l3;
                }
                ++n5;
                qu2.b.c(dt2.n() + i2 >> 4, dt2.p() + i3 >> 4);
            }
        }
        this.r();
    }

    protected void a(String string, bqw bqw2) {
        File file = new File(bqw2.b(), "resources.zip");
        if (file.isFile()) {
            this.a_("level://" + string + "/" + file.getName(), "");
        }
    }

    public abstract boolean l();

    public abstract aqz m();

    public abstract vv n();

    public abstract boolean o();

    public abstract int p();

    public abstract boolean q();

    protected void a_(String string, int n) {
        this.f = string;
        this.g = n;
        k.info(string + ": " + n + "%");
    }

    protected void r() {
        this.f = null;
        this.g = 0;
    }

    protected void a(boolean bl2) {
        if (this.N) {
            return;
        }
        for (qu qu2 : this.d) {
            if (qu2 == null) continue;
            if (!bl2) {
                k.info("Saving chunks for level '" + qu2.P().k() + "'/" + qu2.t.k());
            }
            try {
                qu2.a(true, null);
            }
            catch (aqw aqw2) {
                k.warn(aqw2.getMessage());
            }
        }
    }

    public void s() {
        if (this.N) {
            return;
        }
        k.info("Stopping server");
        if (this.ap() != null) {
            this.ap().b();
        }
        if (this.v != null) {
            k.info("Saving players");
            this.v.j();
            this.v.u();
        }
        if (this.d != null) {
            k.info("Saving worlds");
            this.a(false);
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                qu qu2 = this.d[i2];
                qu2.o();
            }
        }
        if (this.n.d()) {
            this.n.e();
        }
    }

    public boolean u() {
        return this.w;
    }

    public void v() {
        this.w = false;
    }

    protected void w() {
        l = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.i()) {
                this.ab = MinecraftServer.ay();
                long l2 = 0L;
                this.r.a(new hz(this.E));
                this.r.a(new nu("1.8.1", 47));
                this.a(this.r);
                while (this.w) {
                    long l3 = MinecraftServer.ay();
                    long l4 = l3 - this.ab;
                    if (l4 > 2000L && this.ab - this.R >= 15000L) {
                        k.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{l4, l4 / 50L});
                        l4 = 2000L;
                        this.R = this.ab;
                    }
                    if (l4 < 0L) {
                        k.warn("Time ran backwards! Did the system time change?");
                        l4 = 0L;
                    }
                    l2 += l4;
                    this.ab = l3;
                    if (this.d[0].f()) {
                        this.z();
                        l2 = 0L;
                    } else {
                        while (l2 > 50L) {
                            l2 -= 50L;
                            this.z();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l2));
                    this.Q = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            k.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof u ? this.b(((u)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File file = new File(new File(this.x(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(file)) {
                k.error("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                k.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.x = true;
                this.s();
            }
            catch (Throwable throwable) {
                k.error("Exception stopping the server", throwable);
            }
            finally {
                this.y();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(nq nq2) {
        File file = this.d("server-icon.png");
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? (char)'\u0001' : '\u0000') != '\u0000', (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf byteBuf2 = Base64.encode((ByteBuf)byteBuf);
                nq2.a("data:image/png;base64," + byteBuf2.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                k.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public File x() {
        return new File(".");
    }

    protected void a(b b2) {
    }

    protected void y() {
    }

    public void z() {
        long l2 = System.nanoTime();
        ++this.y;
        if (this.T) {
            this.T = false;
            this.c.a = true;
            this.c.a();
        }
        this.c.a("root");
        this.A();
        if (l2 - this.X >= 5000000000L) {
            this.X = l2;
            this.r.a(new nr(this.I(), this.H()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.H(), 12)];
            int n = ux.a(this.s, 0, this.H() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = ((qx)this.v.v().get(n + i2)).cd();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.r.b().a(gameProfileArray);
        }
        if (this.y % 900 == 0) {
            this.c.a("save");
            this.v.j();
            this.a(true);
            this.c.b();
        }
        this.c.a("tallying");
        this.h[this.y % 100] = System.nanoTime() - l2;
        this.c.b();
        this.c.a("snooper");
        if (!this.n.d() && this.y > 100) {
            this.n.a();
        }
        if (this.y % 6000 == 0) {
            this.n.b();
        }
        this.c.b();
        this.c.b();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void A() {
        int n;
        this.c.a("jobs");
        Queue queue = this.j;
        synchronized (queue) {
            while (!this.j.isEmpty()) {
                try {
                    ((FutureTask)this.j.poll()).run();
                }
                catch (Throwable throwable) {
                    k.fatal((Object)throwable);
                }
            }
        }
        this.c.c("levels");
        for (n = 0; n < this.d.length; ++n) {
            long l2 = System.nanoTime();
            if (n == 0 || this.B()) {
                qu qu2 = this.d[n];
                this.c.a(qu2.P().k());
                if (this.y % 20 == 0) {
                    this.c.a("timeSync");
                    this.v.a(new lj(qu2.K(), qu2.L(), qu2.Q().b("doDaylightCycle")), qu2.t.q());
                    this.c.b();
                }
                this.c.a("tick");
                try {
                    qu2.c();
                }
                catch (Throwable throwable) {
                    b b2 = b.a(throwable, "Exception ticking world");
                    qu2.a(b2);
                    throw new u(b2);
                }
                try {
                    qu2.i();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    qu2.a(b3);
                    throw new u(b3);
                }
                this.c.b();
                this.c.a("tracker");
                qu2.s().a();
                this.c.b();
                this.c.b();
            }
            this.i[n][this.y % 100] = System.nanoTime() - l2;
        }
        this.c.c("connection");
        this.ap().c();
        this.c.c("players");
        this.v.e();
        this.c.c("tickables");
        for (n = 0; n < this.p.size(); ++n) {
            ((pn)this.p.get(n)).c();
        }
        this.c.b();
    }

    public boolean B() {
        return true;
    }

    public void C() {
        this.aa = new Thread((Runnable)this, "Server thread");
        this.aa.start();
    }

    public File d(String string) {
        return new File(this.x(), string);
    }

    public void f(String string) {
        k.warn(string);
    }

    public qu a(int n) {
        if (n == -1) {
            return this.d[1];
        }
        if (n == 1) {
            return this.d[2];
        }
        return this.d[0];
    }

    public String G() {
        return "1.8.1";
    }

    public int H() {
        return this.v.o();
    }

    public int I() {
        return this.v.p();
    }

    public String[] J() {
        return this.v.f();
    }

    public GameProfile[] K() {
        return this.v.g();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new pg(this));
        if (this.v != null) {
            b2.g().a("Player Count", new ph(this));
        }
        return b2;
    }

    public List a(ae ae2, String string, dt dt2) {
        ArrayList arrayList = Lists.newArrayList();
        if (string.startsWith("/")) {
            boolean bl2 = !(string = string.substring(1)).contains(" ");
            List list = this.b.a(ae2, string, dt2);
            if (list != null) {
                for (String string2 : list) {
                    if (bl2) {
                        arrayList.add("/" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        String[] stringArray = string.split(" ", -1);
        String string3 = stringArray[stringArray.length - 1];
        for (String string4 : this.v.f()) {
            if (!z.a(string3, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer M() {
        return l;
    }

    public boolean N() {
        return this.o != null;
    }

    @Override
    public String e_() {
        return "Server";
    }

    @Override
    public void a(hp hp2) {
        k.info(hp2.c());
    }

    @Override
    public boolean a(int n, String string) {
        return true;
    }

    public ad O() {
        return this.b;
    }

    public KeyPair P() {
        return this.H;
    }

    public String R() {
        return this.I;
    }

    public void i(String string) {
        this.I = string;
    }

    public boolean S() {
        return this.I != null;
    }

    public String T() {
        return this.J;
    }

    public void j(String string) {
        this.J = string;
    }

    public void k(String string) {
        this.K = string;
    }

    public String U() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(vv vv2) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            qu qu2 = this.d[i2];
            if (qu2 == null) continue;
            if (qu2.P().t()) {
                qu2.P().a(vv.d);
                qu2.a(true, true);
                continue;
            }
            if (this.S()) {
                qu2.P().a(vv2);
                qu2.a(qu2.aa() != vv.a, true);
                continue;
            }
            qu2.P().a(vv2);
            qu2.a(this.V(), this.A);
        }
    }

    protected boolean V() {
        return true;
    }

    public boolean W() {
        return this.L;
    }

    public void b(boolean bl2) {
        this.L = bl2;
    }

    public void c(boolean bl2) {
        this.M = bl2;
    }

    public bqy X() {
        return this.m;
    }

    public void Z() {
        this.N = true;
        this.X().d();
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            qu qu2 = this.d[i2];
            if (qu2 == null) continue;
            qu2.o();
        }
        this.X().e(this.d[0].O().g());
        this.v();
    }

    public String aa() {
        return this.O;
    }

    public String ab() {
        return this.P;
    }

    public void a_(String string, String string2) {
        this.O = string;
        this.P = string2;
    }

    @Override
    public void a(wd wd2) {
        wd2.a("whitelist_enabled", false);
        wd2.a("whitelist_count", 0);
        if (this.v != null) {
            wd2.a("players_current", this.H());
            wd2.a("players_max", this.I());
            wd2.a("players_seen", this.v.q().length);
        }
        wd2.a("uses_auth", this.z);
        wd2.a("gui_state", this.ar() ? "enabled" : "disabled");
        wd2.a("run_time", (MinecraftServer.ay() - wd2.g()) / 60L * 1000L);
        wd2.a("avg_tick_ms", (int)(ux.a(this.h) * 1.0E-6));
        int n = 0;
        if (this.d != null) {
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                if (this.d[i2] == null) continue;
                qu qu2 = this.d[i2];
                bqm bqm2 = qu2.P();
                wd2.a("world[" + n + "][dimension]", qu2.t.q());
                wd2.a("world[" + n + "][mode]", (Object)bqm2.r());
                wd2.a("world[" + n + "][difficulty]", (Object)qu2.aa());
                wd2.a("world[" + n + "][hardcore]", bqm2.t());
                wd2.a("world[" + n + "][generator_name]", bqm2.u().a());
                wd2.a("world[" + n + "][generator_version]", bqm2.u().d());
                wd2.a("world[" + n + "][height]", this.F);
                wd2.a("world[" + n + "][chunks_loaded]", qu2.N().g());
                ++n;
            }
        }
        wd2.a("worlds", n);
    }

    @Override
    public void b(wd wd2) {
        wd2.b("singleplayer", this.S());
        wd2.b("server_brand", this.getServerModName());
        wd2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        wd2.b("dedicated", this.ad());
    }

    @Override
    public boolean ac() {
        return true;
    }

    public abstract boolean ad();

    public boolean ae() {
        return this.z;
    }

    public void d(boolean bl2) {
        this.z = bl2;
    }

    public boolean af() {
        return this.A;
    }

    public void e(boolean bl2) {
        this.A = bl2;
    }

    public boolean ag() {
        return this.B;
    }

    public abstract boolean ah();

    public void f(boolean bl2) {
        this.B = bl2;
    }

    public boolean ai() {
        return this.C;
    }

    public void g(boolean bl2) {
        this.C = bl2;
    }

    public boolean aj() {
        return this.D;
    }

    public void h(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean ak();

    public String al() {
        return this.E;
    }

    public void l(String string) {
        this.E = string;
    }

    public int am() {
        return this.F;
    }

    public void c(int n) {
        this.F = n;
    }

    public boolean an() {
        return this.x;
    }

    public sp ao() {
        return this.v;
    }

    public void a(sp sp2) {
        this.v = sp2;
    }

    public void a(aqz aqz2) {
        for (int i2 = 0; i2 < this.d.length; ++i2) {
            MinecraftServer.M().d[i2].P().a(aqz2);
        }
    }

    public rd ap() {
        return this.q;
    }

    public boolean aq() {
        return this.Q;
    }

    public boolean ar() {
        return false;
    }

    public abstract String a(aqz var1, boolean var2);

    public int as() {
        return this.y;
    }

    public void at() {
        this.T = true;
    }

    public wd au() {
        return this.n;
    }

    @Override
    public dt c() {
        return dt.a;
    }

    @Override
    public bru d() {
        return new bru(0.0, 0.0, 0.0);
    }

    @Override
    public aqr e() {
        return this.d[0];
    }

    @Override
    public wx f() {
        return null;
    }

    public int av() {
        return 16;
    }

    public boolean a(aqr aqr2, dt dt2, aha aha2) {
        return false;
    }

    public boolean aw() {
        return this.U;
    }

    public Proxy ax() {
        return this.e;
    }

    public static long ay() {
        return System.currentTimeMillis();
    }

    public int az() {
        return this.G;
    }

    public void d(int n) {
        this.G = n;
    }

    @Override
    public hp f_() {
        return new hz(this.e_());
    }

    public boolean aA() {
        return true;
    }

    public MinecraftSessionService aC() {
        return this.W;
    }

    public GameProfileRepository aD() {
        return this.Y;
    }

    public sa aE() {
        return this.Z;
    }

    public nq aF() {
        return this.r;
    }

    public void aG() {
        this.X = 0L;
    }

    public wx a(UUID uUID) {
        for (qu qu2 : this.d) {
            wx wx2;
            if (qu2 == null || (wx2 = qu2.a(uUID)) == null) continue;
            return wx2;
        }
        return null;
    }

    @Override
    public boolean u_() {
        return MinecraftServer.M().d[0].Q().b("sendCommandFeedback");
    }

    @Override
    public void a(ag ag2, int n) {
    }

    public int aH() {
        return 29999984;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture a(Callable callable) {
        Validate.notNull((Object)callable);
        if (!this.aI() && !this.an()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create((Callable)callable);
            Queue queue = this.j;
            synchronized (queue) {
                this.j.add(listenableFutureTask);
            }
            return listenableFutureTask;
        }
        try {
            return Futures.immediateFuture(callable.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean aI() {
        return Thread.currentThread() == this.aa;
    }

    public int aJ() {
        return 256;
    }

    public static /* synthetic */ Logger aM() {
        return k;
    }

    public static /* synthetic */ sp a(MinecraftServer minecraftServer) {
        return minecraftServer.v;
    }
}

