/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Charsets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.base64.Base64;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements ac,
Runnable,
qh {
    private static final Logger h = LogManager.getLogger();
    private static MinecraftServer i;
    private final ayb j;
    private final qf k = new qf("server", this, MinecraftServer.aq());
    private final File l;
    private final List m = new ArrayList();
    private final ab n;
    public final pf a = new pf();
    private final nb o;
    private final jy p = new jy();
    private final Random q = new Random();
    private int s = -1;
    public ms[] b;
    private lm t;
    private boolean u = true;
    private boolean v;
    private int w;
    protected final Proxy c;
    public String d;
    public int e;
    private boolean x;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private String C;
    private int D;
    private int E = 0;
    public final long[] f = new long[100];
    public long[][] g;
    private KeyPair F;
    private String G;
    private String H;
    private String I;
    private boolean J;
    private boolean K;
    private boolean L;
    private String M = "";
    private boolean N;
    private long O;
    private String P;
    private boolean Q;
    private boolean R;
    private final MinecraftSessionService S;
    private long T = 0L;

    public MinecraftServer(File file, Proxy proxy) {
        i = this;
        this.c = proxy;
        this.l = file;
        this.o = new nb(this);
        this.n = new bl();
        this.j = new axk(file);
        this.S = new YggdrasilAuthenticationService(proxy, UUID.randomUUID().toString()).createMinecraftSessionService();
    }

    protected abstract boolean e();

    protected void a(String string) {
        if (this.R().b(string)) {
            h.info("Converting map!");
            this.b("menu.convertingLevel");
            this.R().a(string, new lf(this));
        }
    }

    protected synchronized void b(String string) {
        this.P = string;
    }

    public synchronized String f() {
        return this.P;
    }

    protected void a(String string, String string2, long l2, agj agj2, String string3) {
        agg agg2;
        this.a(string);
        this.b("menu.loadingLevel");
        this.b = new ms[3];
        this.g = new long[this.b.length][100];
        axz axz2 = this.j.a(string, true);
        axp axp2 = axz2.d();
        if (axp2 == null) {
            agg2 = new agg(l2, this.i(), this.h(), this.k(), agj2);
            agg2.a(string3);
        } else {
            agg2 = new agg(axp2);
        }
        if (this.K) {
            agg2.a();
        }
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            int n2 = 0;
            if (i2 == 1) {
                n2 = -1;
            }
            if (i2 == 2) {
                n2 = 1;
            }
            this.b[i2] = i2 == 0 ? (this.Q() ? new mj(this, axz2, string2, n2, this.a) : new ms(this, axz2, string2, n2, agg2, this.a)) : new ml(this, axz2, string2, n2, agg2, this.b[0], this.a);
            this.b[i2].a(new mo(this, this.b[i2]));
            if (!this.M()) {
                this.b[i2].N().a(this.i());
            }
            this.t.a(this.b);
        }
        this.a(this.j());
        this.g();
    }

    protected void g() {
        int n2 = 16;
        int n3 = 4;
        int n4 = 192;
        int n5 = 625;
        int n6 = 0;
        this.b("menu.generatingTerrain");
        int n7 = 0;
        h.info("Preparing start region for level " + n7);
        ms ms2 = this.b[n7];
        r r2 = ms2.K();
        long l2 = MinecraftServer.aq();
        for (int i2 = -192; i2 <= 192 && this.q(); i2 += 16) {
            for (int i3 = -192; i3 <= 192 && this.q(); i3 += 16) {
                long l3 = MinecraftServer.aq();
                if (l3 - l2 > 1000L) {
                    this.a_("Preparing spawn area", n6 * 100 / 625);
                    l2 = l3;
                }
                ++n6;
                ms2.b.c(r2.a + i2 >> 4, r2.c + i3 >> 4);
            }
        }
        this.n();
    }

    public abstract boolean h();

    public abstract agh i();

    public abstract qa j();

    public abstract boolean k();

    public abstract int l();

    public abstract boolean m();

    protected void a_(String string, int n2) {
        this.d = string;
        this.e = n2;
        h.info(string + ": " + n2 + "%");
    }

    protected void n() {
        this.d = null;
        this.e = 0;
    }

    protected void a(boolean bl2) {
        if (this.L) {
            return;
        }
        for (ms ms2 : this.b) {
            if (ms2 == null) continue;
            if (!bl2) {
                h.info("Saving chunks for level '" + ms2.N().k() + "'/" + ms2.t.l());
            }
            try {
                ms2.a(true, null);
            }
            catch (agd agd2) {
                h.warn(agd2.getMessage());
            }
        }
    }

    public void o() {
        if (this.L) {
            return;
        }
        h.info("Stopping server");
        if (this.ah() != null) {
            this.ah().b();
        }
        if (this.t != null) {
            h.info("Saving players");
            this.t.g();
            this.t.r();
        }
        h.info("Saving worlds");
        this.a(false);
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            ms ms2 = this.b[i2];
            ms2.n();
        }
        if (this.k.d()) {
            this.k.e();
        }
    }

    public boolean q() {
        return this.u;
    }

    public void r() {
        this.u = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.e()) {
                long l2 = MinecraftServer.aq();
                long l3 = 0L;
                this.p.a(new fn(this.C));
                this.p.a(new kc("1.7.5", 4));
                this.a(this.p);
                while (this.u) {
                    long l4 = MinecraftServer.aq();
                    long l5 = l4 - l2;
                    if (l5 > 2000L && l2 - this.O >= 15000L) {
                        h.warn("Can't keep up! Did the system time change, or is the server overloaded? Running {}ms behind, skipping {} tick(s)", new Object[]{l5, l5 / 50L});
                        l5 = 2000L;
                        this.O = l2;
                    }
                    if (l5 < 0L) {
                        h.warn("Time ran backwards! Did the system time change?");
                        l5 = 0L;
                    }
                    l3 += l5;
                    l2 = l4;
                    if (this.b[0].e()) {
                        this.u();
                        l3 = 0L;
                    } else {
                        while (l3 > 50L) {
                            l3 -= 50L;
                            this.u();
                        }
                    }
                    Thread.sleep(Math.max(1L, 50L - l3));
                    this.N = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            h.error("Encountered an unexpected exception", throwable);
            b b2 = null;
            b2 = throwable instanceof s ? this.b(((s)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File file = new File(new File(this.s(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(file)) {
                h.error("This crash report has been saved to: " + file.getAbsolutePath());
            } else {
                h.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.o();
                this.v = true;
            }
            catch (Throwable throwable) {
                h.error("Exception stopping the server", throwable);
            }
            finally {
                this.t();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(jy jy2) {
        File file = this.d("server-icon.png");
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuf byteBuf2 = Base64.encode((ByteBuf)byteBuf);
                jy2.a("data:image/png;base64," + byteBuf2.toString(Charsets.UTF_8));
            }
            catch (Exception exception) {
                h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    protected File s() {
        return new File(".");
    }

    protected void a(b b2) {
    }

    protected void t() {
    }

    public void u() {
        long l2 = System.nanoTime();
        ++this.w;
        if (this.Q) {
            this.Q = false;
            this.a.a = true;
            this.a.a();
        }
        this.a.a("root");
        this.v();
        if (l2 - this.T >= 5000000000L) {
            this.T = l2;
            this.p.a(new jz(this.D(), this.C()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.C(), 12)];
            int n2 = pe.a(this.q, 0, this.C() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = ((mv)this.t.a.get(n2 + i2)).bI();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.p.b().a(gameProfileArray);
        }
        if (this.w % 900 == 0) {
            this.a.a("save");
            this.t.g();
            this.a(true);
            this.a.b();
        }
        this.a.a("tallying");
        this.f[this.w % 100] = System.nanoTime() - l2;
        this.a.b();
        this.a.a("snooper");
        if (!this.k.d() && this.w > 100) {
            this.k.a();
        }
        if (this.w % 6000 == 0) {
            this.k.b();
        }
        this.a.b();
        this.a.b();
    }

    public void v() {
        int n2;
        this.a.a("levels");
        for (n2 = 0; n2 < this.b.length; ++n2) {
            long l2 = System.nanoTime();
            if (n2 == 0 || this.w()) {
                ms ms2 = this.b[n2];
                this.a.a(ms2.N().k());
                this.a.a("pools");
                this.a.b();
                if (this.w % 20 == 0) {
                    this.a.a("timeSync");
                    this.t.a(new id(ms2.I(), ms2.J(), ms2.O().b("doDaylightCycle")), ms2.t.i);
                    this.a.b();
                }
                this.a.a("tick");
                try {
                    ms2.b();
                }
                catch (Throwable throwable) {
                    b b2 = b.a(throwable, "Exception ticking world");
                    ms2.a(b2);
                    throw new s(b2);
                }
                try {
                    ms2.h();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    ms2.a(b3);
                    throw new s(b3);
                }
                this.a.b();
                this.a.a("tracker");
                ms2.r().a();
                this.a.b();
                this.a.b();
            }
            this.g[n2][this.w % 100] = System.nanoTime() - l2;
        }
        this.a.c("connection");
        this.ah().c();
        this.a.c("players");
        this.t.b();
        this.a.c("tickables");
        for (n2 = 0; n2 < this.m.size(); ++n2) {
            ((lq)this.m.get(n2)).a();
        }
        this.a.b();
    }

    public boolean w() {
        return true;
    }

    public void x() {
        new lh(this, "Server thread").start();
    }

    public File d(String string) {
        return new File(this.s(), string);
    }

    public void f(String string) {
        h.warn(string);
    }

    public ms a(int n2) {
        if (n2 == -1) {
            return this.b[1];
        }
        if (n2 == 1) {
            return this.b[2];
        }
        return this.b[0];
    }

    public String B() {
        return "1.7.5";
    }

    public int C() {
        return this.t.k();
    }

    public int D() {
        return this.t.l();
    }

    public String[] E() {
        return this.t.d();
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", new li(this));
        if (this.b != null && this.b.length > 0 && this.b[0] != null) {
            b2.g().a("Vec3 Pool Size", new lj(this));
        }
        if (this.t != null) {
            b2.g().a("Player Count", new lk(this));
        }
        return b2;
    }

    public List a(ac ac2, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string.startsWith("/")) {
            boolean bl2 = !(string = string.substring(1)).contains(" ");
            List list = this.n.b(ac2, string);
            if (list != null) {
                for (String string2 : list) {
                    if (bl2) {
                        arrayList.add("/" + string2);
                        continue;
                    }
                    arrayList.add(string2);
                }
            }
            return arrayList;
        }
        String[] stringArray = string.split(" ", -1);
        String string3 = stringArray[stringArray.length - 1];
        for (String string4 : this.t.d()) {
            if (!y.a(string3, string4)) continue;
            arrayList.add(string4);
        }
        return arrayList;
    }

    public static MinecraftServer H() {
        return i;
    }

    @Override
    public String b_() {
        return "Server";
    }

    @Override
    public void a(fg fg2) {
        h.info(fg2.c());
    }

    @Override
    public boolean a(int n2, String string) {
        return true;
    }

    public ab I() {
        return this.n;
    }

    public KeyPair J() {
        return this.F;
    }

    public String L() {
        return this.G;
    }

    public void j(String string) {
        this.G = string;
    }

    public boolean M() {
        return this.G != null;
    }

    public String N() {
        return this.H;
    }

    public void k(String string) {
        this.H = string;
    }

    public void l(String string) {
        this.I = string;
    }

    public String O() {
        return this.I;
    }

    public void a(KeyPair keyPair) {
        this.F = keyPair;
    }

    public void a(qa qa2) {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            ms ms2 = this.b[i2];
            if (ms2 == null) continue;
            if (ms2.N().t()) {
                ms2.r = qa.d;
                ms2.a(true, true);
                continue;
            }
            if (this.M()) {
                ms2.r = qa2;
                ms2.a(ms2.r != qa.a, true);
                continue;
            }
            ms2.r = qa2;
            ms2.a(this.P(), this.y);
        }
    }

    protected boolean P() {
        return true;
    }

    public boolean Q() {
        return this.J;
    }

    public void b(boolean bl2) {
        this.J = bl2;
    }

    public void c(boolean bl2) {
        this.K = bl2;
    }

    public ayb R() {
        return this.j;
    }

    public void T() {
        this.L = true;
        this.R().d();
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            ms ms2 = this.b[i2];
            if (ms2 == null) continue;
            ms2.n();
        }
        this.R().e(this.b[0].M().g());
        this.r();
    }

    public String U() {
        return this.M;
    }

    @Override
    public void a(qf qf2) {
        qf2.a("whitelist_enabled", false);
        qf2.a("whitelist_count", 0);
        qf2.a("players_current", this.C());
        qf2.a("players_max", this.D());
        qf2.a("players_seen", this.t.m().length);
        qf2.a("uses_auth", this.x);
        qf2.a("gui_state", this.aj() ? "enabled" : "disabled");
        qf2.a("run_time", (MinecraftServer.aq() - qf2.g()) / 60L * 1000L);
        qf2.a("avg_tick_ms", (int)(pe.a(this.f) * 1.0E-6));
        int n2 = 0;
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            if (this.b[i2] == null) continue;
            ms ms2 = this.b[i2];
            axp axp2 = ms2.N();
            qf2.a("world[" + n2 + "][dimension]", ms2.t.i);
            qf2.a("world[" + n2 + "][mode]", (Object)axp2.r());
            qf2.a("world[" + n2 + "][difficulty]", (Object)ms2.r);
            qf2.a("world[" + n2 + "][hardcore]", axp2.t());
            qf2.a("world[" + n2 + "][generator_name]", axp2.u().a());
            qf2.a("world[" + n2 + "][generator_version]", axp2.u().d());
            qf2.a("world[" + n2 + "][height]", this.D);
            qf2.a("world[" + n2 + "][chunks_loaded]", ms2.L().g());
            ++n2;
        }
        qf2.a("worlds", n2);
    }

    @Override
    public void b(qf qf2) {
        qf2.b("singleplayer", this.M());
        qf2.b("server_brand", this.getServerModName());
        qf2.b("gui_supported", GraphicsEnvironment.isHeadless() ? "headless" : "supported");
        qf2.b("dedicated", this.W());
    }

    @Override
    public boolean V() {
        return true;
    }

    public abstract boolean W();

    public boolean X() {
        return this.x;
    }

    public void d(boolean bl2) {
        this.x = bl2;
    }

    public boolean Y() {
        return this.y;
    }

    public void e(boolean bl2) {
        this.y = bl2;
    }

    public boolean Z() {
        return this.z;
    }

    public void f(boolean bl2) {
        this.z = bl2;
    }

    public boolean aa() {
        return this.A;
    }

    public void g(boolean bl2) {
        this.A = bl2;
    }

    public boolean ab() {
        return this.B;
    }

    public void h(boolean bl2) {
        this.B = bl2;
    }

    public abstract boolean ac();

    public String ad() {
        return this.C;
    }

    public void n(String string) {
        this.C = string;
    }

    public int ae() {
        return this.D;
    }

    public void c(int n2) {
        this.D = n2;
    }

    public lm ag() {
        return this.t;
    }

    public void a(lm lm2) {
        this.t = lm2;
    }

    public void a(agh agh2) {
        for (int i2 = 0; i2 < this.b.length; ++i2) {
            MinecraftServer.H().b[i2].N().a(agh2);
        }
    }

    public nb ah() {
        return this.o;
    }

    public boolean ai() {
        return this.N;
    }

    public boolean aj() {
        return false;
    }

    public abstract String a(agh var1, boolean var2);

    public int ak() {
        return this.w;
    }

    public void al() {
        this.Q = true;
    }

    public qf am() {
        return this.k;
    }

    @Override
    public r f_() {
        return new r(0, 0, 0);
    }

    @Override
    public afy d() {
        return this.b[0];
    }

    public int an() {
        return 16;
    }

    public boolean a(afy afy2, int n2, int n3, int n4, xw xw2) {
        return false;
    }

    public boolean ao() {
        return this.R;
    }

    public Proxy ap() {
        return this.c;
    }

    public static long aq() {
        return System.currentTimeMillis();
    }

    public int ar() {
        return this.E;
    }

    public void d(int n2) {
        this.E = n2;
    }

    @Override
    public fg c_() {
        return new fn(this.b_());
    }

    public boolean as() {
        return true;
    }

    public MinecraftSessionService at() {
        return this.S;
    }

    public jy au() {
        return this.p;
    }

    public void av() {
        this.T = 0L;
    }

    public static /* synthetic */ Logger aw() {
        return h;
    }

    public static /* synthetic */ lm a(MinecraftServer minecraftServer) {
        return minecraftServer.t;
    }
}

