/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.FileStore;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributeView;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.FileStoreAttributeView;
import java.nio.file.attribute.UserDefinedFileAttributeView;
import sun.nio.fs.WindowsException;
import sun.nio.fs.WindowsFileAttributes;
import sun.nio.fs.WindowsLinkSupport;
import sun.nio.fs.WindowsNativeDispatcher;
import sun.nio.fs.WindowsPath;

class WindowsFileStore
extends FileStore {
    private final String root;
    private final WindowsNativeDispatcher.VolumeInformation volInfo;
    private final int volType;
    private final String displayName;

    private WindowsFileStore(String string) throws WindowsException {
        assert (string.charAt(string.length() - 1) == '\\');
        this.root = string;
        this.volInfo = WindowsNativeDispatcher.GetVolumeInformation(string);
        this.volType = WindowsNativeDispatcher.GetDriveType(string);
        String string2 = this.volInfo.volumeName();
        this.displayName = string2.length() > 0 ? string2 : (this.volType == 2 ? "Removable Disk" : "");
    }

    static WindowsFileStore create(String string, boolean bl) throws IOException {
        try {
            return new WindowsFileStore(string);
        }
        catch (WindowsException windowsException) {
            if (bl && windowsException.lastError() == 21) {
                return null;
            }
            windowsException.rethrowAsIOException(string);
            return null;
        }
    }

    static WindowsFileStore create(WindowsPath windowsPath) throws IOException {
        try {
            String string;
            if (windowsPath.getFileSystem().supportsLinks()) {
                string = WindowsLinkSupport.getFinalPath(windowsPath, true);
            } else {
                WindowsFileAttributes.get(windowsPath, true);
                string = windowsPath.getPathForWin32Calls();
            }
            String string2 = WindowsNativeDispatcher.GetVolumePathName(string);
            return new WindowsFileStore(string2);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(windowsPath);
            return null;
        }
    }

    WindowsNativeDispatcher.VolumeInformation volumeInformation() {
        return this.volInfo;
    }

    int volumeType() {
        return this.volType;
    }

    @Override
    public String name() {
        return this.volInfo.volumeName();
    }

    @Override
    public String type() {
        return this.volInfo.fileSystemName();
    }

    @Override
    public boolean isReadOnly() {
        return (this.volInfo.flags() & 0x80000) != 0;
    }

    private WindowsNativeDispatcher.DiskFreeSpace readDiskFreeSpace() throws IOException {
        try {
            return WindowsNativeDispatcher.GetDiskFreeSpaceEx(this.root);
        }
        catch (WindowsException windowsException) {
            windowsException.rethrowAsIOException(this.root);
            return null;
        }
    }

    @Override
    public long getTotalSpace() throws IOException {
        return this.readDiskFreeSpace().totalNumberOfBytes();
    }

    @Override
    public long getUsableSpace() throws IOException {
        return this.readDiskFreeSpace().freeBytesAvailable();
    }

    @Override
    public long getUnallocatedSpace() throws IOException {
        return this.readDiskFreeSpace().freeBytesAvailable();
    }

    @Override
    public <V extends FileStoreAttributeView> V getFileStoreAttributeView(Class<V> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        return (V)((FileStoreAttributeView)null);
    }

    @Override
    public Object getAttribute(String string) throws IOException {
        if (string.equals("totalSpace")) {
            return this.getTotalSpace();
        }
        if (string.equals("usableSpace")) {
            return this.getUsableSpace();
        }
        if (string.equals("unallocatedSpace")) {
            return this.getUnallocatedSpace();
        }
        if (string.equals("volume:vsn")) {
            return this.volInfo.volumeSerialNumber();
        }
        if (string.equals("volume:isRemovable")) {
            return this.volType == 2;
        }
        if (string.equals("volume:isCdrom")) {
            return this.volType == 5;
        }
        throw new UnsupportedOperationException("'" + string + "' not recognized");
    }

    @Override
    public boolean supportsFileAttributeView(Class<? extends FileAttributeView> clazz) {
        if (clazz == null) {
            throw new NullPointerException();
        }
        if (clazz == BasicFileAttributeView.class || clazz == DosFileAttributeView.class) {
            return true;
        }
        if (clazz == AclFileAttributeView.class || clazz == FileOwnerAttributeView.class) {
            return (this.volInfo.flags() & 8) != 0;
        }
        if (clazz == UserDefinedFileAttributeView.class) {
            return (this.volInfo.flags() & 0x40000) != 0;
        }
        return false;
    }

    @Override
    public boolean supportsFileAttributeView(String string) {
        if (string.equals("basic") || string.equals("dos")) {
            return true;
        }
        if (string.equals("acl")) {
            return this.supportsFileAttributeView(AclFileAttributeView.class);
        }
        if (string.equals("owner")) {
            return this.supportsFileAttributeView(FileOwnerAttributeView.class);
        }
        if (string.equals("user")) {
            return this.supportsFileAttributeView(UserDefinedFileAttributeView.class);
        }
        return false;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof WindowsFileStore)) {
            return false;
        }
        WindowsFileStore windowsFileStore = (WindowsFileStore)object;
        return this.root.equals(windowsFileStore.root);
    }

    public int hashCode() {
        return this.root.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.displayName);
        if (stringBuilder.length() > 0) {
            stringBuilder.append(" ");
        }
        stringBuilder.append("(");
        stringBuilder.append(this.root.subSequence(0, this.root.length() - 1));
        stringBuilder.append(")");
        return stringBuilder.toString();
    }
}

