/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.collect.ImmutableSet;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import com.mojang.serialization.Lifecycle;
import java.awt.GraphicsEnvironment;
import java.io.File;
import java.io.OutputStream;
import java.net.Proxy;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BooleanSupplier;
import joptsimple.AbstractOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NonOptionArgumentSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Main {
    private static final Logger a = LogManager.getLogger();

    public static void main(String[] stringArray) {
        OptionParser optionParser = new OptionParser();
        OptionSpecBuilder \u26032 = optionParser.accepts("nogui");
        OptionSpecBuilder \u26033 = optionParser.accepts("initSettings", "Initializes 'server.properties' and 'eula.txt', then quits");
        OptionSpecBuilder \u26034 = optionParser.accepts("demo");
        OptionSpecBuilder \u26035 = optionParser.accepts("bonusChest");
        OptionSpecBuilder \u26036 = optionParser.accepts("forceUpgrade");
        OptionSpecBuilder \u26037 = optionParser.accepts("eraseCache");
        OptionSpecBuilder \u26038 = optionParser.accepts("safeMode", "Loads level with vanilla datapack only");
        AbstractOptionSpec \u26039 = optionParser.accepts("help").forHelp();
        ArgumentAcceptingOptionSpec \u260310 = optionParser.accepts("singleplayer").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260311 = optionParser.accepts("universe").withRequiredArg().defaultsTo((Object)".", (Object[])new String[0]);
        ArgumentAcceptingOptionSpec \u260312 = optionParser.accepts("world").withRequiredArg();
        ArgumentAcceptingOptionSpec \u260313 = optionParser.accepts("port").withRequiredArg().ofType(Integer.class).defaultsTo((Object)-1, (Object[])new Integer[0]);
        ArgumentAcceptingOptionSpec \u260314 = optionParser.accepts("serverId").withRequiredArg();
        NonOptionArgumentSpec \u260315 = optionParser.nonOptions();
        try {
            Object \u260337;
            Object \u260335;
            OptionSet optionSet = optionParser.parse(stringArray);
            if (optionSet.has((OptionSpec)\u26039)) {
                optionParser.printHelpOn((OutputStream)System.err);
                return;
            }
            l.h();
            vm.a();
            vm.c();
            x.l();
            gn.b \u260316 = gn.b();
            Path \u260317 = Paths.get("server.properties", new String[0]);
            zi \u260318 = new zi(\u260316, \u260317);
            \u260318.b();
            Path \u260319 = Paths.get("eula.txt", new String[0]);
            vr \u260320 = new vr(\u260319);
            if (optionSet.has((OptionSpec)\u26033)) {
                a.info("Initialized '{}' and '{}'", (Object)\u260317.toAbsolutePath(), (Object)\u260319.toAbsolutePath());
                return;
            }
            if (!\u260320.a()) {
                a.info("You need to agree to the EULA in order to run the server. Go to eula.txt for more info.");
                return;
            }
            File \u260321 = new File((String)optionSet.valueOf((OptionSpec)\u260311));
            YggdrasilAuthenticationService \u260322 = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            MinecraftSessionService \u260323 = \u260322.createMinecraftSessionService();
            GameProfileRepository \u260324 = \u260322.createProfileRepository();
            aco \u260325 = new aco(\u260324, new File(\u260321, MinecraftServer.b.getName()));
            String \u260326 = (String)Optional.ofNullable(optionSet.valueOf((OptionSpec)\u260312)).orElse(\u260318.a().n);
            cyd \u260327 = cyd.a(\u260321.toPath());
            cyd.a \u260328 = \u260327.c(\u260326);
            MinecraftServer.a(\u260328);
            brh \u260329 = \u260328.e();
            boolean \u260330 = optionSet.has((OptionSpec)\u26038);
            if (\u260330) {
                a.warn("Safe mode active, only vanilla datapack will be loaded");
            }
            abu \u260331 = new abu(new abx(), new abr(\u260328.a(cyb.g).toFile(), abv.c));
            brh \u260332 = MinecraftServer.a(\u260331, \u260329 == null ? brh.a : \u260329, \u260330);
            CompletableFuture<vz> \u260333 = vz.a(\u260331.f(), dc.a.b, \u260318.a().G, x.f(), Runnable::run);
            try {
                vz vz2 = \u260333.get();
            }
            catch (Exception exception) {
                a.warn("Failed to load datapacks, can't proceed with server load. You can either fix your datapacks or reset to vanilla with --safeMode", (Throwable)exception);
                \u260331.close();
                return;
            }
            vz2.i();
            vh<mt> vh2 = vh.a(mo.a, vz2.h(), \u260316);
            cyk \u260334 = \u260328.a(vh2, \u260332);
            if (\u260334 == null) {
                if (optionSet.has((OptionSpec)\u26034)) {
                    \u260335 = MinecraftServer.c;
                    \u260336 = cht.a(\u260316);
                } else {
                    \u260337 = \u260318.a();
                    \u260335 = new brx(((zh)\u260337).n, ((zh)\u260337).m, ((zh)\u260337).y, ((zh)\u260337).l, false, new brq(), \u260332);
                    \u260336 = optionSet.has((OptionSpec)\u26035) ? ((zh)\u260337).V.j() : ((zh)\u260337).V;
                }
                \u260334 = new cyi((brx)\u260335, (cht)\u260336, Lifecycle.stable());
            }
            if (optionSet.has((OptionSpec)\u26036)) {
                Main.a(\u260328, afy.a(), optionSet.has((OptionSpec)\u26037), () -> true, \u260334.A().f());
            }
            \u260328.a(\u260316, \u260334);
            \u260335 = \u260334;
            Object \u260336 = MinecraftServer.a(arg_0 -> Main.a(\u260316, \u260328, \u260331, vz2, (cyk)\u260335, \u260318, \u260323, \u260324, \u260325, optionSet, (OptionSpec)\u260310, (OptionSpec)\u260313, (OptionSpec)\u26034, (OptionSpec)\u260314, (OptionSpec)\u26032, (OptionSpec)\u260315, arg_0));
            \u260337 = new Thread("Server Shutdown Thread", (zg)\u260336){
                final /* synthetic */ zg a;
                {
                    this.a = zg2;
                    super(string);
                }

                @Override
                public void run() {
                    this.a.a(true);
                }
            };
            ((Thread)\u260337).setUncaughtExceptionHandler(new o(a));
            Runtime.getRuntime().addShutdownHook((Thread)\u260337);
        }
        catch (Exception exception) {
            a.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    private static void a(cyd.a a2, DataFixer dataFixer, boolean bl2, BooleanSupplier booleanSupplier2, ImmutableSet<vj<bru>> immutableSet) {
        a.info("Forcing world upgrade!");
        aof aof2 = new aof(a2, dataFixer, immutableSet, bl2);
        nr \u26032 = null;
        while (!aof2.b()) {
            BooleanSupplier booleanSupplier2;
            nr nr2 = aof2.h();
            if (\u26032 != nr2) {
                \u26032 = nr2;
                a.info(aof2.h().getString());
            }
            if ((\u2603 = aof2.e()) > 0) {
                int n2 = aof2.f() + aof2.g();
                a.info("{}% completed ({} / {} chunks)...", (Object)afj.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
            }
            if (!booleanSupplier2.getAsBoolean()) {
                aof2.a();
                continue;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private static /* synthetic */ zg a(gn.b b2, cyd.a a2, abu abu2, vz vz2, cyk cyk2, zi zi2, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, aco aco2, OptionSet optionSet, OptionSpec optionSpec, OptionSpec optionSpec2, OptionSpec optionSpec3, OptionSpec optionSpec4, OptionSpec optionSpec5, OptionSpec optionSpec6, Thread thread) {
        zg zg2 = new zg(thread, b2, a2, abu2, vz2, cyk2, zi2, afy.a(), minecraftSessionService, gameProfileRepository, aco2, aar::new);
        zg2.d((String)optionSet.valueOf(optionSpec));
        zg2.a((Integer)optionSet.valueOf(optionSpec2));
        zg2.c(optionSet.has(optionSpec3));
        zg2.b((String)optionSet.valueOf(optionSpec4));
        boolean bl2 = \u2603 = !optionSet.has(optionSpec5) && !optionSet.valuesOf(optionSpec6).contains("nogui");
        if (\u2603 && !GraphicsEnvironment.isHeadless()) {
            zg2.bc();
        }
        return zg2;
    }
}

