/*
 * Decompiled with CFR 0.152.
 */
package com.mojang.realmsclient.gui.screens;

import com.mojang.realmsclient.dto.RealmsServer;
import com.mojang.realmsclient.dto.RealmsWorldOptions;
import com.mojang.realmsclient.gui.RealmsConstants;
import com.mojang.realmsclient.gui.screens.RealmsConfigureWorldScreen;
import net.minecraft.realms.Realms;
import net.minecraft.realms.RealmsButton;
import net.minecraft.realms.RealmsEditBox;
import net.minecraft.realms.RealmsGuiEventListener;
import net.minecraft.realms.RealmsScreen;
import net.minecraft.realms.RealmsSliderButton;

public class RealmsSlotOptionsScreen
extends RealmsScreen {
    private static final int BUTTON_CANCEL_ID = 0;
    private static final int BUTTON_DONE_ID = 1;
    private static final int BUTTON_DIFFICULTY_ID = 2;
    private static final int BUTTON_GAMEMODE_ID = 3;
    private static final int BUTTON_PVP_ID = 4;
    private static final int BUTTON_SPAWN_ANIMALS_ID = 5;
    private static final int BUTTON_SPAWN_MONSTERS_ID = 6;
    private static final int BUTTON_SPAWN_NPCS_ID = 7;
    private static final int BUTTON_SPAWN_PROTECTION_ID = 8;
    private static final int BUTTON_COMMANDBLOCKS_ID = 9;
    private static final int BUTTON_FORCE_GAMEMODE_ID = 10;
    private static final int NAME_EDIT_BOX = 11;
    private RealmsEditBox nameEdit;
    protected final RealmsConfigureWorldScreen parent;
    private int column1_x;
    private int column_width;
    private int column2_x;
    private final RealmsWorldOptions options;
    private final RealmsServer.WorldType worldType;
    private final int activeSlot;
    private int difficultyIndex;
    private int gameModeIndex;
    private Boolean pvp;
    private Boolean spawnNPCs;
    private Boolean spawnAnimals;
    private Boolean spawnMonsters;
    private Integer spawnProtection;
    private Boolean commandBlocks;
    private Boolean forceGameMode;
    private RealmsButton pvpButton;
    private RealmsButton spawnAnimalsButton;
    private RealmsButton spawnMonstersButton;
    private RealmsButton spawnNPCsButton;
    private RealmsSliderButton spawnProtectionButton;
    private RealmsButton commandBlocksButton;
    private RealmsButton forceGameModeButton;
    private boolean notNormal;
    String[] difficulties;
    String[] gameModes;
    String[][] gameModeHints;

    public RealmsSlotOptionsScreen(RealmsConfigureWorldScreen configureWorldScreen, RealmsWorldOptions options, RealmsServer.WorldType worldType, int activeSlot) {
        this.parent = configureWorldScreen;
        this.options = options;
        this.worldType = worldType;
        this.activeSlot = activeSlot;
    }

    public void removed() {
        this.setKeyboardHandlerSendRepeatsToGui(false);
    }

    public void tick() {
        this.nameEdit.tick();
    }

    public boolean keyPressed(int eventKey, int scancode, int mods) {
        switch (eventKey) {
            case 258: {
                this.focusNext();
                return true;
            }
            case 256: {
                Realms.setScreen((RealmsScreen)this.parent);
                return true;
            }
            case 257: 
            case 335: {
                this.saveSettings();
                return true;
            }
        }
        return super.keyPressed(eventKey, scancode, mods);
    }

    public void init() {
        this.column_width = 170;
        this.column1_x = this.width() / 2 - this.column_width * 2 / 2;
        this.column2_x = this.width() / 2 + 10;
        this.createDifficultyAndGameMode();
        this.difficultyIndex = this.options.difficulty;
        this.gameModeIndex = this.options.gameMode;
        if (this.worldType.equals((Object)RealmsServer.WorldType.NORMAL)) {
            this.pvp = this.options.pvp;
            this.spawnProtection = this.options.spawnProtection;
            this.forceGameMode = this.options.forceGameMode;
            this.spawnAnimals = this.options.spawnAnimals;
            this.spawnMonsters = this.options.spawnMonsters;
            this.spawnNPCs = this.options.spawnNPCs;
            this.commandBlocks = this.options.commandBlocks;
        } else {
            this.notNormal = true;
            this.pvp = true;
            this.spawnProtection = 0;
            this.forceGameMode = false;
            this.spawnAnimals = true;
            this.spawnMonsters = true;
            this.spawnNPCs = true;
            this.commandBlocks = true;
        }
        this.nameEdit = this.newEditBox(11, this.column1_x + 2, RealmsConstants.row(1), this.column_width - 4, 20);
        this.nameEdit.setMaxLength(10);
        this.nameEdit.setValue(this.options.getSlotName(this.activeSlot));
        this.focusOn((RealmsGuiEventListener)this.nameEdit);
        this.pvpButton = new RealmsButton(4, this.column2_x, RealmsConstants.row(1), this.column_width, 20, this.pvpTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.pvp = RealmsSlotOptionsScreen.this.pvp == false;
                this.msg(RealmsSlotOptionsScreen.this.pvpTitle());
            }
        };
        this.buttonsAdd(this.pvpButton);
        this.buttonsAdd(new RealmsButton(3, this.column1_x, RealmsConstants.row(3), this.column_width, 20, this.gameModeTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.gameModeIndex = (RealmsSlotOptionsScreen.this.gameModeIndex + 1) % RealmsSlotOptionsScreen.this.gameModes.length;
                this.msg(RealmsSlotOptionsScreen.this.gameModeTitle());
            }
        });
        this.spawnAnimalsButton = new RealmsButton(5, this.column2_x, RealmsConstants.row(3), this.column_width, 20, this.spawnAnimalsTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.spawnAnimals = RealmsSlotOptionsScreen.this.spawnAnimals == false;
                this.msg(RealmsSlotOptionsScreen.this.spawnAnimalsTitle());
            }
        };
        this.buttonsAdd(this.spawnAnimalsButton);
        this.buttonsAdd(new RealmsButton(2, this.column1_x, RealmsConstants.row(5), this.column_width, 20, this.difficultyTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.difficultyIndex = (RealmsSlotOptionsScreen.this.difficultyIndex + 1) % RealmsSlotOptionsScreen.this.difficulties.length;
                this.msg(RealmsSlotOptionsScreen.this.difficultyTitle());
                if (RealmsSlotOptionsScreen.this.worldType.equals((Object)RealmsServer.WorldType.NORMAL)) {
                    RealmsSlotOptionsScreen.this.spawnMonstersButton.active(RealmsSlotOptionsScreen.this.difficultyIndex != 0);
                    RealmsSlotOptionsScreen.this.spawnMonstersButton.msg(RealmsSlotOptionsScreen.this.spawnMonstersTitle());
                }
            }
        });
        this.spawnMonstersButton = new RealmsButton(6, this.column2_x, RealmsConstants.row(5), this.column_width, 20, this.spawnMonstersTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.spawnMonsters = RealmsSlotOptionsScreen.this.spawnMonsters == false;
                this.msg(RealmsSlotOptionsScreen.this.spawnMonstersTitle());
            }
        };
        this.buttonsAdd(this.spawnMonstersButton);
        this.spawnProtectionButton = new SettingsSlider(8, this.column1_x, RealmsConstants.row(7), this.column_width, 17, this.spawnProtection, 0.0f, 16.0f);
        this.buttonsAdd((RealmsButton)this.spawnProtectionButton);
        this.spawnNPCsButton = new RealmsButton(7, this.column2_x, RealmsConstants.row(7), this.column_width, 20, this.spawnNPCsTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.spawnNPCs = RealmsSlotOptionsScreen.this.spawnNPCs == false;
                this.msg(RealmsSlotOptionsScreen.this.spawnNPCsTitle());
            }
        };
        this.buttonsAdd(this.spawnNPCsButton);
        this.forceGameModeButton = new RealmsButton(10, this.column1_x, RealmsConstants.row(9), this.column_width, 20, this.forceGameModeTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.forceGameMode = RealmsSlotOptionsScreen.this.forceGameMode == false;
                this.msg(RealmsSlotOptionsScreen.this.forceGameModeTitle());
            }
        };
        this.buttonsAdd(this.forceGameModeButton);
        this.commandBlocksButton = new RealmsButton(9, this.column2_x, RealmsConstants.row(9), this.column_width, 20, this.commandBlocksTitle()){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.commandBlocks = RealmsSlotOptionsScreen.this.commandBlocks == false;
                this.msg(RealmsSlotOptionsScreen.this.commandBlocksTitle());
            }
        };
        this.buttonsAdd(this.commandBlocksButton);
        if (!this.worldType.equals((Object)RealmsServer.WorldType.NORMAL)) {
            this.pvpButton.active(false);
            this.spawnAnimalsButton.active(false);
            this.spawnNPCsButton.active(false);
            this.spawnMonstersButton.active(false);
            this.spawnProtectionButton.active(false);
            this.commandBlocksButton.active(false);
            this.spawnProtectionButton.active(false);
            this.forceGameModeButton.active(false);
        }
        if (this.difficultyIndex == 0) {
            this.spawnMonstersButton.active(false);
        }
        this.buttonsAdd(new RealmsButton(1, this.column1_x, RealmsConstants.row(13), this.column_width, 20, RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.buttons.done")){

            public void onClick(double mouseX, double mouseY) {
                RealmsSlotOptionsScreen.this.saveSettings();
            }
        });
        this.buttonsAdd(new RealmsButton(0, this.column2_x, RealmsConstants.row(13), this.column_width, 20, RealmsSlotOptionsScreen.getLocalizedString((String)"gui.cancel")){

            public void onClick(double mouseX, double mouseY) {
                Realms.setScreen((RealmsScreen)RealmsSlotOptionsScreen.this.parent);
            }
        });
        this.addWidget((RealmsGuiEventListener)this.nameEdit);
    }

    private void createDifficultyAndGameMode() {
        this.difficulties = new String[]{RealmsSlotOptionsScreen.getLocalizedString((String)"options.difficulty.peaceful"), RealmsSlotOptionsScreen.getLocalizedString((String)"options.difficulty.easy"), RealmsSlotOptionsScreen.getLocalizedString((String)"options.difficulty.normal"), RealmsSlotOptionsScreen.getLocalizedString((String)"options.difficulty.hard")};
        this.gameModes = new String[]{RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.survival"), RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.creative"), RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.adventure")};
        this.gameModeHints = new String[][]{{RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.survival.line1"), RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.survival.line2")}, {RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.creative.line1"), RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.creative.line2")}, {RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.adventure.line1"), RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode.adventure.line2")}};
    }

    private String difficultyTitle() {
        String difficulty = RealmsSlotOptionsScreen.getLocalizedString((String)"options.difficulty");
        return difficulty + ": " + this.difficulties[this.difficultyIndex];
    }

    private String gameModeTitle() {
        String gameMode = RealmsSlotOptionsScreen.getLocalizedString((String)"selectWorld.gameMode");
        return gameMode + ": " + this.gameModes[this.gameModeIndex];
    }

    private String pvpTitle() {
        return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.pvp") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)(this.pvp != false ? "mco.configure.world.on" : "mco.configure.world.off"));
    }

    private String spawnAnimalsTitle() {
        return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.spawnAnimals") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)(this.spawnAnimals != false ? "mco.configure.world.on" : "mco.configure.world.off"));
    }

    private String spawnMonstersTitle() {
        if (this.difficultyIndex == 0) {
            return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.spawnMonsters") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.off");
        }
        return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.spawnMonsters") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)(this.spawnMonsters != false ? "mco.configure.world.on" : "mco.configure.world.off"));
    }

    private String spawnNPCsTitle() {
        return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.spawnNPCs") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)(this.spawnNPCs != false ? "mco.configure.world.on" : "mco.configure.world.off"));
    }

    private String commandBlocksTitle() {
        return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.commandBlocks") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)(this.commandBlocks != false ? "mco.configure.world.on" : "mco.configure.world.off"));
    }

    private String forceGameModeTitle() {
        return RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.forceGameMode") + ": " + RealmsSlotOptionsScreen.getLocalizedString((String)(this.forceGameMode != false ? "mco.configure.world.on" : "mco.configure.world.off"));
    }

    public void render(int xm, int ym, float a) {
        this.renderBackground();
        String slotName = RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.edit.slot.name");
        this.drawString(slotName, this.column1_x + this.column_width / 2 - this.fontWidth(slotName) / 2, RealmsConstants.row(0) - 5, 0xFFFFFF);
        this.drawCenteredString(RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.buttons.options"), this.width() / 2, 17, 0xFFFFFF);
        if (this.notNormal) {
            if (this.worldType.equals((Object)RealmsServer.WorldType.ADVENTUREMAP)) {
                this.drawCenteredString(RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.edit.subscreen.adventuremap"), this.width() / 2, 26, 0xFF0000);
            } else if (this.worldType.equals((Object)RealmsServer.WorldType.INSPIRATION)) {
                this.drawCenteredString(RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.edit.subscreen.inspiration"), this.width() / 2, 26, 0xFF0000);
            } else {
                this.drawCenteredString(RealmsSlotOptionsScreen.getLocalizedString((String)"mco.configure.world.edit.subscreen.experience"), this.width() / 2, 26, 0xFF0000);
            }
        }
        this.nameEdit.render(xm, ym, a);
        super.render(xm, ym, a);
    }

    public boolean mouseReleased(double x, double y, int buttonNum) {
        if (!this.spawnProtectionButton.active()) {
            return super.mouseReleased(x, y, buttonNum);
        }
        this.spawnProtectionButton.onRelease(x, y);
        return true;
    }

    public boolean mouseDragged(double x, double y, int buttonNum, double dx, double dy) {
        if (!this.spawnProtectionButton.active()) {
            return super.mouseDragged(x, y, buttonNum, dx, dy);
        }
        if (x < (double)(this.column1_x + this.spawnProtectionButton.getWidth()) && x > (double)this.column1_x && y < (double)(this.spawnProtectionButton.y() + 20) && y > (double)this.spawnProtectionButton.y()) {
            this.spawnProtectionButton.onClick(x, y);
        }
        return true;
    }

    private String getSlotName() {
        if (this.nameEdit.getValue().equals(this.options.getDefaultSlotName(this.activeSlot))) {
            return "";
        }
        return this.nameEdit.getValue();
    }

    private void saveSettings() {
        if (this.worldType.equals((Object)RealmsServer.WorldType.ADVENTUREMAP) || this.worldType.equals((Object)RealmsServer.WorldType.EXPERIENCE) || this.worldType.equals((Object)RealmsServer.WorldType.INSPIRATION)) {
            this.parent.saveSlotSettings(new RealmsWorldOptions(this.options.pvp, this.options.spawnAnimals, this.options.spawnMonsters, this.options.spawnNPCs, this.options.spawnProtection, this.options.commandBlocks, this.difficultyIndex, this.gameModeIndex, this.options.forceGameMode, this.getSlotName()));
        } else {
            this.parent.saveSlotSettings(new RealmsWorldOptions(this.pvp, this.spawnAnimals, this.spawnMonsters, this.spawnNPCs, this.spawnProtection, this.commandBlocks, this.difficultyIndex, this.gameModeIndex, this.forceGameMode, this.getSlotName()));
        }
    }

    private class SettingsSlider
    extends RealmsSliderButton {
        public SettingsSlider(int id, int x, int y, int width, int steps, int currentValue, float minValue, float maxValue) {
            super(id, x, y, width, steps, currentValue, (double)minValue, (double)maxValue);
        }

        public String getMessage() {
            return RealmsScreen.getLocalizedString((String)"mco.configure.world.spawnProtection") + ": " + (RealmsSlotOptionsScreen.this.spawnProtection == 0 ? RealmsScreen.getLocalizedString((String)"mco.configure.world.off") : RealmsSlotOptionsScreen.this.spawnProtection);
        }

        public void clicked(double value) {
            if (!RealmsSlotOptionsScreen.this.spawnProtectionButton.active()) {
                return;
            }
            RealmsSlotOptionsScreen.this.spawnProtection = (int)value;
        }
    }
}

