/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.stb;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct stbtt_aligned_quad")
public class STBTTAlignedQuad
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int X0;
    public static final int Y0;
    public static final int S0;
    public static final int T0;
    public static final int X1;
    public static final int Y1;
    public static final int S1;
    public static final int T1;

    STBTTAlignedQuad(long address, @Nullable ByteBuffer container) {
        super(address, container);
    }

    public STBTTAlignedQuad(ByteBuffer container) {
        this(MemoryUtil.memAddress((ByteBuffer)container), STBTTAlignedQuad.__checkContainer((ByteBuffer)container, (int)SIZEOF));
    }

    public int sizeof() {
        return SIZEOF;
    }

    public float x0() {
        return STBTTAlignedQuad.nx0(this.address());
    }

    public float y0() {
        return STBTTAlignedQuad.ny0(this.address());
    }

    public float s0() {
        return STBTTAlignedQuad.ns0(this.address());
    }

    public float t0() {
        return STBTTAlignedQuad.nt0(this.address());
    }

    public float x1() {
        return STBTTAlignedQuad.nx1(this.address());
    }

    public float y1() {
        return STBTTAlignedQuad.ny1(this.address());
    }

    public float s1() {
        return STBTTAlignedQuad.ns1(this.address());
    }

    public float t1() {
        return STBTTAlignedQuad.nt1(this.address());
    }

    public static STBTTAlignedQuad malloc() {
        return STBTTAlignedQuad.create(MemoryUtil.nmemAllocChecked((long)SIZEOF));
    }

    public static STBTTAlignedQuad calloc() {
        return STBTTAlignedQuad.create(MemoryUtil.nmemCallocChecked((long)1L, (long)SIZEOF));
    }

    public static STBTTAlignedQuad create() {
        return new STBTTAlignedQuad(BufferUtils.createByteBuffer((int)SIZEOF));
    }

    public static STBTTAlignedQuad create(long address) {
        return new STBTTAlignedQuad(address, null);
    }

    @Nullable
    public static STBTTAlignedQuad createSafe(long address) {
        return address == 0L ? null : STBTTAlignedQuad.create(address);
    }

    public static Buffer malloc(int capacity) {
        return STBTTAlignedQuad.create(STBTTAlignedQuad.__malloc((int)capacity, (int)SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity) {
        return STBTTAlignedQuad.create(MemoryUtil.nmemCallocChecked((long)capacity, (long)SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        return new Buffer(STBTTAlignedQuad.__create((int)capacity, (int)SIZEOF));
    }

    public static Buffer create(long address, int capacity) {
        return new Buffer(address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : STBTTAlignedQuad.create(address, capacity);
    }

    public static STBTTAlignedQuad mallocStack() {
        return STBTTAlignedQuad.mallocStack(MemoryStack.stackGet());
    }

    public static STBTTAlignedQuad callocStack() {
        return STBTTAlignedQuad.callocStack(MemoryStack.stackGet());
    }

    public static STBTTAlignedQuad mallocStack(MemoryStack stack) {
        return STBTTAlignedQuad.create(stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static STBTTAlignedQuad callocStack(MemoryStack stack) {
        return STBTTAlignedQuad.create(stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer mallocStack(int capacity) {
        return STBTTAlignedQuad.mallocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer callocStack(int capacity) {
        return STBTTAlignedQuad.callocStack(capacity, MemoryStack.stackGet());
    }

    public static Buffer mallocStack(int capacity, MemoryStack stack) {
        return STBTTAlignedQuad.create(stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer callocStack(int capacity, MemoryStack stack) {
        return STBTTAlignedQuad.create(stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static float nx0(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X0));
    }

    public static float ny0(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y0));
    }

    public static float ns0(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)S0));
    }

    public static float nt0(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)T0));
    }

    public static float nx1(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)X1));
    }

    public static float ny1(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)Y1));
    }

    public static float ns1(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)S1));
    }

    public static float nt1(long struct) {
        return MemoryUtil.memGetFloat((long)(struct + (long)T1));
    }

    static {
        Struct.Layout layout = STBTTAlignedQuad.__struct((Struct.Member[])new Struct.Member[]{STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4), STBTTAlignedQuad.__member((int)4)});
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        X0 = layout.offsetof(0);
        Y0 = layout.offsetof(1);
        S0 = layout.offsetof(2);
        T0 = layout.offsetof(3);
        X1 = layout.offsetof(4);
        Y1 = layout.offsetof(5);
        S1 = layout.offsetof(6);
        T1 = layout.offsetof(7);
    }

    public static class Buffer
    extends StructBuffer<STBTTAlignedQuad, Buffer>
    implements NativeResource {
        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        protected Buffer self() {
            return this;
        }

        protected Buffer newBufferInstance(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            return new Buffer(address, container, mark, pos, lim, cap);
        }

        protected STBTTAlignedQuad newInstance(long address) {
            return new STBTTAlignedQuad(address, this.container);
        }

        public int sizeof() {
            return SIZEOF;
        }

        public float x0() {
            return STBTTAlignedQuad.nx0(this.address());
        }

        public float y0() {
            return STBTTAlignedQuad.ny0(this.address());
        }

        public float s0() {
            return STBTTAlignedQuad.ns0(this.address());
        }

        public float t0() {
            return STBTTAlignedQuad.nt0(this.address());
        }

        public float x1() {
            return STBTTAlignedQuad.nx1(this.address());
        }

        public float y1() {
            return STBTTAlignedQuad.ny1(this.address());
        }

        public float s1() {
            return STBTTAlignedQuad.ns1(this.address());
        }

        public float t1() {
            return STBTTAlignedQuad.nt1(this.address());
        }
    }
}

