/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.gson.JsonElement;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.authlib.yggdrasil.YggdrasilAuthenticationService;
import com.mojang.datafixers.DataFixer;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import java.awt.GraphicsEnvironment;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import org.apache.commons.lang3.Validate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MinecraftServer
implements acs,
ads,
bt,
Runnable {
    private static final Logger h = LogManager.getLogger();
    public static final File a = new File("usercache.json");
    private final cbt i;
    private final adr j = new adr("server", this, k.b());
    private final File k;
    private final List<pt> l = Lists.newArrayList();
    public final xq b = new xq();
    private final ua m;
    private final om n = new om();
    private final Random o = new Random();
    private final DataFixer p;
    private String q;
    private int r = -1;
    public tc[] c;
    private vo s;
    private boolean t = true;
    private boolean u;
    private int v;
    protected final Proxy d;
    private ij w;
    private int x;
    private boolean y;
    private boolean z;
    private boolean A;
    private boolean B;
    private boolean C;
    private boolean D;
    private String E;
    private int F;
    private int G;
    public final long[] e = new long[100];
    public long[][] f;
    private KeyPair H;
    private String I;
    private String J;
    private String K;
    private boolean L;
    private boolean M;
    private String N = "";
    private String O = "";
    private boolean P;
    private long Q;
    private ij R;
    private boolean S;
    private boolean T;
    private final YggdrasilAuthenticationService U;
    private final MinecraftSessionService V;
    private final GameProfileRepository W;
    private final vk X;
    private long Y;
    public final Queue<FutureTask<?>> g = Queues.newConcurrentLinkedQueue();
    private Thread Z;
    private long aa = k.b();
    private boolean ab;
    private final vc ac = new vg(ul.b);
    private final uw<uz> ad = new uw<uz>(uz::new);
    private uu ae;
    private final bv af;
    private final avh ag = new avh();
    private final xa ah = new xa();
    private final pr ai = new pr(this);
    private final pv aj = new pv(this);
    private final cci ak = new cci();
    private final po al = new po();
    private final pp am = new pp(this);
    private boolean an;
    private boolean ao;
    private float ap;

    public MinecraftServer(@Nullable File file, Proxy proxy, DataFixer dataFixer, bv bv2, YggdrasilAuthenticationService yggdrasilAuthenticationService, MinecraftSessionService minecraftSessionService, GameProfileRepository gameProfileRepository, vk vk2) {
        this.d = proxy;
        this.af = bv2;
        this.U = yggdrasilAuthenticationService;
        this.V = minecraftSessionService;
        this.W = gameProfileRepository;
        this.X = vk2;
        this.k = file;
        this.m = file == null ? null : new ua(this);
        this.i = file == null ? null : new cbm(file.toPath(), file.toPath().resolve("../backups"), dataFixer);
        this.p = dataFixer;
        this.ac.a(this.ah);
        this.ac.a(this.ag);
        this.ac.a(this.ak);
        this.ac.a(this.am);
        this.ac.a(this.al);
    }

    public abstract boolean d() throws IOException;

    public void a(String string) {
        if (this.O().b(string)) {
            h.info("Converting map!");
            this.b(new ir("menu.convertingLevel", new Object[0]));
            this.O().a(string, new xr(){
                private long b = k.b();

                @Override
                public void a(ij ij2) {
                }

                @Override
                public void b(ij ij2) {
                }

                @Override
                public void a(int n2) {
                    if (k.b() - this.b >= 1000L) {
                        this.b = k.b();
                        h.info("Converting... {}%", (Object)n2);
                    }
                }

                @Override
                public void a() {
                }

                @Override
                public void c(ij ij2) {
                }
            });
        }
        if (this.ao) {
            h.info("Forcing world upgrade!");
            cbq cbq2 = this.O().c(this.K());
            if (cbq2 != null) {
                acx acx2 = new acx(this.K(), this.O(), cbq2);
                ij \u26032 = null;
                while (!acx2.b()) {
                    ij ij2 = acx2.m();
                    if (\u26032 != ij2) {
                        \u26032 = ij2;
                        h.info(acx2.m().getString());
                    }
                    if ((\u2603 = acx2.j()) > 0) {
                        int n2 = acx2.k() + acx2.l();
                        h.info("{}% completed ({} / {} chunks)...", (Object)xp.d((float)n2 / (float)\u2603 * 100.0f), (Object)n2, (Object)\u2603);
                    }
                    if (this.ad()) {
                        acx2.a();
                        continue;
                    }
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }
    }

    protected synchronized void b(ij ij2) {
        this.R = ij2;
    }

    @Nullable
    public synchronized ij f_() {
        return this.R;
    }

    public void a(String string, String string2, long l22, axz axz2, JsonElement jsonElement) {
        axx \u26033;
        this.a(string);
        this.b(new ir("menu.loadingLevel", new Object[0]));
        this.c = new tc[3];
        this.f = new long[this.c.length][100];
        cbr cbr2 = this.i.a(string, this);
        this.a(this.K(), cbr2);
        cbq \u26032 = cbr2.d();
        if (\u26032 == null) {
            if (this.N()) {
                \u26033 = sv.a;
            } else {
                long l22;
                \u26033 = new axx(l22, this.h(), this.g(), this.j(), axz2);
                \u26033.a(jsonElement);
                if (this.M) {
                    \u26033.a();
                }
            }
            \u26032 = new cbq(\u26033, string2);
        } else {
            \u26032.a(string2);
            \u26033 = new axx(\u26032);
        }
        this.a(cbr2.b(), \u26032);
        for (int i2 = 0; i2 < this.c.length; ++i2) {
            \u2603 = 0;
            if (i2 == 1) {
                \u2603 = -1;
            }
            if (i2 == 2) {
                \u2603 = 1;
            }
            if (i2 == 0) {
                this.c[i2] = this.N() ? (tc)new sv(this, cbr2, \u26032, \u2603, this.b).b() : (tc)new tc(this, cbr2, \u26032, \u2603, this.b).b();
                this.c[i2].a(\u26033);
            } else {
                this.c[i2] = (tc)new sx(this, cbr2, \u2603, this.c[0], this.b).b();
            }
            this.c[i2].a(new td(this, this.c[i2]));
            if (this.J()) continue;
            this.c[i2].g().a(this.h());
        }
        this.s.a(this.c);
        if (\u26032.P() != null) {
            this.aR().a(\u26032.P());
        }
        this.a(this.i());
        this.g_();
    }

    public void a(File file, cbq cbq2) {
        this.ad.a(new uy());
        this.ae = new uu(new File(file, "datapacks"));
        this.ad.a(this.ae);
        this.ad.a();
        ArrayList arrayList = Lists.newArrayList();
        for (String string : cbq2.O()) {
            uz uz2 = this.ad.a(string);
            if (uz2 != null) {
                arrayList.add(uz2);
                continue;
            }
            h.warn("Missing data pack {}", (Object)string);
        }
        this.ad.a(arrayList);
        this.a(cbq2);
    }

    public void g_() {
        int n2 = 16;
        \u2603 = 4;
        \u2603 = 12;
        \u2603 = 192;
        \u2603 = 625;
        this.b(new ir("menu.generatingTerrain", new Object[0]));
        boolean \u26032 = false;
        h.info("Preparing start region for level 0");
        tc \u26033 = this.c[0];
        ej \u26034 = \u26033.n();
        ArrayList \u26035 = Lists.newArrayList();
        Set \u26036 = Sets.newConcurrentHashSet();
        Stopwatch \u26037 = Stopwatch.createStarted();
        for (\u2603 = -192; \u2603 <= 192 && this.p(); \u2603 += 16) {
            for (\u2603 = -192; \u2603 <= 192 && this.p(); \u2603 += 16) {
                \u26035.add(new axi(\u26034.o() + \u2603 >> 4, \u26034.q() + \u2603 >> 4));
            }
            CompletableFuture<bni> completableFuture = \u26033.u().a(\u26035, (bna bna2) -> \u26036.add(bna2.d()));
            while (!completableFuture.isDone()) {
                try {
                    completableFuture.get(1L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    throw new RuntimeException(interruptedException);
                }
                catch (ExecutionException executionException) {
                    if (executionException.getCause() instanceof RuntimeException) {
                        throw (RuntimeException)executionException.getCause();
                    }
                    throw new RuntimeException(executionException.getCause());
                }
                catch (TimeoutException timeoutException) {
                    this.a(new ir("menu.preparingSpawn", new Object[0]), \u26036.size() * 100 / 625);
                }
            }
            this.a(new ir("menu.preparingSpawn", new Object[0]), \u26036.size() * 100 / 625);
        }
        this.m();
        h.info("Time elapsed: {} ms", (Object)\u26037.elapsed(TimeUnit.MILLISECONDS));
    }

    public void a(String string, cbr cbr2) {
        File file = new File(cbr2.b(), "resources.zip");
        if (file.isFile()) {
            try {
                this.a_("level://" + URLEncoder.encode(string, StandardCharsets.UTF_8.toString()) + "/" + "resources.zip", "");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                h.warn("Something went wrong url encoding {}", (Object)string);
            }
        }
    }

    public abstract boolean g();

    public abstract axp h();

    public abstract adf i();

    public abstract boolean j();

    public abstract int k();

    public abstract boolean l();

    protected void a(ij ij2, int n2) {
        this.w = ij2;
        this.x = n2;
        h.info("{}: {}%", (Object)ij2.getString(), (Object)n2);
    }

    protected void m() {
        this.w = null;
        this.x = 0;
    }

    public void a(boolean bl2) {
        for (tc tc2 : this.c) {
            if (tc2 == null) continue;
            if (!bl2) {
                h.info("Saving chunks for level '{}'/{}", (Object)tc2.g().j(), (Object)tc2.t.q().b());
            }
            try {
                tc2.a(true, null);
            }
            catch (axu axu2) {
                h.warn(axu2.getMessage());
            }
        }
    }

    public void h_() {
        h.info("Stopping server");
        if (this.ag() != null) {
            this.ag().b();
        }
        if (this.s != null) {
            h.info("Saving players");
            this.s.j();
            this.s.u();
        }
        if (this.c != null) {
            h.info("Saving worlds");
            for (tc tc2 : this.c) {
                if (tc2 == null) continue;
                tc2.b = false;
            }
            this.a(false);
            for (tc tc2 : this.c) {
                if (tc2 == null) continue;
                tc2.close();
            }
        }
        if (this.j.d()) {
            this.j.e();
        }
    }

    public String o() {
        return this.q;
    }

    public void b(String string) {
        this.q = string;
    }

    public boolean p() {
        return this.t;
    }

    public void q() {
        this.t = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            if (this.d()) {
                this.aa = k.b();
                this.n.a(new iq(this.E));
                this.n.a(new om.c("1.13", 393));
                this.a(this.n);
                while (this.t) {
                    long l2 = k.b() - this.aa;
                    if (l2 > 2000L && this.aa - this.Q >= 15000L) {
                        \u2603 = l2 / 50L;
                        h.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)l2, (Object)\u2603);
                        this.aa += \u2603 * 50L;
                        this.Q = this.aa;
                    }
                    this.v();
                    this.aa += 50L;
                    while (k.b() < this.aa) {
                        Thread.sleep(1L);
                    }
                    this.P = true;
                }
            } else {
                this.a((b)null);
            }
        }
        catch (Throwable throwable) {
            h.error("Encountered an unexpected exception", throwable);
            b b2 = throwable instanceof h ? this.b(((h)throwable).a()) : this.b(new b("Exception in server tick loop", throwable));
            File \u26032 = new File(new File(this.t(), "crash-reports"), "crash-" + new SimpleDateFormat("yyyy-MM-dd_HH.mm.ss").format(new Date()) + "-server.txt");
            if (b2.a(\u26032)) {
                h.error("This crash report has been saved to: {}", (Object)\u26032.getAbsolutePath());
            } else {
                h.error("We were unable to save this crash report to disk.");
            }
            this.a(b2);
        }
        finally {
            try {
                this.u = true;
                this.h_();
            }
            catch (Throwable \u26033) {
                h.error("Exception stopping the server", \u26033);
            }
            finally {
                this.u();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void a(om om2) {
        File file = this.c("server-icon.png");
        if (!file.exists()) {
            file = this.O().b(this.K(), "icon.png");
        }
        if (file.isFile()) {
            ByteBuf byteBuf = Unpooled.buffer();
            try {
                BufferedImage bufferedImage = ImageIO.read(file);
                Validate.validState((bufferedImage.getWidth() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels wide", (Object[])new Object[0]);
                Validate.validState((bufferedImage.getHeight() == 64 ? 1 : 0) != 0, (String)"Must be 64 pixels high", (Object[])new Object[0]);
                ImageIO.write((RenderedImage)bufferedImage, "PNG", (OutputStream)new ByteBufOutputStream(byteBuf));
                ByteBuffer \u26032 = Base64.getEncoder().encode(byteBuf.nioBuffer());
                om2.a("data:image/png;base64," + StandardCharsets.UTF_8.decode(\u26032));
            }
            catch (Exception exception) {
                h.error("Couldn't load server icon", (Throwable)exception);
            }
            finally {
                byteBuf.release();
            }
        }
    }

    public boolean r() {
        this.ab = this.ab || this.s().isFile();
        return this.ab;
    }

    public File s() {
        return this.O().b(this.K(), "icon.png");
    }

    public File t() {
        return new File(".");
    }

    public void a(b b2) {
    }

    public void u() {
    }

    public void v() {
        long l2 = k.c();
        ++this.v;
        if (this.S) {
            this.S = false;
            this.b.a(this.v);
        }
        this.b.a("root");
        this.w();
        if (l2 - this.Y >= 5000000000L) {
            this.Y = l2;
            this.n.a(new om.a(this.B(), this.A()));
            GameProfile[] gameProfileArray = new GameProfile[Math.min(this.A(), 12)];
            int \u26032 = xp.a(this.o, 0, this.A() - gameProfileArray.length);
            for (int i2 = 0; i2 < gameProfileArray.length; ++i2) {
                gameProfileArray[i2] = this.s.v().get(\u26032 + i2).do();
            }
            Collections.shuffle(Arrays.asList(gameProfileArray));
            this.n.b().a(gameProfileArray);
        }
        if (this.v % 900 == 0) {
            this.b.a("save");
            this.s.j();
            this.a(true);
            this.b.e();
        }
        this.b.a("snooper");
        if (!this.j.d() && this.v > 100) {
            this.j.a();
        }
        if (this.v % 6000 == 0) {
            this.j.b();
        }
        this.b.e();
        this.b.a("tallying");
        long l3 = k.c() - l2;
        this.e[this.v % 100] = l3;
        \u2603 = l3;
        this.ap = this.ap * 0.8f + (float)\u2603 / 1000000.0f * 0.19999999f;
        this.b.e();
        this.b.e();
    }

    public void w() {
        int n2;
        FutureTask<?> futureTask;
        this.b.a("jobs");
        while ((futureTask = this.g.poll()) != null) {
            k.a(futureTask, h);
        }
        this.b.c("commandFunctions");
        this.aD().Y_();
        this.b.c("levels");
        for (n2 = 0; n2 < this.c.length; ++n2) {
            long l2 = k.c();
            if (n2 == 0 || this.x()) {
                tc tc2 = this.c[n2];
                this.b.a(() -> tc2.g().j());
                if (this.v % 20 == 0) {
                    this.b.a("timeSync");
                    this.s.a(new lr(tc2.U(), tc2.V(), tc2.W().b("doDaylightCycle")), tc2.t.q().a());
                    this.b.e();
                }
                this.b.a("tick");
                try {
                    tc2.i_();
                }
                catch (Throwable \u26032) {
                    b b2 = b.a(\u26032, "Exception ticking world");
                    tc2.a(b2);
                    throw new h(b2);
                }
                try {
                    tc2.o_();
                }
                catch (Throwable throwable) {
                    b b3 = b.a(throwable, "Exception ticking world entities");
                    tc2.a(b3);
                    throw new h(b3);
                }
                this.b.e();
                this.b.a("tracker");
                tc2.z().a();
                this.b.e();
                this.b.e();
            }
            this.f[n2][this.v % 100] = k.c() - l2;
        }
        this.b.c("connection");
        this.ag().c();
        this.b.c("players");
        this.s.e();
        this.b.c("tickables");
        for (n2 = 0; n2 < this.l.size(); ++n2) {
            this.l.get(n2).Y_();
        }
        this.b.e();
    }

    public boolean x() {
        return true;
    }

    public void a(pt pt2) {
        this.l.add(pt2);
    }

    public static void main(String[] stringArray) {
        pf.c();
        try {
            GameProfileRepository \u26036;
            String \u26038;
            boolean bl2 = true;
            GameProfileRepository \u26032 = null;
            String \u26033 = ".";
            GameProfileRepository \u26034 = null;
            bl3 = false;
            bl4 = false;
            bl5 = false;
            int \u26035 = -1;
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                \u26038 = stringArray[i2];
                \u26036 = i2 == stringArray.length - 1 ? null : stringArray[i2 + 1];
                boolean \u26037 = false;
                if ("nogui".equals(\u26038) || "--nogui".equals(\u26038)) {
                    bl2 = false;
                } else if ("--port".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    try {
                        \u26035 = Integer.parseInt((String)\u26036);
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if ("--singleplayer".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    \u26032 = \u26036;
                } else if ("--universe".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    \u26033 = \u26036;
                } else if ("--world".equals(\u26038) && \u26036 != null) {
                    \u26037 = true;
                    \u26034 = \u26036;
                } else if ("--demo".equals(\u26038)) {
                    boolean bl3 = true;
                } else if ("--bonusChest".equals(\u26038)) {
                    boolean bl4 = true;
                } else if ("--forceUpgrade".equals(\u26038)) {
                    boolean bl5 = true;
                }
                if (!\u26037) continue;
                ++i2;
            }
            YggdrasilAuthenticationService yggdrasilAuthenticationService = new YggdrasilAuthenticationService(Proxy.NO_PROXY, UUID.randomUUID().toString());
            \u26038 = yggdrasilAuthenticationService.createMinecraftSessionService();
            \u26036 = yggdrasilAuthenticationService.createProfileRepository();
            vk \u26039 = new vk(\u26036, new File(\u26033, a.getName()));
            final sn \u260310 = new sn(new File(\u26033), xx.a(), yggdrasilAuthenticationService, (MinecraftSessionService)\u26038, \u26036, \u26039);
            if (\u26032 != null) {
                \u260310.h((String)\u26032);
            }
            if (\u26034 != null) {
                \u260310.i((String)\u26034);
            }
            if (\u26035 >= 0) {
                \u260310.b(\u26035);
            }
            if (bl3) {
                \u260310.c(true);
            }
            if (bl4) {
                \u260310.d(true);
            }
            if (bl2 && !GraphicsEnvironment.isHeadless()) {
                \u260310.aY();
            }
            if (bl5) {
                \u260310.b(true);
            }
            \u260310.y();
            Thread \u260311 = new Thread("Server Shutdown Thread"){

                @Override
                public void run() {
                    \u260310.h_();
                }
            };
            \u260311.setUncaughtExceptionHandler(new e(h));
            Runtime.getRuntime().addShutdownHook(\u260311);
        }
        catch (Exception exception) {
            h.fatal("Failed to start the minecraft server", (Throwable)exception);
        }
    }

    protected void b(boolean bl2) {
        this.ao = bl2;
    }

    public void y() {
        this.Z = new Thread((Runnable)this, "Server thread");
        this.Z.setUncaughtExceptionHandler((thread, throwable) -> h.error((Object)throwable));
        this.Z.start();
    }

    public File c(String string) {
        return new File(this.t(), string);
    }

    public void d(String string) {
        h.info(string);
    }

    public void e(String string) {
        h.warn(string);
    }

    public tc a(int n2) {
        if (n2 == -1) {
            return this.c[1];
        }
        if (n2 == 1) {
            return this.c[2];
        }
        return this.c[0];
    }

    public tc a(bnu bnu2) {
        if (bnu2 == bnu.b) {
            return this.c[1];
        }
        if (bnu2 == bnu.c) {
            return this.c[2];
        }
        return this.c[0];
    }

    public String z() {
        return "1.13";
    }

    public int A() {
        return this.s.o();
    }

    public int B() {
        return this.s.p();
    }

    public String[] C() {
        return this.s.f();
    }

    public boolean E() {
        return false;
    }

    public void f(String string) {
        h.error(string);
    }

    public void g(String string) {
        if (this.E()) {
            h.info(string);
        }
    }

    public String getServerModName() {
        return "vanilla";
    }

    public b b(b b2) {
        b2.g().a("Profiler Position", () -> this.b.a() ? this.b.f() : "N/A (disabled)");
        if (this.s != null) {
            b2.g().a("Player Count", () -> this.s.o() + " / " + this.s.p() + "; " + this.s.v());
        }
        b2.g().a("Data Packs", () -> {
            StringBuilder stringBuilder = new StringBuilder();
            for (uz uz2 : this.ad.d()) {
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(uz2.e());
                if (uz2.c().a()) continue;
                stringBuilder.append(" (incompatible)");
            }
            return stringBuilder.toString();
        });
        return b2;
    }

    public boolean F() {
        return this.k != null;
    }

    @Override
    public void a(ij ij2) {
        h.info(ij2.getString());
    }

    public KeyPair G() {
        return this.H;
    }

    public int H() {
        return this.r;
    }

    public void b(int n2) {
        this.r = n2;
    }

    public String I() {
        return this.I;
    }

    public void h(String string) {
        this.I = string;
    }

    public boolean J() {
        return this.I != null;
    }

    public String K() {
        return this.J;
    }

    public void i(String string) {
        this.J = string;
    }

    public void j(String string) {
        this.K = string;
    }

    public String L() {
        return this.K;
    }

    public void a(KeyPair keyPair) {
        this.H = keyPair;
    }

    public void a(adf adf2) {
        for (tc tc2 : this.c) {
            if (tc2 == null) continue;
            if (tc2.g().s()) {
                tc2.g().a(adf.d);
                tc2.a(true, true);
                continue;
            }
            if (this.J()) {
                tc2.g().a(adf2);
                tc2.a(tc2.ah() != adf.a, true);
                continue;
            }
            tc2.g().a(adf2);
            tc2.a(this.M(), this.A);
        }
    }

    public boolean M() {
        return true;
    }

    public boolean N() {
        return this.L;
    }

    public void c(boolean bl2) {
        this.L = bl2;
    }

    public void d(boolean bl2) {
        this.M = bl2;
    }

    public cbt O() {
        return this.i;
    }

    public String P() {
        return this.N;
    }

    public String Q() {
        return this.O;
    }

    public void a_(String string, String string2) {
        this.N = string;
        this.O = string2;
    }

    @Override
    public void a(adr adr22) {
        adr adr22;
        adr22.a("whitelist_enabled", false);
        adr22.a("whitelist_count", 0);
        if (this.s != null) {
            adr22.a("players_current", this.A());
            adr22.a("players_max", this.B());
            adr22.a("players_seen", this.s.q().length);
        }
        adr22.a("uses_auth", this.y);
        adr22.a("gui_state", this.ai() ? "enabled" : "disabled");
        adr22.a("run_time", (k.b() - adr22.g()) / 60L * 1000L);
        adr22.a("avg_tick_ms", (int)(xp.a(this.e) * 1.0E-6));
        int n2 = 0;
        if (this.c != null) {
            for (tc tc2 : this.c) {
                if (tc2 == null) continue;
                cbq cbq2 = tc2.g();
                adr22.a("world[" + n2 + "][dimension]", tc2.t.q().a());
                adr22.a("world[" + n2 + "][mode]", (Object)cbq2.q());
                adr22.a("world[" + n2 + "][difficulty]", (Object)tc2.ah());
                adr22.a("world[" + n2 + "][hardcore]", cbq2.s());
                adr22.a("world[" + n2 + "][generator_name]", cbq2.t().a());
                adr22.a("world[" + n2 + "][generator_version]", cbq2.t().e());
                adr22.a("world[" + n2 + "][height]", this.F);
                adr22.a("world[" + n2 + "][chunks_loaded]", tc2.u().h());
                ++n2;
            }
        }
        adr22.a("worlds", n2);
    }

    public boolean R() {
        return true;
    }

    public abstract boolean S();

    public boolean T() {
        return this.y;
    }

    public void e(boolean bl2) {
        this.y = bl2;
    }

    public boolean U() {
        return this.z;
    }

    public void f(boolean bl2) {
        this.z = bl2;
    }

    public boolean V() {
        return this.A;
    }

    public void g(boolean bl2) {
        this.A = bl2;
    }

    public boolean W() {
        return this.B;
    }

    public abstract boolean X();

    public void h(boolean bl2) {
        this.B = bl2;
    }

    public boolean Y() {
        return this.C;
    }

    public void i(boolean bl2) {
        this.C = bl2;
    }

    public boolean Z() {
        return this.D;
    }

    public void j(boolean bl2) {
        this.D = bl2;
    }

    public abstract boolean aa();

    public String ab() {
        return this.E;
    }

    public void k(String string) {
        this.E = string;
    }

    public int ac() {
        return this.F;
    }

    public void c(int n2) {
        this.F = n2;
    }

    public boolean ad() {
        return this.u;
    }

    public vo ae() {
        return this.s;
    }

    public void a(vo vo2) {
        this.s = vo2;
    }

    public abstract boolean af();

    public void a(axp axp2) {
        for (tc tc2 : this.c) {
            tc2.g().a(axp2);
        }
    }

    public ua ag() {
        return this.m;
    }

    public boolean ah() {
        return this.P;
    }

    public boolean ai() {
        return false;
    }

    public abstract boolean a(axp var1, boolean var2, int var3);

    public int aj() {
        return this.v;
    }

    public void ak() {
        this.S = true;
    }

    public adr al() {
        return this.j;
    }

    public int an() {
        return 16;
    }

    public boolean a(axs axs2, ej ej2, aoc aoc2) {
        return false;
    }

    public void k(boolean bl2) {
        this.T = bl2;
    }

    public boolean ao() {
        return this.T;
    }

    public int aq() {
        return this.G;
    }

    public void d(int n2) {
        this.G = n2;
    }

    public MinecraftSessionService ar() {
        return this.V;
    }

    public GameProfileRepository as() {
        return this.W;
    }

    public vk at() {
        return this.X;
    }

    public om au() {
        return this.n;
    }

    public void av() {
        this.Y = 0L;
    }

    public int aw() {
        return 29999984;
    }

    public <V> ListenableFuture<V> a(Callable<V> callable2) {
        Validate.notNull(callable2);
        if (!this.ax() && !this.ad()) {
            ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(callable2);
            this.g.add((FutureTask<?>)listenableFutureTask);
            return listenableFutureTask;
        }
        try {
            Callable<V> callable2;
            return Futures.immediateFuture(callable2.call());
        }
        catch (Exception exception) {
            return Futures.immediateFailedCheckedFuture((Exception)exception);
        }
    }

    @Override
    public ListenableFuture<Object> a(Runnable runnable) {
        Validate.notNull((Object)runnable);
        return this.a(Executors.callable(runnable));
    }

    @Override
    public boolean ax() {
        return Thread.currentThread() == this.Z;
    }

    public int ay() {
        return 256;
    }

    public long az() {
        return this.aa;
    }

    public Thread aA() {
        return this.Z;
    }

    public DataFixer aB() {
        return this.p;
    }

    public int a(@Nullable tc tc2) {
        if (tc2 != null) {
            return tc2.W().c("spawnRadius");
        }
        return 10;
    }

    public po aC() {
        return this.al;
    }

    public pp aD() {
        return this.am;
    }

    public void aE() {
        if (!this.ax()) {
            this.a(this::aE);
            return;
        }
        this.ae().j();
        this.ad.a();
        this.a(this.c[0].g());
        this.ae().w();
    }

    private void a(cbq cbq2) {
        ArrayList arrayList = Lists.newArrayList(this.ad.d());
        for (uz uz3 : this.ad.b()) {
            if (cbq2.N().contains(uz3.e()) || arrayList.contains(uz3)) continue;
            h.info("Found new data pack {}, loading it automatically", (Object)uz3.e());
            uz3.h().a(arrayList, uz3, uz2 -> uz2, false);
        }
        this.ad.a(arrayList);
        \u2603 = Lists.newArrayList();
        this.ad.d().forEach(uz2 -> \u2603.add(uz2.d()));
        this.ac.a(\u2603);
        cbq2.O().clear();
        cbq2.N().clear();
        this.ad.d().forEach(uz2 -> cbq2.O().add(uz2.e()));
        this.ad.b().forEach(uz2 -> {
            if (!this.ad.d().contains(uz2)) {
                cbq2.N().add(uz2.e());
            }
        });
    }

    public void a(bu bu2) {
        if (!this.aS()) {
            return;
        }
        vo vo2 = bu2.j().ae();
        vv \u26032 = vo2.k();
        if (!\u26032.b()) {
            return;
        }
        ArrayList \u26033 = Lists.newArrayList(vo2.v());
        for (te te2 : \u26033) {
            if (\u26032.a(te2.do())) continue;
            te2.a.b(new ir("multiplayer.disconnect.not_whitelisted", new Object[0]));
        }
    }

    public vc aF() {
        return this.ac;
    }

    public uw<uz> aG() {
        return this.ad;
    }

    public ij aI() {
        return this.w;
    }

    public int aJ() {
        return this.x;
    }

    public bv aK() {
        return this.af;
    }

    public bu aL() {
        return new bu(this, this.c[0] == null ? cdt.a : new cdt(this.c[0].n()), cds.a, this.c[0], 4, "Server", new iq("Server"), this, null);
    }

    @Override
    public boolean a() {
        return true;
    }

    @Override
    public boolean b() {
        return true;
    }

    public avh aM() {
        return this.ag;
    }

    public xa aN() {
        return this.ah;
    }

    public pr aO() {
        return this.ai;
    }

    public cci aP() {
        return this.ak;
    }

    public axo aQ() {
        return this.c[0].W();
    }

    public pv aR() {
        return this.aj;
    }

    public boolean aS() {
        return this.an;
    }

    public void l(boolean bl2) {
        this.an = bl2;
    }

    public float aT() {
        return this.ap;
    }

    public int a(GameProfile gameProfile) {
        if (this.ae().h(gameProfile)) {
            vq vq2 = (vq)this.ae().m().b(gameProfile);
            if (vq2 != null) {
                return vq2.a();
            }
            if (this.J()) {
                if (this.I().equals(gameProfile.getName())) {
                    return 4;
                }
                return this.ae().x() ? 4 : 0;
            }
            return this.k();
        }
        return 0;
    }
}

