/*
 * Decompiled with CFR 0.152.
 */
import com.google.common.collect.Maps;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.sound.sampled.AudioFormat;
import org.lwjgl.BufferUtils;
import org.lwjgl.openal.AL;
import org.lwjgl.openal.AL10;
import org.lwjgl.openal.ALC;
import org.lwjgl.openal.ALC10;
import org.lwjgl.openal.ALCCapabilities;
import paulscode.sound.Channel;
import paulscode.sound.FilenameURL;
import paulscode.sound.ICodec;
import paulscode.sound.Library;
import paulscode.sound.ListenerData;
import paulscode.sound.SoundBuffer;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.SoundSystemException;
import paulscode.sound.Source;

public class dgf
extends Library {
    private FloatBuffer a;
    private FloatBuffer b;
    private FloatBuffer c;
    private Map<String, IntBuffer> d = Maps.newHashMap();
    private static boolean e = true;
    private String f = "PreInit";
    private long g;
    private long h;

    public dgf() throws SoundSystemException {
        this.reverseByteOrder = true;
    }

    public void init() throws SoundSystemException {
        boolean bl2 = false;
        long \u26032 = ALC10.alcOpenDevice((ByteBuffer)null);
        if (\u26032 == 0L) {
            throw new a("Failed to open default device", 101);
        }
        ALCCapabilities \u26033 = ALC.createCapabilities((long)\u26032);
        if (!\u26033.OpenALC10) {
            throw new a("OpenAL 1.0 not supported", 101);
        }
        this.h = ALC10.alcCreateContext((long)\u26032, (IntBuffer)null);
        ALC10.alcMakeContextCurrent((long)this.h);
        AL.createCapabilities((ALCCapabilities)\u26033);
        this.message("OpenAL initialized.");
        this.a = BufferUtils.createFloatBuffer((int)3).put(new float[]{this.listener.position.x, this.listener.position.y, this.listener.position.z});
        this.b = BufferUtils.createFloatBuffer((int)6).put(new float[]{this.listener.lookAt.x, this.listener.lookAt.y, this.listener.lookAt.z, this.listener.up.x, this.listener.up.y, this.listener.up.z});
        this.c = BufferUtils.createFloatBuffer((int)3).put(new float[]{0.0f, 0.0f, 0.0f});
        this.a.flip();
        this.b.flip();
        this.c.flip();
        this.f = "Post Init";
        AL10.alListenerfv((int)4100, (FloatBuffer)this.a);
        bl2 = this.d() || bl2;
        AL10.alListenerfv((int)4111, (FloatBuffer)this.b);
        bl2 = this.d() || bl2;
        AL10.alListenerfv((int)4102, (FloatBuffer)this.c);
        bl2 = this.d() || bl2;
        AL10.alDopplerFactor((float)SoundSystemConfig.getDopplerFactor());
        bl2 = this.d() || bl2;
        AL10.alDopplerVelocity((float)SoundSystemConfig.getDopplerVelocity());
        boolean bl3 = bl2 = this.d() || bl2;
        if (bl2) {
            this.importantMessage("OpenAL did not initialize properly!");
            throw new a("Problem encountered while loading OpenAL or creating the listener. Probable cause: OpenAL not supported", 101);
        }
        super.init();
        dge \u26034 = (dge)((Object)this.normalChannels.get(1));
        try {
            AL10.alSourcef((int)\u26034.a.get(0), (int)4099, (float)1.0f);
            if (this.d()) {
                dgf.a(true, false);
                throw new a("OpenAL: AL_PITCH not supported.", 108);
            }
            dgf.a(true, true);
        }
        catch (Exception \u26035) {
            dgf.a(true, false);
            throw new a("OpenAL: AL_PITCH not supported.", 108);
        }
        this.f = "Running";
    }

    protected Channel createChannel(int n2) {
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        try {
            AL10.alGenSources((IntBuffer)intBuffer);
        }
        catch (Exception \u26032) {
            AL10.alGetError();
            return null;
        }
        if (AL10.alGetError() != 0) {
            return null;
        }
        return new dge(n2, intBuffer);
    }

    public void cleanup() {
        super.cleanup();
        for (String string : this.bufferMap.keySet()) {
            IntBuffer intBuffer = this.d.get(string);
            if (intBuffer == null) continue;
            AL10.alDeleteBuffers((IntBuffer)intBuffer);
            this.d();
            intBuffer.clear();
        }
        this.bufferMap.clear();
        ALC10.alcDestroyContext((long)this.h);
        if (this.g != 0L) {
            ALC10.alcCloseDevice((long)this.g);
        }
        this.bufferMap = null;
        this.a = null;
        this.b = null;
        this.c = null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean loadSound(FilenameURL filenameURL) {
        int n2;
        if (this.bufferMap == null) {
            this.bufferMap = Maps.newHashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.d == null) {
            this.d = Maps.newHashMap();
            this.importantMessage("Open AL Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(filenameURL == null, "Filename/URL not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(filenameURL.getFilename()) != null) {
            return true;
        }
        ICodec iCodec = SoundSystemConfig.getCodec((String)filenameURL.getFilename());
        if (this.errorCheck(iCodec == null, "No codec found for file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.reverseByteOrder(true);
        URL \u26032 = filenameURL.getURL();
        if (this.errorCheck(\u26032 == null, "Unable to open file '" + filenameURL.getFilename() + "' in method 'loadSound'")) {
            return false;
        }
        iCodec.initialize(\u26032);
        SoundBuffer \u26033 = iCodec.readAll();
        iCodec.cleanup();
        iCodec = null;
        if (this.errorCheck(\u26033 == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(filenameURL.getFilename(), \u26033);
        AudioFormat \u26034 = \u26033.audioFormat;
        if (\u26034.getChannels() == 1) {
            if (\u26034.getSampleSizeInBits() == 8) {
                n2 = 4352;
            } else {
                if (\u26034.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n2 = 4353;
            }
        } else {
            if (\u26034.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (\u26034.getSampleSizeInBits() == 8) {
                n2 = 4354;
            } else {
                if (\u26034.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                n2 = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when loading " + filenameURL.getFilename())) {
            return false;
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)n2, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)\u26033.audioData.length).put(\u26033.audioData).flip()), (int)((int)\u26034.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when loading " + filenameURL.getFilename()) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + filenameURL.getFilename())) {
            return false;
        }
        this.d.put(filenameURL.getFilename(), intBuffer);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean loadSound(SoundBuffer soundBuffer, String string) {
        int \u26032;
        if (this.bufferMap == null) {
            this.bufferMap = Maps.newHashMap();
            this.importantMessage("Buffer Map was null in method 'loadSound'");
        }
        if (this.d == null) {
            this.d = Maps.newHashMap();
            this.importantMessage("Open AL Buffer Map was null in method 'loadSound'");
        }
        if (this.errorCheck(string == null, "Identifier not specified in method 'loadSound'")) {
            return false;
        }
        if (this.bufferMap.get(string) != null) {
            return true;
        }
        if (this.errorCheck(soundBuffer == null, "Sound buffer null in method 'loadSound'")) {
            return false;
        }
        this.bufferMap.put(string, soundBuffer);
        AudioFormat audioFormat = soundBuffer.audioFormat;
        if (audioFormat.getChannels() == 1) {
            if (audioFormat.getSampleSizeInBits() == 8) {
                \u26032 = 4352;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                \u26032 = 4353;
            }
        } else {
            if (audioFormat.getChannels() != 2) {
                this.errorMessage("File neither mono nor stereo in method 'loadSound'");
                return false;
            }
            if (audioFormat.getSampleSizeInBits() == 8) {
                \u26032 = 4354;
            } else {
                if (audioFormat.getSampleSizeInBits() != 16) {
                    this.errorMessage("Illegal sample size in method 'loadSound'");
                    return false;
                }
                \u26032 = 4355;
            }
        }
        IntBuffer intBuffer = BufferUtils.createIntBuffer((int)1);
        AL10.alGenBuffers((IntBuffer)intBuffer);
        if (this.errorCheck(AL10.alGetError() != 0, "alGenBuffers error when saving " + string)) {
            return false;
        }
        AL10.alBufferData((int)intBuffer.get(0), (int)\u26032, (ByteBuffer)((ByteBuffer)BufferUtils.createByteBuffer((int)soundBuffer.audioData.length).put(soundBuffer.audioData).flip()), (int)((int)audioFormat.getSampleRate()));
        if (this.errorCheck(AL10.alGetError() != 0, "alBufferData error when saving " + string) && this.errorCheck(intBuffer == null, "Sound buffer was not created for " + string)) {
            return false;
        }
        this.d.put(string, intBuffer);
        return true;
    }

    public void unloadSound(String string) {
        this.d.remove(string);
        super.unloadSound(string);
    }

    public void setMasterVolume(float f2) {
        super.setMasterVolume(f2);
        AL10.alListenerf((int)4106, (float)f2);
        this.d();
    }

    public void newSource(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, float f2, float f3, float f4, int n2, float f5) {
        IntBuffer intBuffer = null;
        if (!bl3) {
            intBuffer = this.d.get(filenameURL.getFilename());
            if (intBuffer == null && !this.loadSound(filenameURL)) {
                this.errorMessage(String.format("Source '%s' was not created because an error occurred while loading %s", string, filenameURL.getFilename()));
                return;
            }
            intBuffer = this.d.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.errorMessage(String.format("Source '%s' was not created because a sound buffer was not found for %s", string, filenameURL.getFilename()));
                return;
            }
        }
        SoundBuffer \u26032 = null;
        if (!bl3) {
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null && !this.loadSound(filenameURL)) {
                this.errorMessage(String.format("Source '%s' was not created because an error occurred while loading %s", string, filenameURL.getFilename()));
                return;
            }
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null) {
                this.errorMessage(String.format("Source '%s' was not created because audio data was not found for %s", string, filenameURL.getFilename()));
                return;
            }
        }
        this.sourceMap.put(string, new dgl(this.a, intBuffer, bl2, bl3, bl4, string, filenameURL, \u26032, f2, f3, f4, n2, f5, false));
    }

    public void rawDataStream(AudioFormat audioFormat, boolean bl2, String string, float f2, float f3, float f4, int n2, float f5) {
        this.sourceMap.put(string, new dgl(this.a, audioFormat, bl2, string, f2, f3, f4, n2, f5));
    }

    public void quickPlay(boolean bl2, boolean bl3, boolean bl4, String string, FilenameURL filenameURL, float f2, float f3, float f4, int n2, float f5, boolean bl5) {
        IntBuffer intBuffer = null;
        if (!bl3) {
            intBuffer = this.d.get(filenameURL.getFilename());
            if (intBuffer == null) {
                this.loadSound(filenameURL);
            }
            if ((intBuffer = this.d.get(filenameURL.getFilename())) == null) {
                this.errorMessage("Sound buffer was not created for " + filenameURL.getFilename());
                return;
            }
        }
        SoundBuffer \u26032 = null;
        if (!bl3) {
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null && !this.loadSound(filenameURL)) {
                this.errorMessage(String.format("Source '%s' was not created because an error occurred while loading %s", string, filenameURL.getFilename()));
                return;
            }
            \u26032 = (SoundBuffer)this.bufferMap.get(filenameURL.getFilename());
            if (\u26032 == null) {
                this.errorMessage(String.format("Source '%s' was not created because audio data was not found for %s", string, filenameURL.getFilename()));
                return;
            }
        }
        dgl \u26033 = new dgl(this.a, intBuffer, bl2, bl3, bl4, string, filenameURL, \u26032, f2, f3, f4, n2, f5, false);
        this.sourceMap.put(string, \u26033);
        this.play(\u26033);
        if (bl5) {
            \u26033.setTemporary(true);
        }
    }

    public void copySources(HashMap<String, Source> hashMap) {
        if (hashMap == null) {
            return;
        }
        Set<String> set = hashMap.keySet();
        Iterator<String> \u26032 = set.iterator();
        if (this.bufferMap == null) {
            this.bufferMap = Maps.newHashMap();
            this.importantMessage("Buffer Map was null in method 'copySources'");
        }
        if (this.d == null) {
            this.d = Maps.newHashMap();
            this.importantMessage("Open AL Buffer Map was null in method 'copySources'");
        }
        this.sourceMap.clear();
        while (\u26032.hasNext()) {
            String string = \u26032.next();
            Source \u26033 = hashMap.get(string);
            if (\u26033 == null) continue;
            SoundBuffer \u26034 = null;
            if (!\u26033.toStream) {
                this.loadSound(\u26033.filenameURL);
                \u26034 = (SoundBuffer)this.bufferMap.get(\u26033.filenameURL.getFilename());
            }
            if (!\u26033.toStream && \u26034 == null) continue;
            this.sourceMap.put(string, new dgl(this.a, this.d.get(\u26033.filenameURL.getFilename()), \u26033, \u26034));
        }
    }

    public void setListenerPosition(float f2, float f3, float f4) {
        super.setListenerPosition(f2, f3, f4);
        this.a.put(0, f2);
        this.a.put(1, f3);
        this.a.put(2, f4);
        AL10.alListenerfv((int)4100, (FloatBuffer)this.a);
        this.d();
    }

    public void setListenerAngle(float f2) {
        super.setListenerAngle(f2);
        this.b.put(0, this.listener.lookAt.x);
        this.b.put(2, this.listener.lookAt.z);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.b);
        this.d();
    }

    public void setListenerOrientation(float f2, float f3, float f4, float f5, float f6, float f7) {
        super.setListenerOrientation(f2, f3, f4, f5, f6, f7);
        this.b.put(0, f2);
        this.b.put(1, f3);
        this.b.put(2, f4);
        this.b.put(3, f5);
        this.b.put(4, f6);
        this.b.put(5, f7);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.b);
        this.d();
    }

    public void setListenerData(ListenerData listenerData) {
        super.setListenerData(listenerData);
        this.a.put(0, listenerData.position.x);
        this.a.put(1, listenerData.position.y);
        this.a.put(2, listenerData.position.z);
        AL10.alListenerfv((int)4100, (FloatBuffer)this.a);
        this.d();
        this.b.put(0, listenerData.lookAt.x);
        this.b.put(1, listenerData.lookAt.y);
        this.b.put(2, listenerData.lookAt.z);
        this.b.put(3, listenerData.up.x);
        this.b.put(4, listenerData.up.y);
        this.b.put(5, listenerData.up.z);
        AL10.alListenerfv((int)4111, (FloatBuffer)this.b);
        this.d();
        this.c.put(0, listenerData.velocity.x);
        this.c.put(1, listenerData.velocity.y);
        this.c.put(2, listenerData.velocity.z);
        AL10.alListenerfv((int)4102, (FloatBuffer)this.c);
        this.d();
    }

    public void setListenerVelocity(float f2, float f3, float f4) {
        super.setListenerVelocity(f2, f3, f4);
        this.c.put(0, this.listener.velocity.x);
        this.c.put(1, this.listener.velocity.y);
        this.c.put(2, this.listener.velocity.z);
        AL10.alListenerfv((int)4102, (FloatBuffer)this.c);
    }

    public void dopplerChanged() {
        super.dopplerChanged();
        AL10.alDopplerFactor((float)SoundSystemConfig.getDopplerFactor());
        this.d();
        AL10.alDopplerVelocity((float)SoundSystemConfig.getDopplerVelocity());
        this.d();
    }

    private boolean d() {
        switch (AL10.alGetError()) {
            case 0: {
                return false;
            }
            case 40961: {
                this.errorMessage("Invalid name parameter: " + this.f);
                return true;
            }
            case 40962: {
                this.errorMessage("Invalid parameter: " + this.f);
                return true;
            }
            case 40963: {
                this.errorMessage("Invalid enumerated parameter value: " + this.f);
                return true;
            }
            case 40964: {
                this.errorMessage("Illegal call: " + this.f);
                return true;
            }
            case 40965: {
                this.errorMessage("Unable to allocate memory: " + this.f);
                return true;
            }
        }
        this.errorMessage("An unrecognized error occurred: " + this.f);
        return true;
    }

    public static boolean a() {
        return dgf.a(false, false);
    }

    private static synchronized boolean a(boolean bl2, boolean bl3) {
        if (bl2) {
            e = bl3;
        }
        return e;
    }

    public String getClassName() {
        return "LibraryLWJGL3";
    }

    public static class a
    extends SoundSystemException {
        public a(String string) {
            super(string);
        }

        public a(String string, int n2) {
            super(string, n2);
        }
    }
}

