/*
 * Decompiled with CFR 0.152.
 */
package jdk.nashorn.internal.ir;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import jdk.nashorn.internal.ir.Block;
import jdk.nashorn.internal.ir.CatchNode;
import jdk.nashorn.internal.ir.JoinPredecessor;
import jdk.nashorn.internal.ir.LexicalContext;
import jdk.nashorn.internal.ir.LocalVariableConversion;
import jdk.nashorn.internal.ir.Node;
import jdk.nashorn.internal.ir.Statement;
import jdk.nashorn.internal.ir.Symbol;
import jdk.nashorn.internal.ir.annotations.Immutable;
import jdk.nashorn.internal.ir.visitor.NodeVisitor;

@Immutable
public final class TryNode
extends Statement
implements JoinPredecessor {
    private static final long serialVersionUID = 1L;
    private final Block body;
    private final List<Block> catchBlocks;
    private final Block finallyBody;
    private Symbol exception;
    private Symbol finallyCatchAll;
    private final LocalVariableConversion conversion;

    public TryNode(int lineNumber, long token, int finish, Block body, List<Block> catchBlocks, Block finallyBody) {
        super(lineNumber, token, finish);
        this.body = body;
        this.catchBlocks = catchBlocks;
        this.finallyBody = finallyBody;
        this.conversion = null;
    }

    private TryNode(TryNode tryNode, Block body, List<Block> catchBlocks, Block finallyBody, LocalVariableConversion conversion) {
        super(tryNode);
        this.body = body;
        this.catchBlocks = catchBlocks;
        this.finallyBody = finallyBody;
        this.conversion = conversion;
        this.exception = tryNode.exception;
    }

    @Override
    public Node ensureUniqueLabels(LexicalContext lc) {
        return new TryNode(this, this.body, this.catchBlocks, this.finallyBody, this.conversion);
    }

    @Override
    public boolean isTerminal() {
        if (this.body.isTerminal()) {
            for (Block catchBlock : this.getCatchBlocks()) {
                if (catchBlock.isTerminal()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public Node accept(NodeVisitor<? extends LexicalContext> visitor) {
        if (visitor.enterTryNode(this)) {
            Block newFinallyBody = this.finallyBody == null ? null : (Block)this.finallyBody.accept(visitor);
            Block newBody = (Block)this.body.accept(visitor);
            return visitor.leaveTryNode(this.setBody(newBody).setFinallyBody(newFinallyBody).setCatchBlocks(Node.accept(visitor, this.catchBlocks)).setFinallyCatchAll(this.finallyCatchAll));
        }
        return this;
    }

    @Override
    public void toString(StringBuilder sb, boolean printType) {
        sb.append("try ");
    }

    public Block getBody() {
        return this.body;
    }

    public TryNode setBody(Block body) {
        if (this.body == body) {
            return this;
        }
        return new TryNode(this, body, this.catchBlocks, this.finallyBody, this.conversion);
    }

    public List<CatchNode> getCatches() {
        ArrayList<CatchNode> catches = new ArrayList<CatchNode>(this.catchBlocks.size());
        for (Block catchBlock : this.catchBlocks) {
            catches.add(TryNode.getCatchNodeFromBlock(catchBlock));
        }
        return Collections.unmodifiableList(catches);
    }

    private static CatchNode getCatchNodeFromBlock(Block catchBlock) {
        return (CatchNode)catchBlock.getStatements().get(0);
    }

    public List<Block> getCatchBlocks() {
        return Collections.unmodifiableList(this.catchBlocks);
    }

    public TryNode setCatchBlocks(List<Block> catchBlocks) {
        if (this.catchBlocks == catchBlocks) {
            return this;
        }
        return new TryNode(this, this.body, catchBlocks, this.finallyBody, this.conversion);
    }

    public Symbol getException() {
        return this.exception;
    }

    public TryNode setException(Symbol exception) {
        this.exception = exception;
        return this;
    }

    public Symbol getFinallyCatchAll() {
        return this.finallyCatchAll;
    }

    public TryNode setFinallyCatchAll(Symbol finallyCatchAll) {
        this.finallyCatchAll = finallyCatchAll;
        return this;
    }

    public Block getFinallyBody() {
        return this.finallyBody;
    }

    public TryNode setFinallyBody(Block finallyBody) {
        if (this.finallyBody == finallyBody) {
            return this;
        }
        return new TryNode(this, this.body, this.catchBlocks, finallyBody, this.conversion);
    }

    @Override
    public JoinPredecessor setLocalVariableConversion(LexicalContext lc, LocalVariableConversion conversion) {
        if (this.conversion == conversion) {
            return this;
        }
        return new TryNode(this, this.body, this.catchBlocks, this.finallyBody, conversion);
    }

    @Override
    public LocalVariableConversion getLocalVariableConversion() {
        return this.conversion;
    }
}

