/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import sun.misc.PerformanceLogger;

public final class PerfLogger {
    private static boolean perfLogOn = false;
    private static boolean useNano = false;
    private static String perfLogFilePath = null;
    private static long baseTime = 0L;
    private static long endTime = 0L;

    private static boolean isJavaVersionAtLeast15() {
        String string = System.getProperty("java.version");
        return !string.startsWith("1.3") && !string.startsWith("1.4");
    }

    public static void setBaseTimeString(String string) {
        if (perfLogOn && baseTime == 0L && string != null) {
            try {
                long l = new Long(string);
                if (l > 0L) {
                    if (useNano) {
                        baseTime = l * 1000000L;
                        PerformanceLogger.setStartTime((String)"Native Start Time (in Nano)", (long)baseTime);
                    } else {
                        baseTime = l;
                        PerformanceLogger.setStartTime((String)"Native Start Time", (long)baseTime);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static boolean perfLogEnabled() {
        return perfLogOn;
    }

    public static void setStartTime(String string) {
        if (perfLogOn && baseTime == 0L) {
            baseTime = useNano ? System.nanoTime() : System.currentTimeMillis();
            PerformanceLogger.setStartTime((String)string, (long)baseTime);
        }
    }

    public static void setTime(String string) {
        if (perfLogOn) {
            PerformanceLogger.setTime((String)string);
        }
    }

    public static void setEndTime(String string) {
        if (perfLogOn) {
            PerformanceLogger.setTime((String)string);
            endTime = useNano ? System.nanoTime() : System.currentTimeMillis();
        }
    }

    public static void outputLog() {
        if (perfLogOn) {
            try {
                PerformanceLogger.setBaseTime((long)baseTime);
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
            if (endTime != 0L) {
                PerformanceLogger.setTime((String)("Deployment Java Startup time " + (endTime - PerformanceLogger.getStartTime())));
            }
            PerformanceLogger.outputLog();
        }
    }

    static {
        perfLogFilePath = System.getProperty("sun.perflog");
        if (perfLogFilePath != null && PerfLogger.isJavaVersionAtLeast15()) {
            perfLogOn = true;
            useNano = System.getProperty("sun.perflog.nano") != null;
        }
    }
}

