/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.tls;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.crypto.tls.ProtocolVersion;
import org.bouncycastle.crypto.tls.TlsCipher;
import org.bouncycastle.crypto.tls.TlsClientContext;
import org.bouncycastle.crypto.tls.TlsFatalAlert;
import org.bouncycastle.crypto.tls.TlsMac;
import org.bouncycastle.crypto.tls.TlsUtils;
import org.bouncycastle.util.Arrays;

public class TlsBlockCipher
implements TlsCipher {
    protected TlsClientContext context;
    protected BlockCipher encryptCipher;
    protected BlockCipher decryptCipher;
    protected TlsMac writeMac;
    protected TlsMac readMac;

    public TlsMac getWriteMac() {
        return this.writeMac;
    }

    public TlsMac getReadMac() {
        return this.readMac;
    }

    public TlsBlockCipher(TlsClientContext tlsClientContext, BlockCipher blockCipher, BlockCipher blockCipher2, Digest digest, Digest digest2, int n2) {
        this.context = tlsClientContext;
        this.encryptCipher = blockCipher;
        this.decryptCipher = blockCipher2;
        int n3 = 2 * n2 + digest.getDigestSize() + digest2.getDigestSize() + blockCipher.getBlockSize() + blockCipher2.getBlockSize();
        byte[] byArray = TlsUtils.calculateKeyBlock(tlsClientContext, n3);
        int n4 = 0;
        this.writeMac = new TlsMac(tlsClientContext, digest, byArray, n4, digest.getDigestSize());
        this.readMac = new TlsMac(tlsClientContext, digest2, byArray, n4 += digest.getDigestSize(), digest2.getDigestSize());
        this.initCipher(true, blockCipher, byArray, n2, n4 += digest2.getDigestSize(), n4 + n2 * 2);
        this.initCipher(false, blockCipher2, byArray, n2, n4 += n2, n4 + n2 + blockCipher.getBlockSize());
    }

    protected void initCipher(boolean bl2, BlockCipher blockCipher, byte[] byArray, int n2, int n3, int n4) {
        KeyParameter keyParameter = new KeyParameter(byArray, n3, n2);
        ParametersWithIV parametersWithIV = new ParametersWithIV(keyParameter, byArray, n4, blockCipher.getBlockSize());
        blockCipher.init(bl2, parametersWithIV);
    }

    public byte[] encodePlaintext(short s2, byte[] byArray, int n2, int n3) {
        int n4;
        int n5;
        boolean bl2;
        int n6;
        int n7 = this.encryptCipher.getBlockSize();
        int n8 = n6 = n7 - (n3 + this.writeMac.getSize() + 1) % n7;
        boolean bl3 = bl2 = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        if (bl2) {
            n5 = (255 - n6) / n7;
            int n9 = this.chooseExtraPadBlocks(this.context.getSecureRandom(), n5);
            n8 += n9 * n7;
        }
        n5 = n3 + this.writeMac.getSize() + n8 + 1;
        byte[] byArray2 = new byte[n5];
        System.arraycopy(byArray, n2, byArray2, 0, n3);
        byte[] byArray3 = this.writeMac.calculateMac(s2, byArray, n2, n3);
        System.arraycopy(byArray3, 0, byArray2, n3, byArray3.length);
        int n10 = n3 + byArray3.length;
        for (n4 = 0; n4 <= n8; ++n4) {
            byArray2[n4 + n10] = (byte)n8;
        }
        for (n4 = 0; n4 < n5; n4 += n7) {
            this.encryptCipher.processBlock(byArray2, n4, byArray2, n4);
        }
        return byArray2;
    }

    public byte[] decodeCiphertext(short s2, byte[] byArray, int n2, int n3) throws IOException {
        int n4;
        int n5;
        int n6 = this.readMac.getSize() + 1;
        int n7 = this.decryptCipher.getBlockSize();
        boolean bl2 = false;
        if (n3 < n6) {
            throw new TlsFatalAlert(50);
        }
        if (n3 % n7 != 0) {
            throw new TlsFatalAlert(21);
        }
        for (n5 = 0; n5 < n3; n5 += n7) {
            this.decryptCipher.processBlock(byArray, n5 + n2, byArray, n5 + n2);
        }
        n5 = n2 + n3 - 1;
        byte by2 = byArray[n5];
        int n8 = by2 & 0xFF;
        boolean bl3 = this.context.getServerVersion().getFullVersion() >= ProtocolVersion.TLSv10.getFullVersion();
        int n9 = n3 - n6;
        if (!bl3) {
            n9 = Math.min(n9, n7);
        }
        if (n8 > n9) {
            bl2 = true;
            n8 = 0;
        } else if (bl3) {
            n4 = 0;
            for (int i2 = n5 - n8; i2 < n5; ++i2) {
                n4 = (byte)(n4 | byArray[i2] ^ by2);
            }
            if (n4 != 0) {
                bl2 = true;
                n8 = 0;
            }
        }
        n4 = n3 - n6 - n8;
        byte[] byArray2 = this.readMac.calculateMac(s2, byArray, n2, n4);
        byte[] byArray3 = new byte[byArray2.length];
        System.arraycopy(byArray, n2 + n4, byArray3, 0, byArray2.length);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray3)) {
            bl2 = true;
        }
        if (bl2) {
            throw new TlsFatalAlert(20);
        }
        byte[] byArray4 = new byte[n4];
        System.arraycopy(byArray, n2, byArray4, 0, n4);
        return byArray4;
    }

    protected int chooseExtraPadBlocks(SecureRandom secureRandom, int n2) {
        int n3 = secureRandom.nextInt();
        int n4 = this.lowestBitSet(n3);
        return Math.min(n4, n2);
    }

    protected int lowestBitSet(int n2) {
        if (n2 == 0) {
            return 32;
        }
        int n3 = 0;
        while ((n2 & 1) == 0) {
            ++n3;
            n2 >>= 1;
        }
        return n3;
    }
}

