/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1ParsingException;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.StreamUtil;
import org.bouncycastle.util.Arrays;

public class DERApplicationSpecific
extends ASN1Primitive {
    private final boolean isConstructed;
    private final int tag;
    private final byte[] octets;

    DERApplicationSpecific(boolean bl2, int n2, byte[] byArray) {
        this.isConstructed = bl2;
        this.tag = n2;
        this.octets = byArray;
    }

    public DERApplicationSpecific(int n2, byte[] byArray) {
        this(false, n2, byArray);
    }

    public DERApplicationSpecific(int n2, ASN1Encodable aSN1Encodable) throws IOException {
        this(true, n2, aSN1Encodable);
    }

    public DERApplicationSpecific(boolean bl2, int n2, ASN1Encodable aSN1Encodable) throws IOException {
        ASN1Primitive aSN1Primitive = aSN1Encodable.toASN1Primitive();
        byte[] byArray = aSN1Primitive.getEncoded("DER");
        this.isConstructed = bl2 || aSN1Primitive instanceof ASN1Set || aSN1Primitive instanceof ASN1Sequence;
        this.tag = n2;
        if (bl2) {
            this.octets = byArray;
        } else {
            int n3 = this.getLengthOfHeader(byArray);
            byte[] byArray2 = new byte[byArray.length - n3];
            System.arraycopy(byArray, n3, byArray2, 0, byArray2.length);
            this.octets = byArray2;
        }
    }

    public DERApplicationSpecific(int n2, ASN1EncodableVector aSN1EncodableVector) {
        this.tag = n2;
        this.isConstructed = true;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i2 = 0; i2 != aSN1EncodableVector.size(); ++i2) {
            try {
                byteArrayOutputStream.write(((ASN1Object)aSN1EncodableVector.get(i2)).getEncoded("DER"));
                continue;
            }
            catch (IOException iOException) {
                throw new ASN1ParsingException("malformed object: " + iOException, iOException);
            }
        }
        this.octets = byteArrayOutputStream.toByteArray();
    }

    public static DERApplicationSpecific getInstance(Object object) {
        ASN1Primitive aSN1Primitive;
        if (object == null || object instanceof DERApplicationSpecific) {
            return (DERApplicationSpecific)object;
        }
        if (object instanceof byte[]) {
            try {
                return DERApplicationSpecific.getInstance(ASN1Primitive.fromByteArray((byte[])object));
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("failed to construct object from byte[]: " + iOException.getMessage());
            }
        }
        if (object instanceof ASN1Encodable && (aSN1Primitive = ((ASN1Encodable)object).toASN1Primitive()) instanceof ASN1Sequence) {
            return (DERApplicationSpecific)aSN1Primitive;
        }
        throw new IllegalArgumentException("unknown object in getInstance: " + object.getClass().getName());
    }

    private int getLengthOfHeader(byte[] byArray) {
        int n2 = byArray[1] & 0xFF;
        if (n2 == 128) {
            return 2;
        }
        if (n2 > 127) {
            int n3 = n2 & 0x7F;
            if (n3 > 4) {
                throw new IllegalStateException("DER length more than 4 bytes: " + n3);
            }
            return n3 + 2;
        }
        return 2;
    }

    public boolean isConstructed() {
        return this.isConstructed;
    }

    public byte[] getContents() {
        return this.octets;
    }

    public int getApplicationTag() {
        return this.tag;
    }

    public ASN1Primitive getObject() throws IOException {
        return new ASN1InputStream(this.getContents()).readObject();
    }

    public ASN1Primitive getObject(int n2) throws IOException {
        if (n2 >= 31) {
            throw new IOException("unsupported tag number");
        }
        byte[] byArray = this.getEncoded();
        byte[] byArray2 = this.replaceTagNumber(n2, byArray);
        if ((byArray[0] & 0x20) != 0) {
            byArray2[0] = (byte)(byArray2[0] | 0x20);
        }
        return new ASN1InputStream(byArray2).readObject();
    }

    int encodedLength() throws IOException {
        return StreamUtil.calculateTagLength(this.tag) + StreamUtil.calculateBodyLength(this.octets.length) + this.octets.length;
    }

    void encode(ASN1OutputStream aSN1OutputStream) throws IOException {
        int n2 = 64;
        if (this.isConstructed) {
            n2 |= 0x20;
        }
        aSN1OutputStream.writeEncoded(n2, this.tag, this.octets);
    }

    boolean asn1Equals(ASN1Primitive aSN1Primitive) {
        if (!(aSN1Primitive instanceof DERApplicationSpecific)) {
            return false;
        }
        DERApplicationSpecific dERApplicationSpecific = (DERApplicationSpecific)aSN1Primitive;
        return this.isConstructed == dERApplicationSpecific.isConstructed && this.tag == dERApplicationSpecific.tag && Arrays.areEqual(this.octets, dERApplicationSpecific.octets);
    }

    public int hashCode() {
        return (this.isConstructed ? 1 : 0) ^ this.tag ^ Arrays.hashCode(this.octets);
    }

    private byte[] replaceTagNumber(int n2, byte[] byArray) throws IOException {
        int n3 = byArray[0] & 0x1F;
        int n4 = 1;
        if (n3 == 31) {
            int n5;
            n3 = 0;
            if (((n5 = byArray[n4++] & 0xFF) & 0x7F) == 0) {
                throw new ASN1ParsingException("corrupted stream - invalid high tag number found");
            }
            while (n5 >= 0 && (n5 & 0x80) != 0) {
                n3 |= n5 & 0x7F;
                n3 <<= 7;
                n5 = byArray[n4++] & 0xFF;
            }
            n3 |= n5 & 0x7F;
        }
        byte[] byArray2 = new byte[byArray.length - n4 + 1];
        System.arraycopy(byArray, n4, byArray2, 1, byArray2.length - 1);
        byArray2[0] = (byte)n2;
        return byArray2;
    }
}

